/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.EditText;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataMatcher;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

final class MetadataViewObserver
implements ViewTreeObserver.OnGlobalFocusChangeListener {
    private static final String TAG = MetadataViewObserver.class.getCanonicalName();
    private static final int MAX_TEXT_LENGTH = 100;
    private static final Map<Integer, MetadataViewObserver> observers = new HashMap<Integer, MetadataViewObserver>();
    private final Set<String> processedText = new HashSet<String>();
    private final Handler uiThreadHandler;
    private WeakReference<Activity> activityWeakReference;
    private AtomicBoolean isTracking;

    private MetadataViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.isTracking = new AtomicBoolean(false);
    }

    static void startTrackingActivity(Activity activity) {
        MetadataViewObserver observer;
        int key = activity.hashCode();
        if (!observers.containsKey(key)) {
            observer = new MetadataViewObserver(activity);
            observers.put(activity.hashCode(), observer);
        } else {
            observer = observers.get(key);
        }
        observer.startTracking();
    }

    static void stopTrackingActivity(Activity activity) {
        int key = activity.hashCode();
        if (observers.containsKey(key)) {
            MetadataViewObserver observer = observers.get(activity.hashCode());
            observers.remove(key);
            observer.stopTracking();
        }
    }

    private void startTracking() {
        if (this.isTracking.getAndSet(true)) {
            return;
        }
        View rootView = this.getRootView();
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (observer.isAlive()) {
            observer.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
        }
    }

    private void stopTracking() {
        if (!this.isTracking.getAndSet(false)) {
            return;
        }
        View rootView = this.getRootView();
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        observer.removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
    }

    public void onGlobalFocusChanged(@Nullable View oldView, @Nullable View newView) {
        if (oldView != null) {
            this.process(oldView);
        }
        if (newView != null) {
            this.process(newView);
        }
    }

    private void process(final View view) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    if (!(view instanceof EditText)) {
                        return;
                    }
                    MetadataViewObserver.this.processEditText(view);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        };
        this.runOnUIThread(runnable);
    }

    private void processEditText(View view) {
        String text = ((EditText)view).getText().toString().trim();
        if (text.isEmpty() || this.processedText.contains(text) || text.length() > 100) {
            return;
        }
        this.processedText.add(text);
        HashMap<String, String> userData = new HashMap<String, String>();
        List<String> currentViewIndicators = null;
        ArrayList<String> aroundTextIndicators = null;
        for (MetadataRule rule : MetadataRule.getRules()) {
            if (!MetadataMatcher.matchValue(text, rule.getValRule())) continue;
            if (currentViewIndicators == null) {
                currentViewIndicators = MetadataMatcher.getCurrentViewIndicators(view);
            }
            if (MetadataMatcher.matchIndicator(currentViewIndicators, rule.getKeyRules())) {
                userData.put(rule.getName(), text);
                continue;
            }
            if (aroundTextIndicators == null) {
                aroundTextIndicators = new ArrayList<String>();
                ViewGroup parentView = ViewHierarchy.getParentOfView(view);
                if (parentView == null) continue;
                for (View child : ViewHierarchy.getChildrenOfView((View)parentView)) {
                    if (view == child) continue;
                    aroundTextIndicators.addAll(MetadataMatcher.getTextIndicators(child));
                }
            }
            if (!MetadataMatcher.matchIndicator(aroundTextIndicators, rule.getKeyRules())) continue;
            userData.put(rule.getName(), text);
        }
        InternalAppEventsLogger.setInternalUserData(userData);
    }

    private void runOnUIThread(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.uiThreadHandler.post(runnable);
        }
    }

    @Nullable
    private View getRootView() {
        Activity activity = (Activity)this.activityWeakReference.get();
        if (activity == null) {
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return null;
        }
        return window.getDecorView().getRootView();
    }
}

