/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class AnalyticsUserIDStore {
    private static final String TAG = AnalyticsUserIDStore.class.getSimpleName();
    private static final String ANALYTICS_USER_ID_KEY = "com.facebook.appevents.AnalyticsUserIDStore.userID";
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static String userID;
    private static volatile boolean initialized;

    AnalyticsUserIDStore() {
    }

    public static void initStore() {
        if (initialized) {
            return;
        }
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    AnalyticsUserIDStore.initAndWait();
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    public static void setUserID(final String id) {
        AppEventUtility.assertIsNotMainThread();
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            AnalyticsUserIDStore.initAndWait();
        }
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    lock.writeLock().lock();
                    try {
                        userID = id;
                        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        editor.putString(AnalyticsUserIDStore.ANALYTICS_USER_ID_KEY, userID);
                        editor.apply();
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    public static String getUserID() {
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            AnalyticsUserIDStore.initAndWait();
        }
        lock.readLock().lock();
        try {
            String string = userID;
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static void initAndWait() {
        if (initialized) {
            return;
        }
        lock.writeLock().lock();
        try {
            if (initialized) {
                return;
            }
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            userID = sharedPreferences.getString(ANALYTICS_USER_ID_KEY, null);
            initialized = true;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    static {
        initialized = false;
    }
}

