/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;

public class GraphRequestAsyncTask
extends AsyncTask<Void, Void, List<GraphResponse>> {
    private static final String TAG = GraphRequestAsyncTask.class.getCanonicalName();
    private final HttpURLConnection connection;
    private final GraphRequestBatch requests;
    private Exception exception;

    public GraphRequestAsyncTask(GraphRequest ... requests) {
        this((HttpURLConnection)null, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(Collection<GraphRequest> requests) {
        this((HttpURLConnection)null, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(GraphRequestBatch requests) {
        this((HttpURLConnection)null, requests);
    }

    public GraphRequestAsyncTask(HttpURLConnection connection, GraphRequest ... requests) {
        this(connection, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(HttpURLConnection connection, Collection<GraphRequest> requests) {
        this(connection, new GraphRequestBatch(requests));
    }

    public GraphRequestAsyncTask(HttpURLConnection connection, GraphRequestBatch requests) {
        this.requests = requests;
        this.connection = connection;
    }

    protected final Exception getException() {
        return this.exception;
    }

    protected final GraphRequestBatch getRequests() {
        return this.requests;
    }

    public String toString() {
        return "{RequestAsyncTask: " + " connection: " + this.connection + ", requests: " + this.requests + "}";
    }

    protected void onPreExecute() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            super.onPreExecute();
            if (FacebookSdk.isDebugEnabled()) {
                Utility.logd(TAG, String.format("execute async task: %s", new Object[]{this}));
            }
            if (this.requests.getCallbackHandler() == null) {
                Handler handler = Thread.currentThread() instanceof HandlerThread ? new Handler() : new Handler(Looper.getMainLooper());
                this.requests.setCallbackHandler(handler);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onPostExecute(List<GraphResponse> list) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void result;
            super.onPostExecute((Object)result);
            if (this.exception != null) {
                Utility.logd(TAG, String.format("onPostExecute: exception encountered during request: %s", this.exception.getMessage()));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return;
        }
    }

    protected List<GraphResponse> doInBackground(Void ... voidArray) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            try {
                if (this.connection == null) {
                    return this.requests.executeAndWait();
                }
                return GraphRequest.executeConnectionAndWait(this.connection, this.requests);
            }
            catch (Exception e) {
                this.exception = e;
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, (Object)this);
            return null;
        }
    }
}

