/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashreport.CrashData;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class CrashShieldHandler {
    private static final Set<Object> sCrashingObjects = Collections.newSetFromMap(new WeakHashMap());

    public static void handleThrowable(Throwable t, Object o) {
        sCrashingObjects.add(o);
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            CrashData crashData = new CrashData(t, CrashData.Type.CrashShield);
            crashData.save();
        }
    }

    public static boolean isObjectCrashing(Object o) {
        return sCrashingObjects.contains(o);
    }

    public static void methodFinished(Object o) {
    }

    public static void reset() {
        CrashShieldHandler.resetCrashingObjects();
    }

    public static void resetCrashingObjects() {
        sCrashingObjects.clear();
    }
}

