/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CrashData {
    private static final String PARAM_TIMESTAMP = "timestamp";
    private static final String PARAM_APP_VERSION = "app_version";
    private static final String PARAM_DEVICE_OS = "device_os_version";
    private static final String PARAM_DEVICE_MODEL = "device_model";
    private static final String PARAM_REASON = "reason";
    private static final String PARAM_CALLSTACK = "callstack";
    private static final String PARAM_TYPE = "type";
    private String filename;
    @Nullable
    private String appVersion;
    @Nullable
    private String cause;
    @Nullable
    private String stackTrace;
    @Nullable
    private Long timestamp;
    @Nullable
    private String type;

    public CrashData(Throwable e, Type t) {
        this.appVersion = Utility.getAppVersion();
        this.cause = InstrumentUtility.getCause(e);
        this.stackTrace = InstrumentUtility.getStackTrace(e);
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.type = t.toString();
        this.filename = new StringBuffer().append("crash_log_").append(this.timestamp.toString()).append(".json").toString();
    }

    public CrashData(File file) {
        this.filename = file.getName();
        JSONObject object = InstrumentUtility.readFile(this.filename, true);
        if (object != null) {
            this.appVersion = object.optString(PARAM_APP_VERSION, null);
            this.cause = object.optString(PARAM_REASON, null);
            this.stackTrace = object.optString(PARAM_CALLSTACK, null);
            this.timestamp = object.optLong(PARAM_TIMESTAMP, 0L);
            this.type = object.optString(PARAM_TYPE, null);
        }
    }

    public int compareTo(CrashData data) {
        if (this.timestamp == null) {
            return -1;
        }
        if (data.timestamp == null) {
            return 1;
        }
        return data.timestamp.compareTo(this.timestamp);
    }

    public boolean isValid() {
        return this.stackTrace != null && this.timestamp != null;
    }

    public void save() {
        if (!this.isValid()) {
            return;
        }
        InstrumentUtility.writeFile(this.filename, this.toString());
    }

    public void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @Nullable
    public String toString() {
        JSONObject params = this.getParameters();
        if (params == null) {
            return null;
        }
        return params.toString();
    }

    @Nullable
    public JSONObject getParameters() {
        JSONObject object = new JSONObject();
        try {
            object.put(PARAM_DEVICE_OS, (Object)Build.VERSION.RELEASE);
            object.put(PARAM_DEVICE_MODEL, (Object)Build.MODEL);
            if (this.appVersion != null) {
                object.put(PARAM_APP_VERSION, (Object)this.appVersion);
            }
            if (this.timestamp != null) {
                object.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            if (this.cause != null) {
                object.put(PARAM_REASON, (Object)this.cause);
            }
            if (this.stackTrace != null) {
                object.put(PARAM_CALLSTACK, (Object)this.stackTrace);
            }
            if (this.type != null) {
                object.put(PARAM_TYPE, (Object)this.type);
            }
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static enum Type {
        CrashReport,
        CrashShield;


        public String toString() {
            String name = "unknown";
            switch (this) {
                case CrashReport: {
                    name = "CrashReport";
                    break;
                }
                case CrashShield: {
                    name = "CrashShield";
                }
            }
            return name;
        }
    }
}

