/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import com.facebook.appevents.codeless.internal.PathComponent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ParameterComponent {
    private static final String PARAMETER_NAME_KEY = "name";
    private static final String PARAMETER_PATH_KEY = "path";
    private static final String PARAMETER_VALUE_KEY = "value";
    public final String name;
    public final String value;
    public final List<PathComponent> path;
    public final String pathType;

    public ParameterComponent(JSONObject component) throws JSONException {
        this.name = component.getString(PARAMETER_NAME_KEY);
        this.value = component.optString(PARAMETER_VALUE_KEY);
        ArrayList<PathComponent> pathComponents = new ArrayList<PathComponent>();
        JSONArray jsonPathArray = component.optJSONArray(PARAMETER_PATH_KEY);
        if (null != jsonPathArray) {
            for (int i = 0; i < jsonPathArray.length(); ++i) {
                PathComponent pathComponent = new PathComponent(jsonPathArray.getJSONObject(i));
                pathComponents.add(pathComponent);
            }
        }
        this.path = pathComponents;
        this.pathType = component.optString("path_type", "absolute");
    }
}

