/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.view.autofill.AutofillManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.UserDataStore;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ProfileInformationCache;
import com.facebook.internal.Validate;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class Utility {
    static final String LOG_TAG = "FacebookSDK";
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    private static final String URL_SCHEME = "https";
    private static final String EXTRA_APP_EVENTS_INFO_FORMAT_VERSION = "a2";
    private static final String UTF8 = "UTF-8";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final int REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS = 1800000;
    private static final String noCarrierConstant = "NoCarrier";
    private static int numCPUCores = 0;
    private static long timestampOfLastCheck = -1L;
    private static long totalExternalStorageGB = -1L;
    private static long availableExternalStorageGB = -1L;
    private static String deviceTimezoneAbbreviation = "";
    private static String deviceTimeZoneName = "";
    private static String carrierName = "NoCarrier";
    private static final String ARC_DEVICE_PATTERN = ".+_cheets|cheets_.+";

    public static int[] intersectRanges(int[] range1, int[] range2) {
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        int[] outputRange = new int[range1.length + range2.length];
        int outputIndex = 0;
        int index1 = 0;
        int index2 = 0;
        while (index1 < range1.length && index2 < range2.length) {
            int newRangeLower = Integer.MIN_VALUE;
            int newRangeUpper = Integer.MAX_VALUE;
            int lower1 = range1[index1];
            int upper1 = Integer.MAX_VALUE;
            int lower2 = range2[index2];
            int upper2 = Integer.MAX_VALUE;
            if (index1 < range1.length - 1) {
                upper1 = range1[index1 + 1];
            }
            if (index2 < range2.length - 1) {
                upper2 = range2[index2 + 1];
            }
            if (lower1 < lower2) {
                if (upper1 > lower2) {
                    newRangeLower = lower2;
                    if (upper1 > upper2) {
                        newRangeUpper = upper2;
                        index2 += 2;
                    } else {
                        newRangeUpper = upper1;
                        index1 += 2;
                    }
                } else {
                    index1 += 2;
                }
            } else if (upper2 > lower1) {
                newRangeLower = lower1;
                if (upper2 > upper1) {
                    newRangeUpper = upper1;
                    index1 += 2;
                } else {
                    newRangeUpper = upper2;
                    index2 += 2;
                }
            } else {
                index2 += 2;
            }
            if (newRangeLower == Integer.MIN_VALUE) continue;
            outputRange[outputIndex++] = newRangeLower;
            if (newRangeUpper == Integer.MAX_VALUE) break;
            outputRange[outputIndex++] = newRangeUpper;
        }
        return Arrays.copyOf(outputRange, outputIndex);
    }

    public static <T> boolean isSubset(Collection<T> subset, Collection<T> superset) {
        if (superset == null || superset.size() == 0) {
            return subset == null || subset.size() == 0;
        }
        HashSet<T> hash = new HashSet<T>(superset);
        for (T t : subset) {
            if (hash.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String coerceValueIfNullOrEmpty(String s, String valueIfNullOrEmpty) {
        if (Utility.isNullOrEmpty(s)) {
            return valueIfNullOrEmpty;
        }
        return s;
    }

    public static <T> Collection<T> unmodifiableCollection(T ... ts) {
        return Collections.unmodifiableCollection(Arrays.asList(ts));
    }

    public static <T> ArrayList<T> arrayList(T ... ts) {
        ArrayList<T> arrayList = new ArrayList<T>(ts.length);
        for (T t : ts) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> HashSet<T> hashSet(T ... ts) {
        HashSet<T> hashSet = new HashSet<T>(ts.length);
        for (T t : ts) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static String md5hash(String key) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_MD5, key);
    }

    public static String sha1hash(String key) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA1, key);
    }

    public static String sha1hash(byte[] bytes) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA1, bytes);
    }

    @Nullable
    public static String sha256hash(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA256, key);
    }

    @Nullable
    public static String sha256hash(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA256, bytes);
    }

    private static String hashWithAlgorithm(String algorithm, String key) {
        return Utility.hashWithAlgorithm(algorithm, key.getBytes());
    }

    private static String hashWithAlgorithm(String algorithm, byte[] bytes) {
        MessageDigest hash;
        try {
            hash = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return Utility.hashBytes(hash, bytes);
    }

    private static String hashBytes(MessageDigest hash, byte[] bytes) {
        hash.update(bytes);
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b >> 0 & 0xF));
        }
        return builder.toString();
    }

    public static Uri buildUri(String authority, String path, Bundle parameters) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(authority);
        builder.path(path);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                Object parameter = parameters.get(key);
                if (!(parameter instanceof String)) continue;
                builder.appendQueryParameter(key, (String)parameter);
            }
        }
        return builder.build();
    }

    public static Bundle parseUrlQueryString(String queryString) {
        Bundle params = new Bundle();
        if (!Utility.isNullOrEmpty(queryString)) {
            String[] array;
            for (String parameter : array = queryString.split("&")) {
                String[] keyValuePair = parameter.split("=");
                try {
                    if (keyValuePair.length == 2) {
                        params.putString(URLDecoder.decode(keyValuePair[0], UTF8), URLDecoder.decode(keyValuePair[1], UTF8));
                        continue;
                    }
                    if (keyValuePair.length != 1) continue;
                    params.putString(URLDecoder.decode(keyValuePair[0], UTF8), "");
                }
                catch (UnsupportedEncodingException e) {
                    Utility.logd(LOG_TAG, e);
                }
            }
        }
        return params;
    }

    public static void putNonEmptyString(Bundle b, String key, String value) {
        if (!Utility.isNullOrEmpty(value)) {
            b.putString(key, value);
        }
    }

    public static void putCommaSeparatedStringList(Bundle b, String key, List<String> list) {
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            for (String string : list) {
                builder.append(string);
                builder.append(",");
            }
            String commaSeparated = "";
            if (builder.length() > 0) {
                commaSeparated = builder.substring(0, builder.length() - 1);
            }
            b.putString(key, commaSeparated);
        }
    }

    public static void putUri(Bundle b, String key, Uri uri) {
        if (uri != null) {
            Utility.putNonEmptyString(b, key, uri.toString());
        }
    }

    public static boolean putJSONValueInBundle(Bundle bundle, String key, Object value) {
        if (value == null) {
            bundle.remove(key);
        } else if (value instanceof Boolean) {
            bundle.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof boolean[]) {
            bundle.putBooleanArray(key, (boolean[])value);
        } else if (value instanceof Double) {
            bundle.putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof double[]) {
            bundle.putDoubleArray(key, (double[])value);
        } else if (value instanceof Integer) {
            bundle.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof int[]) {
            bundle.putIntArray(key, (int[])value);
        } else if (value instanceof Long) {
            bundle.putLong(key, ((Long)value).longValue());
        } else if (value instanceof long[]) {
            bundle.putLongArray(key, (long[])value);
        } else if (value instanceof String) {
            bundle.putString(key, (String)value);
        } else if (value instanceof JSONArray) {
            bundle.putString(key, value.toString());
        } else if (value instanceof JSONObject) {
            bundle.putString(key, value.toString());
        } else {
            return false;
        }
        return true;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void disconnectQuietly(URLConnection connection) {
        if (connection != null && connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public static String getMetadataApplicationId(Context context) {
        Validate.notNull(context, "context");
        FacebookSdk.sdkInitialize(context);
        return FacebookSdk.getApplicationId();
    }

    static Map<String, Object> convertJSONObjectToHashMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray keys = jsonObject.names();
        for (int i = 0; i < keys.length(); ++i) {
            try {
                String key = keys.getString(i);
                Map<String, Object> value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = Utility.convertJSONObjectToHashMap((JSONObject)value);
                }
                map.put(key, value);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return map;
    }

    public static Map<String, String> convertJSONObjectToStringMap(@NonNull JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = jsonObject.optString(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Object getStringPropertyAsJSON(JSONObject jsonObject, String key, String nonJSONPropertyKey) throws JSONException {
        Object value = jsonObject.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            if (nonJSONPropertyKey != null) {
                jsonObject = new JSONObject();
                jsonObject.putOpt(nonJSONPropertyKey, value);
                return jsonObject;
            }
            throw new FacebookException("Got an unexpected non-JSON object.");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamToString(InputStream inputStream) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[2048];
            int n = 0;
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
            throw throwable;
        }
        Utility.closeQuietly(bufferedInputStream);
        Utility.closeQuietly(reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        int totalBytes = 0;
        try {
            int bytesRead;
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[8192];
            while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                totalBytes += bytesRead;
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return totalBytes;
    }

    public static boolean stringsEqualOrEmpty(String a, String b) {
        boolean aEmpty = TextUtils.isEmpty((CharSequence)a);
        boolean bEmpty = TextUtils.isEmpty((CharSequence)b);
        if (aEmpty && bEmpty) {
            return true;
        }
        if (!aEmpty && !bEmpty) {
            return a.equals(b);
        }
        return false;
    }

    private static void clearCookiesForDomain(Context context, String domain) {
        String[] splitCookies;
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String cookies = cookieManager.getCookie(domain);
        if (cookies == null) {
            return;
        }
        for (String cookie : splitCookies = cookies.split(";")) {
            String[] cookieParts = cookie.split("=");
            if (cookieParts.length <= 0) continue;
            String newCookie = cookieParts[0].trim() + "=;expires=Sat, 1 Jan 2000 00:00:01 UTC;";
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }

    public static void clearFacebookCookies(Context context) {
        Utility.clearCookiesForDomain(context, "facebook.com");
        Utility.clearCookiesForDomain(context, ".facebook.com");
        Utility.clearCookiesForDomain(context, "https://facebook.com");
        Utility.clearCookiesForDomain(context, "https://.facebook.com");
    }

    public static void logd(String tag, Exception e) {
        if (FacebookSdk.isDebugEnabled() && tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    public static void logd(String tag, String msg) {
        if (FacebookSdk.isDebugEnabled() && tag != null && msg != null) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void logd(String tag, String msg, Throwable t) {
        if (FacebookSdk.isDebugEnabled() && !Utility.isNullOrEmpty(tag)) {
            Log.d((String)tag, (String)msg, (Throwable)t);
        }
    }

    public static <T> boolean areObjectsEqual(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean hasSameId(JSONObject a, JSONObject b) {
        if (a == null || b == null || !a.has("id") || !b.has("id")) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        String idA = a.optString("id");
        String idB = b.optString("id");
        if (idA == null || idB == null) {
            return false;
        }
        return idA.equals(idB);
    }

    public static String safeGetStringFromResponse(JSONObject response, String propertyName) {
        return response != null ? response.optString(propertyName, "") : "";
    }

    public static JSONObject tryGetJSONObjectFromResponse(JSONObject response, String propertyKey) {
        return response != null ? response.optJSONObject(propertyKey) : null;
    }

    public static JSONArray tryGetJSONArrayFromResponse(JSONObject response, String propertyKey) {
        return response != null ? response.optJSONArray(propertyKey) : null;
    }

    public static void clearCaches(Context context) {
        ImageDownloader.clearCache(context);
    }

    public static void deleteDirectory(File directoryOrFile) {
        File[] children;
        if (!directoryOrFile.exists()) {
            return;
        }
        if (directoryOrFile.isDirectory() && (children = directoryOrFile.listFiles()) != null) {
            for (File child : children) {
                Utility.deleteDirectory(child);
            }
        }
        directoryOrFile.delete();
    }

    public static <T> List<T> asListNoNulls(T ... array) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : array) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static List<String> jsonArrayToStringList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            result.add(jsonArray.getString(i));
        }
        return result;
    }

    public static Set<String> jsonArrayToSet(JSONArray jsonArray) throws JSONException {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            result.add(jsonArray.getString(i));
        }
        return result;
    }

    public static String mapToJsonStr(Map<String, String> map) {
        if (map.isEmpty()) {
            return "";
        }
        try {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            return jsonObject.toString();
        }
        catch (JSONException _e) {
            return "";
        }
    }

    public static Map<String, String> JsonStrToMap(String str) {
        if (str.isEmpty()) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject jsonObject = new JSONObject(str);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, jsonObject.getString(key));
            }
            return map;
        }
        catch (JSONException _e) {
            return new HashMap<String, String>();
        }
    }

    public static void setAppEventAttributionParameters(JSONObject params, AttributionIdentifiers attributionIdentifiers, String anonymousAppDeviceGUID, boolean limitEventUsage) throws JSONException {
        params.put("anon_id", (Object)anonymousAppDeviceGUID);
        params.put("application_tracking_enabled", !limitEventUsage);
        if (attributionIdentifiers != null) {
            String userData;
            if (attributionIdentifiers.getAttributionId() != null) {
                params.put("attribution", (Object)attributionIdentifiers.getAttributionId());
            }
            if (attributionIdentifiers.getAndroidAdvertiserId() != null) {
                params.put("advertiser_id", (Object)attributionIdentifiers.getAndroidAdvertiserId());
                params.put("advertiser_tracking_enabled", !attributionIdentifiers.isTrackingLimited());
            }
            if (!attributionIdentifiers.isTrackingLimited() && !(userData = UserDataStore.getAllHashedUserData()).isEmpty()) {
                params.put("ud", (Object)userData);
            }
            if (attributionIdentifiers.getAndroidInstallerPackage() != null) {
                params.put("installer_package", (Object)attributionIdentifiers.getAndroidInstallerPackage());
            }
        }
    }

    @Nullable
    public static String getAppVersion() {
        Context context = FacebookSdk.getApplicationContext();
        if (context == null) {
            return null;
        }
        String pkgName = context.getPackageName();
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(pkgName, 0);
            return pi.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static void setAppEventExtendedDeviceInfoParameters(JSONObject params, Context appContext) throws JSONException {
        Locale locale;
        JSONArray extraInfoArray = new JSONArray();
        extraInfoArray.put((Object)EXTRA_APP_EVENTS_INFO_FORMAT_VERSION);
        Utility.refreshPeriodicExtendedDeviceInfo(appContext);
        String pkgName = appContext.getPackageName();
        int versionCode = -1;
        String versionName = "";
        try {
            PackageInfo pi = appContext.getPackageManager().getPackageInfo(pkgName, 0);
            versionCode = pi.versionCode;
            versionName = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException pi) {
            // empty catch block
        }
        extraInfoArray.put((Object)pkgName);
        extraInfoArray.put(versionCode);
        extraInfoArray.put((Object)versionName);
        extraInfoArray.put((Object)Build.VERSION.RELEASE);
        extraInfoArray.put((Object)Build.MODEL);
        try {
            locale = appContext.getResources().getConfiguration().locale;
        }
        catch (Exception e) {
            locale = Locale.getDefault();
        }
        extraInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
        extraInfoArray.put((Object)deviceTimezoneAbbreviation);
        extraInfoArray.put((Object)carrierName);
        int width = 0;
        int height = 0;
        double density = 0.0;
        try {
            WindowManager wm = (WindowManager)appContext.getSystemService("window");
            if (wm != null) {
                Display display = wm.getDefaultDisplay();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getMetrics(displayMetrics);
                width = displayMetrics.widthPixels;
                height = displayMetrics.heightPixels;
                density = displayMetrics.density;
            }
        }
        catch (Exception wm) {
            // empty catch block
        }
        extraInfoArray.put(width);
        extraInfoArray.put(height);
        DecimalFormat df = new DecimalFormat("#.##");
        extraInfoArray.put((Object)df.format(density));
        extraInfoArray.put(Utility.refreshBestGuessNumberOfCPUCores());
        extraInfoArray.put(totalExternalStorageGB);
        extraInfoArray.put(availableExternalStorageGB);
        extraInfoArray.put((Object)deviceTimeZoneName);
        params.put("extinfo", (Object)extraInfoArray.toString());
    }

    public static Method getMethodQuietly(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodQuietly(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            return Utility.getMethodQuietly(clazz, methodName, parameterTypes);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Object invokeMethodQuietly(Object receiver, Method method, Object ... args) {
        try {
            return method.invoke(receiver, args);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
    }

    public static String getActivityName(Context context) {
        if (context == null) {
            return "null";
        }
        if (context == context.getApplicationContext()) {
            return "unknown";
        }
        return context.getClass().getSimpleName();
    }

    public static <T> List<T> filter(List<T> target, Predicate<T> predicate) {
        if (target == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : target) {
            if (!predicate.apply(item)) continue;
            list.add(item);
        }
        return list.size() == 0 ? null : list;
    }

    public static <T, K> List<K> map(List<T> target, Mapper<T, K> mapper) {
        if (target == null) {
            return null;
        }
        ArrayList<K> list = new ArrayList<K>();
        for (T item : target) {
            K mappedItem = mapper.apply(item);
            if (mappedItem == null) continue;
            list.add(mappedItem);
        }
        return list.size() == 0 ? null : list;
    }

    public static String getUriString(Uri uri) {
        return uri == null ? null : uri.toString();
    }

    public static boolean isWebUri(Uri uri) {
        return uri != null && ("http".equalsIgnoreCase(uri.getScheme()) || URL_SCHEME.equalsIgnoreCase(uri.getScheme()) || "fbstaging".equalsIgnoreCase(uri.getScheme()));
    }

    public static boolean isContentUri(Uri uri) {
        return uri != null && "content".equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isFileUri(Uri uri) {
        return uri != null && "file".equalsIgnoreCase(uri.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentSize(Uri contentUri) {
        try (Cursor cursor = null;){
            cursor = FacebookSdk.getApplicationContext().getContentResolver().query(contentUri, null, null, null, null);
            int sizeIndex = cursor.getColumnIndex("_size");
            cursor.moveToFirst();
            long l = cursor.getLong(sizeIndex);
            return l;
        }
    }

    public static Date getBundleLongAsDate(Bundle bundle, String key, Date dateBase) {
        long secondsFromBase;
        if (bundle == null) {
            return null;
        }
        Object secondsObject = bundle.get(key);
        if (secondsObject instanceof Long) {
            secondsFromBase = (Long)secondsObject;
        } else if (secondsObject instanceof String) {
            try {
                secondsFromBase = Long.parseLong((String)secondsObject);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        if (secondsFromBase == 0L) {
            return new Date(Long.MAX_VALUE);
        }
        return new Date(dateBase.getTime() + secondsFromBase * 1000L);
    }

    public static void writeStringMapToParcel(Parcel parcel, Map<String, String> map) {
        if (map == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                parcel.writeString(entry.getKey());
                parcel.writeString(entry.getValue());
            }
        }
    }

    public static Map<String, String> readStringMapFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            map.put(parcel.readString(), parcel.readString());
        }
        return map;
    }

    public static boolean isCurrentAccessToken(AccessToken token) {
        return token != null && token.equals(AccessToken.getCurrentAccessToken());
    }

    public static void getGraphMeRequestWithCacheAsync(final String accessToken, final GraphMeRequestWithCacheCallback callback) {
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            callback.onSuccess(cachedValue);
            return;
        }
        GraphRequest.Callback graphCallback = new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                if (response.getError() != null) {
                    callback.onFailure(response.getError().getException());
                } else {
                    ProfileInformationCache.putProfileInformation(accessToken, response.getJSONObject());
                    callback.onSuccess(response.getJSONObject());
                }
            }
        };
        GraphRequest graphRequest = Utility.getGraphMeRequestWithCache(accessToken);
        graphRequest.setCallback(graphCallback);
        graphRequest.executeAsync();
    }

    public static JSONObject awaitGetGraphMeRequestWithCache(String accessToken) {
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            return cachedValue;
        }
        GraphRequest graphRequest = Utility.getGraphMeRequestWithCache(accessToken);
        GraphResponse response = graphRequest.executeAndWait();
        if (response.getError() != null) {
            return null;
        }
        return response.getJSONObject();
    }

    private static GraphRequest getGraphMeRequestWithCache(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id,name,first_name,middle_name,last_name,link");
        parameters.putString("access_token", accessToken);
        GraphRequest graphRequest = new GraphRequest(null, "me", parameters, HttpMethod.GET, null);
        return graphRequest;
    }

    private static int refreshBestGuessNumberOfCPUCores() {
        if (numCPUCores > 0) {
            return numCPUCores;
        }
        try {
            File cpuDir = new File("/sys/devices/system/cpu/");
            File[] cpuFiles = cpuDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return Pattern.matches("cpu[0-9]+", fileName);
                }
            });
            if (cpuFiles != null) {
                numCPUCores = cpuFiles.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numCPUCores <= 0) {
            numCPUCores = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        }
        return numCPUCores;
    }

    private static void refreshPeriodicExtendedDeviceInfo(Context appContext) {
        if (timestampOfLastCheck == -1L || System.currentTimeMillis() - timestampOfLastCheck >= 1800000L) {
            timestampOfLastCheck = System.currentTimeMillis();
            Utility.refreshTimezone();
            Utility.refreshCarrierName(appContext);
            Utility.refreshTotalExternalStorage();
            Utility.refreshAvailableExternalStorage();
        }
    }

    private static void refreshTimezone() {
        try {
            TimeZone tz = TimeZone.getDefault();
            deviceTimezoneAbbreviation = tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
            deviceTimeZoneName = tz.getID();
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void refreshCarrierName(Context appContext) {
        if (carrierName.equals(noCarrierConstant)) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)appContext.getSystemService("phone");
                carrierName = telephonyManager.getNetworkOperatorName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean externalStorageExists() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private static void refreshAvailableExternalStorage() {
        try {
            if (Utility.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                availableExternalStorageGB = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
            }
            availableExternalStorageGB = Utility.convertBytesToGB(availableExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void refreshTotalExternalStorage() {
        try {
            if (Utility.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                totalExternalStorageGB = (long)stat.getBlockCount() * (long)stat.getBlockSize();
            }
            totalExternalStorageGB = Utility.convertBytesToGB(totalExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static long convertBytesToGB(double bytes) {
        return Math.round(bytes / 1.073741824E9);
    }

    public static PermissionsLists handlePermissionResponse(JSONObject result) throws JSONException {
        JSONObject permissions = result.getJSONObject("permissions");
        JSONArray data = permissions.getJSONArray("data");
        ArrayList<String> grantedPermissions = new ArrayList<String>(data.length());
        ArrayList<String> declinedPermissions = new ArrayList<String>(data.length());
        ArrayList<String> expiredPermissions = new ArrayList<String>(data.length());
        for (int i = 0; i < data.length(); ++i) {
            String status;
            JSONObject object = data.optJSONObject(i);
            String permission2 = object.optString("permission");
            if (permission2 == null || permission2.equals("installed") || (status = object.optString("status")) == null) continue;
            if (status.equals("granted")) {
                grantedPermissions.add(permission2);
                continue;
            }
            if (status.equals("declined")) {
                declinedPermissions.add(permission2);
                continue;
            }
            if (!status.equals("expired")) continue;
            expiredPermissions.add(permission2);
        }
        return new PermissionsLists(grantedPermissions, declinedPermissions, expiredPermissions);
    }

    public static String generateRandomString(int length) {
        Random r = new Random();
        return new BigInteger(length * 5, r).toString(32);
    }

    public static boolean mustFixWindowParamsForAutofill(Context context) {
        return Utility.isAutofillAvailable(context);
    }

    public static boolean isAutofillAvailable(Context context) {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        AutofillManager afm = (AutofillManager)context.getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillSupported() && afm.isEnabled();
    }

    public static boolean isChromeOS(Context context) {
        boolean isChromeOS = Build.VERSION.SDK_INT >= 27 ? context.getPackageManager().hasSystemFeature("android.hardware.type.pc") : Build.DEVICE != null && Build.DEVICE.matches(ARC_DEVICE_PATTERN);
        return isChromeOS;
    }

    @Nullable
    public static Locale getResourceLocale() {
        try {
            return FacebookSdk.getApplicationContext().getResources().getConfiguration().locale;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Locale getCurrentLocale() {
        Locale locale = Utility.getResourceLocale();
        return locale != null ? locale : Locale.getDefault();
    }

    public static void runOnNonUiThread(Runnable runnable) {
        try {
            FacebookSdk.getExecutor().execute(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getAppName(Context context) {
        try {
            String applicationName = FacebookSdk.getApplicationName();
            if (applicationName != null) {
                return applicationName;
            }
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static class PermissionsLists {
        List<String> grantedPermissions;
        List<String> declinedPermissions;
        List<String> expiredPermissions;

        public PermissionsLists(List<String> grantedPermissions, List<String> declinedPermissions, List<String> expiredPermissions) {
            this.grantedPermissions = grantedPermissions;
            this.declinedPermissions = declinedPermissions;
            this.expiredPermissions = expiredPermissions;
        }

        public List<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }

        public List<String> getDeclinedPermissions() {
            return this.declinedPermissions;
        }

        public List<String> getExpiredPermissions() {
            return this.expiredPermissions;
        }
    }

    public static interface GraphMeRequestWithCacheCallback {
        public void onSuccess(JSONObject var1);

        public void onFailure(FacebookException var1);
    }

    public static interface Mapper<T, K> {
        public K apply(T var1);
    }

    public static interface Predicate<T> {
        public boolean apply(T var1);
    }
}

