/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.ml.Model;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ModelManager {
    public static final String MODEL_SUGGESTED_EVENTS = "SUGGEST_EVENT";
    private static final ConcurrentMap<String, Model> models = new ConcurrentHashMap<String, Model>();
    private static final String SDK_MODEL_ASSET = "%s/model_asset";
    private static SharedPreferences shardPreferences;
    private static final String MODEL_ASSERT_STORE = "com.facebook.internal.MODEL_STORE";
    private static final String CACHE_KEY_MODELS = "models";
    private static final String[] APP_SETTING_FIELDS;

    public static void enable() {
        ModelManager.initialize();
    }

    public static void initialize() {
        shardPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(MODEL_ASSERT_STORE, 0);
        ModelManager.initializeModels();
    }

    private static void initializeModels() {
        Utility.runOnNonUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject modelJSON = ModelManager.fetchFromServer();
                    if (modelJSON != null) {
                        shardPreferences.edit().putString(ModelManager.CACHE_KEY_MODELS, modelJSON.toString()).apply();
                    } else {
                        modelJSON = new JSONObject(shardPreferences.getString(ModelManager.CACHE_KEY_MODELS, ""));
                    }
                    ModelManager.addModelsFromModelJson(modelJSON);
                    ModelManager.enableSuggestedEvents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static void addModelsFromModelJson(JSONObject modelJSON) {
        Iterator keys = modelJSON.keys();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Model model = ModelManager.jsonObjectToModel(modelJSON.getJSONObject(key));
                if (model == null) continue;
                models.put(key, model);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static JSONObject parseRawJsonObject(JSONObject jsonObject) {
        JSONObject resultJsonObject = new JSONObject();
        try {
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject curJsonObject = jsonArray.getJSONObject(i);
                JSONObject tempJsonObject = new JSONObject();
                tempJsonObject.put("version_id", (Object)curJsonObject.getString("version_id"));
                tempJsonObject.put("use_case", (Object)curJsonObject.getString("use_case"));
                tempJsonObject.put("thresholds", (Object)curJsonObject.getJSONArray("thresholds"));
                tempJsonObject.put("asset_uri", (Object)curJsonObject.getString("asset_uri"));
                if (curJsonObject.has("rules_uri")) {
                    tempJsonObject.put("rules_uri", (Object)curJsonObject.getString("rules_uri"));
                }
                resultJsonObject.put(curJsonObject.getString("use_case"), (Object)tempJsonObject);
            }
            return resultJsonObject;
        }
        catch (JSONException je) {
            return new JSONObject();
        }
    }

    @Nullable
    private static JSONObject fetchFromServer() {
        ArrayList<String> appSettingFields = new ArrayList<String>(Arrays.asList(APP_SETTING_FIELDS));
        Bundle appSettingsParams = new Bundle();
        appSettingsParams.putString("fields", TextUtils.join((CharSequence)",", appSettingFields));
        GraphRequest graphRequest = GraphRequest.newGraphPathRequest(null, String.format(SDK_MODEL_ASSET, FacebookSdk.getApplicationId()), null);
        graphRequest.setSkipClientToken(true);
        graphRequest.setParameters(appSettingsParams);
        JSONObject rawResponse = graphRequest.executeAndWait().getJSONObject();
        if (rawResponse == null) {
            return null;
        }
        return ModelManager.parseRawJsonObject(rawResponse);
    }

    @Nullable
    private static Model jsonObjectToModel(JSONObject jsonObject) {
        try {
            String useCase = jsonObject.getString("use_case");
            String assetUrl = jsonObject.getString("asset_uri");
            JSONArray threshold = jsonObject.getJSONArray("thresholds");
            int versionId = Integer.parseInt(jsonObject.getString("version_id"));
            String ruleUri = jsonObject.optString("rules_uri");
            return new Model(useCase, versionId, assetUrl, ruleUri, ModelManager.parseJsonArray(threshold));
        }
        catch (JSONException je) {
            return null;
        }
    }

    private static void enableSuggestedEvents() {
        if (!models.containsKey(MODEL_SUGGESTED_EVENTS)) {
            return;
        }
        Locale locale = Utility.getResourceLocale();
        if (locale != null && !locale.getLanguage().contains("en")) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.SuggestedEvents, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (!enabled) {
                    return;
                }
                Model model = (Model)models.get(ModelManager.MODEL_SUGGESTED_EVENTS);
                model.initialize(new Runnable(){

                    @Override
                    public void run() {
                        SuggestedEventsManager.enable();
                    }
                });
            }
        });
    }

    private static float[] parseJsonArray(JSONArray jsonArray) {
        float[] thresholds = new float[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                thresholds[i] = Float.parseFloat(jsonArray.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return thresholds;
    }

    @Nullable
    public static String predict(String useCase, float[] dense, String text) {
        if (!models.containsKey(useCase)) {
            return null;
        }
        return ((Model)models.get(useCase)).predict(dense, text);
    }

    @Nullable
    public static File getRuleFile(String useCase) {
        if (!models.containsKey(useCase)) {
            return null;
        }
        return ((Model)models.get(useCase)).getRuleFile();
    }

    static {
        APP_SETTING_FIELDS = new String[]{"version_id", "asset_uri", "use_case", "thresholds", "rules_uri"};
    }
}

