/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.view.NestedScrollingChild;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.internal.Utility;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewHierarchy {
    private static final String TAG = ViewHierarchy.class.getCanonicalName();
    private static final String CLASS_RCTROOTVIEW = "com.facebook.react.ReactRootView";
    private static final String CLASS_RCTTEXTVIEW = "com.facebook.react.views.view.ReactTextView";
    private static final String CLASS_RCTVIEWGROUP = "com.facebook.react.views.view.ReactViewGroup";
    private static final String CLASS_TOUCHTARGETHELPER = "com.facebook.react.uimanager.TouchTargetHelper";
    private static final String METHOD_FIND_TOUCHTARGET_VIEW = "findTouchTargetView";
    private static final int ICON_MAX_EDGE_LENGTH = 44;
    private static WeakReference<View> RCTRootViewReference = new WeakReference<Object>(null);
    @Nullable
    private static Method methodFindTouchTargetView = null;

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static ViewGroup getParentOfView(View view) {
        if (null == view) {
            return null;
        }
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            return (ViewGroup)parent;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static List<View> getChildrenOfView(View view) {
        ArrayList<View> children = new ArrayList<View>();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                children.add(viewGroup.getChildAt(i));
            }
        }
        return children;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static void updateBasicInfoOfView(View view, JSONObject json) {
        try {
            String text = ViewHierarchy.getTextOfView(view);
            String hint = ViewHierarchy.getHintOfView(view);
            Object tag = view.getTag();
            CharSequence description = view.getContentDescription();
            json.put("classname", (Object)view.getClass().getCanonicalName());
            json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view));
            json.put("id", view.getId());
            if (!SensitiveUserDataUtils.isSensitiveUserData(view)) {
                json.put("text", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), ""));
            } else {
                json.put("text", (Object)"");
                json.put("is_user_input", true);
            }
            json.put("hint", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(hint), ""));
            if (tag != null) {
                json.put("tag", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(tag.toString()), ""));
            }
            if (description != null) {
                json.put("description", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(description.toString()), ""));
            }
            JSONObject dimension = ViewHierarchy.getDimensionOfView(view);
            json.put("dimension", (Object)dimension);
        }
        catch (JSONException e) {
            Utility.logd(TAG, (Exception)((Object)e));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static void updateAppearanceOfView(View view, JSONObject json, float displayDensity) {
        try {
            Bitmap bitmap;
            Drawable drawable;
            TextView textView;
            Typeface typeface;
            JSONObject textStyle = new JSONObject();
            if (view instanceof TextView && (typeface = (textView = (TextView)view).getTypeface()) != null) {
                textStyle.put("font_size", (double)textView.getTextSize());
                textStyle.put("is_bold", typeface.isBold());
                textStyle.put("is_italic", typeface.isItalic());
                json.put("text_style", (Object)textStyle);
            }
            if (view instanceof ImageView && (drawable = ((ImageView)view).getDrawable()) instanceof BitmapDrawable && (float)view.getHeight() / displayDensity <= 44.0f && (float)view.getWidth() / displayDensity <= 44.0f && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                json.put("icon_image", (Object)encoded);
            }
        }
        catch (JSONException e) {
            Utility.logd(TAG, (Exception)((Object)e));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static JSONObject getDictionaryOfView(View view) {
        if (view.getClass().getName().equals(CLASS_RCTROOTVIEW)) {
            RCTRootViewReference = new WeakReference<View>(view);
        }
        JSONObject json = new JSONObject();
        try {
            ViewHierarchy.updateBasicInfoOfView(view, json);
            JSONArray childViews = new JSONArray();
            List<View> children = ViewHierarchy.getChildrenOfView(view);
            for (int i = 0; i < children.size(); ++i) {
                View child = children.get(i);
                JSONObject childInfo = ViewHierarchy.getDictionaryOfView(child);
                childViews.put((Object)childInfo);
            }
            json.put("childviews", (Object)childViews);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create JSONObject for view.", (Throwable)e);
        }
        return json;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static int getClassTypeBitmask(View view) {
        int bitmask = 0;
        if (view instanceof ImageView) {
            bitmask |= 2;
        }
        if (view.isClickable()) {
            bitmask |= 0x20;
        }
        if (ViewHierarchy.isAdapterViewItem(view)) {
            bitmask |= 0x200;
        }
        if (view instanceof TextView) {
            bitmask |= 0x400;
            bitmask |= 1;
            if (view instanceof Button) {
                bitmask |= 4;
                if (view instanceof Switch) {
                    bitmask |= 0x2000;
                } else if (view instanceof CheckBox) {
                    bitmask |= 0x8000;
                }
            }
            if (view instanceof EditText) {
                bitmask |= 0x800;
            }
        } else if (view instanceof Spinner || view instanceof DatePicker) {
            bitmask |= 0x1000;
        } else if (view instanceof RatingBar) {
            bitmask |= 0x10000;
        } else if (view instanceof RadioGroup) {
            bitmask |= 0x4000;
        } else if (view instanceof ViewGroup && ViewHierarchy.isRCTButton(view, (View)RCTRootViewReference.get())) {
            bitmask |= 0x40;
        }
        return bitmask;
    }

    private static boolean isAdapterViewItem(View view) {
        ViewParent parent = view.getParent();
        return parent instanceof AdapterView || parent instanceof NestedScrollingChild;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static String getTextOfView(View view) {
        CharSequence textObj = null;
        if (view instanceof TextView) {
            textObj = ((TextView)view).getText();
            if (view instanceof Switch) {
                boolean isOn = ((Switch)view).isChecked();
                textObj = isOn ? "1" : "0";
            }
        } else if (view instanceof Spinner) {
            Object selectedItem;
            Spinner spinner = (Spinner)view;
            if (spinner.getCount() > 0 && (selectedItem = ((Spinner)view).getSelectedItem()) != null) {
                textObj = selectedItem.toString();
            }
        } else if (view instanceof DatePicker) {
            DatePicker picker = (DatePicker)view;
            int y = picker.getYear();
            int m = picker.getMonth();
            int d = picker.getDayOfMonth();
            textObj = String.format("%04d-%02d-%02d", y, m, d);
        } else if (view instanceof TimePicker) {
            TimePicker picker = (TimePicker)view;
            int h = picker.getCurrentHour();
            int m = picker.getCurrentMinute();
            textObj = String.format("%02d:%02d", h, m);
        } else if (view instanceof RadioGroup) {
            RadioGroup radioGroup = (RadioGroup)view;
            int checkedId = radioGroup.getCheckedRadioButtonId();
            int childCount = radioGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = radioGroup.getChildAt(i);
                if (child.getId() != checkedId || !(child instanceof RadioButton)) continue;
                textObj = ((RadioButton)child).getText();
                break;
            }
        } else if (view instanceof RatingBar) {
            RatingBar bar = (RatingBar)view;
            float rating = bar.getRating();
            textObj = String.valueOf(rating);
        }
        return textObj == null ? "" : ((Object)textObj).toString();
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static String getHintOfView(View view) {
        CharSequence hintObj = null;
        if (view instanceof EditText) {
            hintObj = ((EditText)view).getHint();
        } else if (view instanceof TextView) {
            hintObj = ((TextView)view).getHint();
        }
        return hintObj == null ? "" : hintObj.toString();
    }

    private static JSONObject getDimensionOfView(View view) {
        JSONObject dimension = new JSONObject();
        try {
            dimension.put("top", view.getTop());
            dimension.put("left", view.getLeft());
            dimension.put("width", view.getWidth());
            dimension.put("height", view.getHeight());
            dimension.put("scrollx", view.getScrollX());
            dimension.put("scrolly", view.getScrollY());
            dimension.put("visibility", view.getVisibility());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create JSONObject for dimension.", (Throwable)e);
        }
        return dimension;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static View.OnClickListener getExistingOnClickListener(View view) {
        try {
            Object listenerObj;
            Field listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
            if (listenerInfoField != null) {
                listenerInfoField.setAccessible(true);
            }
            if ((listenerObj = listenerInfoField.get(view)) == null) {
                return null;
            }
            View.OnClickListener listener = null;
            Field listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
            if (listenerField != null) {
                listenerField.setAccessible(true);
                listener = (View.OnClickListener)listenerField.get(listenerObj);
            }
            return listener;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static View.OnTouchListener getExistingOnTouchListener(View view) {
        try {
            Object listenerObj;
            Field listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
            if (listenerInfoField != null) {
                listenerInfoField.setAccessible(true);
            }
            if ((listenerObj = listenerInfoField.get(view)) == null) {
                return null;
            }
            View.OnTouchListener listener = null;
            Field listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnTouchListener");
            if (listenerField != null) {
                listenerField.setAccessible(true);
                listener = (View.OnTouchListener)listenerField.get(listenerObj);
            }
            return listener;
        }
        catch (NoSuchFieldException e) {
            Utility.logd(TAG, e);
        }
        catch (ClassNotFoundException e) {
            Utility.logd(TAG, e);
        }
        catch (IllegalAccessException e) {
            Utility.logd(TAG, e);
        }
        return null;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static View getTouchReactView(float[] location, @Nullable View RCTRootView) {
        ViewHierarchy.initTouchTargetHelperMethods();
        if (null == methodFindTouchTargetView || null == RCTRootView) {
            return null;
        }
        try {
            View nativeTargetView = (View)methodFindTouchTargetView.invoke(null, location, RCTRootView);
            if (nativeTargetView != null && nativeTargetView.getId() > 0) {
                View reactTargetView = (View)nativeTargetView.getParent();
                return reactTargetView != null ? reactTargetView : null;
            }
        }
        catch (IllegalAccessException e) {
            Utility.logd(TAG, e);
        }
        catch (InvocationTargetException e) {
            Utility.logd(TAG, e);
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static boolean isRCTButton(View view, @Nullable View RCTRootView) {
        String className = view.getClass().getName();
        if (className.equals(CLASS_RCTVIEWGROUP)) {
            float[] location = ViewHierarchy.getViewLocationOnScreen(view);
            View touchTargetView = ViewHierarchy.getTouchReactView(location, RCTRootView);
            return touchTargetView != null && touchTargetView.getId() == view.getId();
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static boolean isRCTRootView(View view) {
        return view.getClass().getName().equals(CLASS_RCTROOTVIEW);
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static boolean isRCTTextView(View view) {
        return view.getClass().getName().equals(CLASS_RCTTEXTVIEW);
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static boolean isRCTViewGroup(View view) {
        return view.getClass().getName().equals(CLASS_RCTVIEWGROUP);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static View findRCTRootView(View view) {
        while (null != view) {
            if (ViewHierarchy.isRCTRootView(view)) {
                return view;
            }
            ViewParent viewParent = view.getParent();
            if (!(viewParent instanceof View)) break;
            view = (View)viewParent;
        }
        return null;
    }

    private static float[] getViewLocationOnScreen(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        float[] result = new float[]{location[0], location[1]};
        return result;
    }

    private static void initTouchTargetHelperMethods() {
        if (null != methodFindTouchTargetView) {
            return;
        }
        try {
            Class<?> RCTTouchTargetHelper = Class.forName(CLASS_TOUCHTARGETHELPER);
            methodFindTouchTargetView = RCTTouchTargetHelper.getDeclaredMethod(METHOD_FIND_TOUCHTARGET_VIEW, float[].class, ViewGroup.class);
            methodFindTouchTargetView.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            Utility.logd(TAG, e);
        }
        catch (NoSuchMethodException e) {
            Utility.logd(TAG, e);
        }
    }
}

