/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.aam.MetadataViewObserver;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MetadataIndexer {
    private static final String TAG = MetadataIndexer.class.getCanonicalName();
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    public static void onActivityResumed(Activity activity) {
        try {
            if (!enabled.get() || MetadataRule.getRules().isEmpty()) {
                return;
            }
            MetadataViewObserver.startTrackingActivity(activity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updateRules() {
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
        if (settings == null) {
            return;
        }
        String rawRule = settings.getRawAamRules();
        if (rawRule == null) {
            return;
        }
        MetadataRule.updateRules(rawRule);
    }

    public static void enable() {
        try {
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Context context = FacebookSdk.getApplicationContext();
                    if (!AttributionIdentifiers.isTrackingLimited(context)) {
                        enabled.set(true);
                        MetadataIndexer.updateRules();
                    }
                }
            });
        }
        catch (Exception e) {
            Utility.logd(TAG, e);
        }
    }
}

