/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.support.annotation.Nullable;
import android.util.Patterns;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class FeatureExtractor {
    private static final int NUM_OF_FEATURES = 30;
    private static final String REGEX_CR_PASSWORD_FIELD = "password";
    private static final String REGEX_CR_HAS_CONFIRM_PASSWORD_FIELD = "(?i)(confirm.*password)|(password.*(confirmation|confirm)|confirmation)";
    private static final String REGEX_CR_HAS_LOG_IN_KEYWORDS = "(?i)(sign in)|login|signIn";
    private static final String REGEX_CR_HAS_SIGN_ON_KEYWORDS = "(?i)(sign.*(up|now)|registration|register|(create|apply).*(profile|account)|open.*account|account.*(open|creation|application)|enroll|join.*now)";
    private static final String REGEX_ADD_TO_CART_BUTTON_TEXT = "(?i)add to(\\s|\\Z)|update(\\s|\\Z)|cart";
    private static final String REGEX_ADD_TO_CART_PAGE_TITLE = "(?i)add to(\\s|\\Z)|update(\\s|\\Z)|cart|shop|buy";
    private static Map<String, String> languageInfo;
    private static Map<String, String> eventInfo;
    private static Map<String, String> textTypeInfo;
    private static JSONObject rules;
    private static boolean initialized;

    FeatureExtractor() {
    }

    static void initialize(File file) {
        try {
            rules = new JSONObject();
            FileInputStream inputStream = new FileInputStream(file);
            int size = ((InputStream)inputStream).available();
            byte[] buffer = new byte[size];
            ((InputStream)inputStream).read(buffer);
            ((InputStream)inputStream).close();
            rules = new JSONObject(new String(buffer, "UTF-8"));
        }
        catch (Exception ex) {
            return;
        }
        languageInfo = new HashMap<String, String>();
        languageInfo.put("ENGLISH", "1");
        languageInfo.put("GERMAN", "2");
        languageInfo.put("SPANISH", "3");
        languageInfo.put("JAPANESE", "4");
        eventInfo = new HashMap<String, String>();
        eventInfo.put("VIEW_CONTENT", "0");
        eventInfo.put("SEARCH", "1");
        eventInfo.put("ADD_TO_CART", "2");
        eventInfo.put("ADD_TO_WISHLIST", "3");
        eventInfo.put("INITIATE_CHECKOUT", "4");
        eventInfo.put("ADD_PAYMENT_INFO", "5");
        eventInfo.put("PURCHASE", "6");
        eventInfo.put("LEAD", "7");
        eventInfo.put("COMPLETE_REGISTRATION", "8");
        textTypeInfo = new HashMap<String, String>();
        textTypeInfo.put("BUTTON_TEXT", "1");
        textTypeInfo.put("PAGE_TITLE", "2");
        textTypeInfo.put("RESOLVED_DOCUMENT_LINK", "3");
        textTypeInfo.put("BUTTON_ID", "4");
        initialized = true;
    }

    static boolean isInitialized() {
        return initialized;
    }

    static String getTextFeature(String buttonText, String activityName, String appName) {
        return appName + "|" + activityName + "," + buttonText;
    }

    @Nullable
    static float[] getDenseFeatures(JSONObject viewHierarchy, String appName) {
        if (!initialized) {
            return null;
        }
        float[] ret = new float[30];
        Arrays.fill(ret, 0.0f);
        try {
            appName = appName.toLowerCase();
            JSONObject viewTree = new JSONObject(viewHierarchy.optJSONObject("view").toString());
            String screenName = viewHierarchy.optString("screenname");
            JSONArray siblings = new JSONArray();
            FeatureExtractor.pruneTree(viewTree, siblings);
            float[] parseResult = FeatureExtractor.parseFeatures(viewTree);
            FeatureExtractor.sum(ret, parseResult);
            JSONObject interactedNode = FeatureExtractor.getInteractedNode(viewTree);
            if (interactedNode == null) {
                return null;
            }
            float[] nonparseFeatures = FeatureExtractor.nonparseFeatures(interactedNode, siblings, screenName, viewTree.toString(), appName);
            FeatureExtractor.sum(ret, nonparseFeatures);
            return ret;
        }
        catch (JSONException jSONException) {
            return ret;
        }
    }

    private static float[] parseFeatures(JSONObject node) {
        float[] densefeat = new float[30];
        Arrays.fill(densefeat, 0.0f);
        String text = node.optString("text").toLowerCase();
        String hint = node.optString("hint").toLowerCase();
        String className = node.optString("classname").toLowerCase();
        int inputType = node.optInt("inputtype", -1);
        String[] textValues = new String[]{text, hint};
        if (FeatureExtractor.matchIndicators(new String[]{"$", "amount", "price", "total"}, textValues)) {
            densefeat[0] = (float)((double)densefeat[0] + 1.0);
        }
        if (FeatureExtractor.matchIndicators(new String[]{REGEX_CR_PASSWORD_FIELD, "pwd"}, textValues)) {
            densefeat[1] = (float)((double)densefeat[1] + 1.0);
        }
        if (FeatureExtractor.matchIndicators(new String[]{"tel", "phone"}, textValues)) {
            densefeat[2] = (float)((double)densefeat[2] + 1.0);
        }
        if (FeatureExtractor.matchIndicators(new String[]{"search"}, textValues)) {
            densefeat[4] = (float)((double)densefeat[4] + 1.0);
        }
        if (inputType >= 0) {
            densefeat[5] = (float)((double)densefeat[5] + 1.0);
        }
        if (inputType == 3 || inputType == 2) {
            densefeat[6] = (float)((double)densefeat[6] + 1.0);
        }
        if (inputType == 32 || Patterns.EMAIL_ADDRESS.matcher(text).matches()) {
            densefeat[7] = (float)((double)densefeat[7] + 1.0);
        }
        if (className.contains("checkbox")) {
            densefeat[8] = (float)((double)densefeat[8] + 1.0);
        }
        if (FeatureExtractor.matchIndicators(new String[]{"complete", "confirm", "done", "submit"}, new String[]{text})) {
            densefeat[10] = (float)((double)densefeat[10] + 1.0);
        }
        if (className.contains("radio") && className.contains("button")) {
            densefeat[12] = (float)((double)densefeat[12] + 1.0);
        }
        try {
            JSONArray childViews = node.optJSONArray("childviews");
            int len = childViews.length();
            for (int i = 0; i < len; ++i) {
                FeatureExtractor.sum(densefeat, FeatureExtractor.parseFeatures(childViews.getJSONObject(i)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return densefeat;
    }

    private static float[] nonparseFeatures(JSONObject node, JSONArray siblings, String screenName, String formFieldsJSON, String appName) {
        float[] densefeat = new float[30];
        Arrays.fill(densefeat, 0.0f);
        int siblingLen = siblings.length();
        densefeat[3] = siblingLen > 1 ? siblingLen - 1 : 0;
        try {
            for (int i = 0; i < siblings.length(); ++i) {
                if (!FeatureExtractor.isButton(siblings.getJSONObject(i))) continue;
                densefeat[9] = densefeat[9] + 1.0f;
            }
        }
        catch (JSONException i) {
            // empty catch block
        }
        densefeat[13] = -1.0f;
        densefeat[14] = -1.0f;
        String pageTitle = screenName + '|' + appName;
        String buttonID = "";
        String buttonText = "";
        StringBuilder hintSB = new StringBuilder();
        StringBuilder textSB = new StringBuilder();
        FeatureExtractor.updateHintAndTextRecursively(node, hintSB, textSB);
        buttonID = hintSB.toString();
        buttonText = textSB.toString();
        densefeat[15] = FeatureExtractor.regexMatched("ENGLISH", "COMPLETE_REGISTRATION", "BUTTON_TEXT", buttonText) ? 1.0f : 0.0f;
        densefeat[16] = FeatureExtractor.regexMatched("ENGLISH", "COMPLETE_REGISTRATION", "PAGE_TITLE", pageTitle) ? 1.0f : 0.0f;
        densefeat[17] = FeatureExtractor.regexMatched("ENGLISH", "COMPLETE_REGISTRATION", "BUTTON_ID", buttonID) ? 1.0f : 0.0f;
        densefeat[18] = formFieldsJSON.contains(REGEX_CR_PASSWORD_FIELD) ? 1.0f : 0.0f;
        densefeat[19] = FeatureExtractor.regexMatched(REGEX_CR_HAS_CONFIRM_PASSWORD_FIELD, formFieldsJSON) ? 1.0f : 0.0f;
        densefeat[20] = FeatureExtractor.regexMatched(REGEX_CR_HAS_LOG_IN_KEYWORDS, formFieldsJSON) ? 1.0f : 0.0f;
        densefeat[21] = FeatureExtractor.regexMatched(REGEX_CR_HAS_SIGN_ON_KEYWORDS, formFieldsJSON) ? 1.0f : 0.0f;
        densefeat[22] = FeatureExtractor.regexMatched("ENGLISH", "PURCHASE", "BUTTON_TEXT", buttonText) ? 1.0f : 0.0f;
        densefeat[24] = FeatureExtractor.regexMatched("ENGLISH", "PURCHASE", "PAGE_TITLE", pageTitle) ? 1.0f : 0.0f;
        densefeat[25] = FeatureExtractor.regexMatched(REGEX_ADD_TO_CART_BUTTON_TEXT, buttonText) ? 1.0f : 0.0f;
        densefeat[27] = FeatureExtractor.regexMatched(REGEX_ADD_TO_CART_PAGE_TITLE, pageTitle) ? 1.0f : 0.0f;
        densefeat[28] = FeatureExtractor.regexMatched("ENGLISH", "LEAD", "BUTTON_TEXT", buttonText) ? 1.0f : 0.0f;
        densefeat[29] = FeatureExtractor.regexMatched("ENGLISH", "LEAD", "PAGE_TITLE", pageTitle) ? 1.0f : 0.0f;
        return densefeat;
    }

    private static boolean regexMatched(String language, String event, String textType, String matchText) {
        String regex = rules.optJSONObject("rulesForLanguage").optJSONObject(languageInfo.get(language)).optJSONObject("rulesForEvent").optJSONObject(eventInfo.get(event)).optJSONObject("positiveRules").optString(textTypeInfo.get(textType));
        return FeatureExtractor.regexMatched(regex, matchText);
    }

    private static boolean regexMatched(String pattern, String matchText) {
        return Pattern.compile(pattern).matcher(matchText).find();
    }

    private static boolean matchIndicators(String[] indicators, String[] values) {
        for (String indicator : indicators) {
            for (String value : values) {
                if (!value.contains(indicator)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pruneTree(JSONObject node, JSONArray siblings) {
        try {
            boolean isInteracted = node.optBoolean("is_interacted");
            if (isInteracted) {
                return true;
            }
            boolean isChildInteracted = false;
            boolean isDescendantInteracted = false;
            JSONArray childViews = node.optJSONArray("childviews");
            for (int i = 0; i < childViews.length(); ++i) {
                JSONObject child = childViews.getJSONObject(i);
                if (!child.optBoolean("is_interacted")) continue;
                isChildInteracted = true;
                isDescendantInteracted = true;
                break;
            }
            JSONArray newChidren = new JSONArray();
            if (isChildInteracted) {
                for (int i = 0; i < childViews.length(); ++i) {
                    JSONObject child = childViews.getJSONObject(i);
                    siblings.put((Object)child);
                }
            } else {
                for (int i = 0; i < childViews.length(); ++i) {
                    JSONObject child = childViews.getJSONObject(i);
                    if (!FeatureExtractor.pruneTree(child, siblings)) continue;
                    isDescendantInteracted = true;
                    newChidren.put((Object)child);
                }
                node.put("childviews", (Object)newChidren);
            }
            return isDescendantInteracted;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private static void sum(float[] a, float[] b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b[i];
        }
    }

    private static boolean isButton(JSONObject node) {
        int classTypeBitmask = node.optInt("classtypebitmask");
        return (classTypeBitmask & 0x20) > 0;
    }

    private static void updateHintAndTextRecursively(JSONObject view, StringBuilder textSB, StringBuilder hintSB) {
        JSONArray children;
        String text = view.optString("text", "").toLowerCase();
        String hint = view.optString("hint", "").toLowerCase();
        if (!text.isEmpty()) {
            textSB.append(text).append(" ");
        }
        if (!hint.isEmpty()) {
            hintSB.append(hint).append(" ");
        }
        if ((children = view.optJSONArray("childviews")) == null) {
            return;
        }
        for (int i = 0; i < children.length(); ++i) {
            FeatureExtractor.updateHintAndTextRecursively(view, textSB, hintSB);
        }
    }

    @Nullable
    private static JSONObject getInteractedNode(JSONObject view) {
        try {
            if (view.optBoolean("is_interacted")) {
                return view;
            }
            JSONArray children = view.optJSONArray("childviews");
            if (children == null) {
                return null;
            }
            for (int i = 0; i < children.length(); ++i) {
                JSONObject sub = FeatureExtractor.getInteractedNode(children.getJSONObject(i));
                if (sub == null) continue;
                return sub;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    static {
        initialized = false;
    }
}

