/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.RestrictiveDataManager;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker;
import com.facebook.internal.FacebookRequestErrorClassification;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FetchedAppSettingsManager {
    private static final String TAG = FetchedAppSettingsManager.class.getSimpleName();
    private static final String APP_SETTINGS_PREFS_STORE = "com.facebook.internal.preferences.APP_SETTINGS";
    private static final String APP_SETTINGS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_SETTINGS.%s";
    private static final String APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    private static final String APP_SETTING_NUX_CONTENT = "gdpv4_nux_content";
    private static final String APP_SETTING_NUX_ENABLED = "gdpv4_nux_enabled";
    private static final String APP_SETTING_DIALOG_CONFIGS = "android_dialog_configs";
    private static final String APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES = "android_sdk_error_categories";
    private static final String APP_SETTING_APP_EVENTS_SESSION_TIMEOUT = "app_events_session_timeout";
    private static final String APP_SETTING_APP_EVENTS_FEATURE_BITMASK = "app_events_feature_bitmask";
    private static final String APP_SETTING_APP_EVENTS_EVENT_BINDINGS = "auto_event_mapping_android";
    private static final String APP_SETTING_RESTRICTIVE_RULE_FIELD = "restrictive_data_filter_rules";
    private static final String APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD = "restrictive_data_filter_params";
    private static final int AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 8;
    private static final int IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 16;
    private static final int CODELESS_EVENTS_ENABLED_BITMASK_FIELD = 32;
    private static final int TRACK_UNINSTALL_ENABLED_BITMASK_FIELD = 256;
    private static final String APP_SETTING_SMART_LOGIN_OPTIONS = "seamless_login";
    private static final String SMART_LOGIN_BOOKMARK_ICON_URL = "smart_login_bookmark_icon_url";
    private static final String SMART_LOGIN_MENU_ICON_URL = "smart_login_menu_icon_url";
    private static final String SDK_UPDATE_MESSAGE = "sdk_update_message";
    private static final String[] APP_SETTING_FIELDS = new String[]{"supports_implicit_sdk_logging", "gdpv4_nux_content", "gdpv4_nux_enabled", "android_dialog_configs", "android_sdk_error_categories", "app_events_session_timeout", "app_events_feature_bitmask", "auto_event_mapping_android", "seamless_login", "smart_login_bookmark_icon_url", "smart_login_menu_icon_url", "restrictive_data_filter_rules", "restrictive_data_filter_params"};
    private static final String APPLICATION_FIELDS = "fields";
    private static final Map<String, FetchedAppSettings> fetchedAppSettings = new ConcurrentHashMap<String, FetchedAppSettings>();
    private static final AtomicReference<FetchAppSettingState> loadingState = new AtomicReference<FetchAppSettingState>(FetchAppSettingState.NOT_LOADED);
    private static final ConcurrentLinkedQueue<FetchedAppSettingsCallback> fetchedAppSettingsCallbacks = new ConcurrentLinkedQueue();
    private static boolean printedSDKUpdatedMessage = false;
    private static boolean isUnityInit = false;
    @Nullable
    private static JSONArray unityEventBindings = null;

    public static void loadAppSettingsAsync() {
        boolean canStartLoading;
        final Context context = FacebookSdk.getApplicationContext();
        final String applicationId = FacebookSdk.getApplicationId();
        if (Utility.isNullOrEmpty(applicationId)) {
            loadingState.set(FetchAppSettingState.ERROR);
            FetchedAppSettingsManager.pollCallbacks();
            return;
        }
        if (fetchedAppSettings.containsKey(applicationId)) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            FetchedAppSettingsManager.pollCallbacks();
            return;
        }
        boolean bl = canStartLoading = loadingState.compareAndSet(FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING) || loadingState.compareAndSet(FetchAppSettingState.ERROR, FetchAppSettingState.LOADING);
        if (!canStartLoading) {
            FetchedAppSettingsManager.pollCallbacks();
            return;
        }
        final String settingsKey = String.format(APP_SETTINGS_PREFS_KEY_FORMAT, applicationId);
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject resultJSON;
                SharedPreferences sharedPrefs = context.getSharedPreferences(FetchedAppSettingsManager.APP_SETTINGS_PREFS_STORE, 0);
                String settingsJSONString = sharedPrefs.getString(settingsKey, null);
                FetchedAppSettings appSettings = null;
                if (!Utility.isNullOrEmpty(settingsJSONString)) {
                    JSONObject settingsJSON = null;
                    try {
                        settingsJSON = new JSONObject(settingsJSONString);
                    }
                    catch (JSONException je) {
                        Utility.logd("FacebookSDK", (Exception)((Object)je));
                    }
                    if (settingsJSON != null) {
                        appSettings = FetchedAppSettingsManager.parseAppSettingsFromJSON(applicationId, settingsJSON);
                    }
                }
                if ((resultJSON = FetchedAppSettingsManager.getAppSettingsQueryResponse(applicationId)) != null) {
                    FetchedAppSettingsManager.parseAppSettingsFromJSON(applicationId, resultJSON);
                    sharedPrefs.edit().putString(settingsKey, resultJSON.toString()).apply();
                }
                if (appSettings != null) {
                    String updateMessage = appSettings.getSdkUpdateMessage();
                    if (!printedSDKUpdatedMessage && updateMessage != null && updateMessage.length() > 0) {
                        printedSDKUpdatedMessage = true;
                        Log.w((String)TAG, (String)updateMessage);
                    }
                }
                FetchedAppGateKeepersManager.queryAppGateKeepers(applicationId, true);
                AutomaticAnalyticsLogger.logActivateAppEvent();
                InAppPurchaseActivityLifecycleTracker.update();
                loadingState.set(fetchedAppSettings.containsKey(applicationId) ? FetchAppSettingState.SUCCESS : FetchAppSettingState.ERROR);
                FetchedAppSettingsManager.pollCallbacks();
            }
        });
    }

    @Nullable
    public static FetchedAppSettings getAppSettingsWithoutQuery(String applicationId) {
        return applicationId != null ? fetchedAppSettings.get(applicationId) : null;
    }

    public static void getAppSettingsAsync(FetchedAppSettingsCallback callback) {
        fetchedAppSettingsCallbacks.add(callback);
        FetchedAppSettingsManager.loadAppSettingsAsync();
    }

    private static synchronized void pollCallbacks() {
        FetchAppSettingState currentState = loadingState.get();
        if (FetchAppSettingState.NOT_LOADED.equals((Object)currentState) || FetchAppSettingState.LOADING.equals((Object)currentState)) {
            return;
        }
        String applicationId = FacebookSdk.getApplicationId();
        final FetchedAppSettings appSettings = fetchedAppSettings.get(applicationId);
        Handler handler = new Handler(Looper.getMainLooper());
        if (FetchAppSettingState.ERROR.equals((Object)currentState)) {
            while (!fetchedAppSettingsCallbacks.isEmpty()) {
                final FetchedAppSettingsCallback callback = fetchedAppSettingsCallbacks.poll();
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError();
                    }
                });
            }
            return;
        }
        while (!fetchedAppSettingsCallbacks.isEmpty()) {
            final FetchedAppSettingsCallback callback = fetchedAppSettingsCallbacks.poll();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(appSettings);
                }
            });
        }
    }

    @Nullable
    public static FetchedAppSettings queryAppSettings(String applicationId, boolean forceRequery) {
        if (!forceRequery && fetchedAppSettings.containsKey(applicationId)) {
            return fetchedAppSettings.get(applicationId);
        }
        JSONObject response = FetchedAppSettingsManager.getAppSettingsQueryResponse(applicationId);
        if (response == null) {
            return null;
        }
        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.parseAppSettingsFromJSON(applicationId, response);
        if (applicationId.equals(FacebookSdk.getApplicationId())) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            FetchedAppSettingsManager.pollCallbacks();
        }
        return fetchedAppSettings;
    }

    private static FetchedAppSettings parseAppSettingsFromJSON(String applicationId, final JSONObject settingsJSON) {
        JSONArray errorClassificationJSON = settingsJSON.optJSONArray(APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES);
        FacebookRequestErrorClassification errorClassification = errorClassificationJSON == null ? FacebookRequestErrorClassification.getDefaultErrorClassification() : FacebookRequestErrorClassification.createFromJSON(errorClassificationJSON);
        int featureBitmask = settingsJSON.optInt(APP_SETTING_APP_EVENTS_FEATURE_BITMASK, 0);
        boolean automaticLoggingEnabled = (featureBitmask & 8) != 0;
        boolean inAppPurchaseAutomaticLoggingEnabled = (featureBitmask & 0x10) != 0;
        boolean codelessEventsEnabled = (featureBitmask & 0x20) != 0;
        boolean trackUninstallEnabled = (featureBitmask & 0x100) != 0;
        JSONArray eventBindings = settingsJSON.optJSONArray(APP_SETTING_APP_EVENTS_EVENT_BINDINGS);
        unityEventBindings = eventBindings;
        if (unityEventBindings != null && InternalSettings.isUnityApp()) {
            UnityReflection.sendEventMapping(eventBindings.toString());
        }
        FetchedAppSettings result = new FetchedAppSettings(settingsJSON.optBoolean(APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, false), settingsJSON.optString(APP_SETTING_NUX_CONTENT, ""), settingsJSON.optBoolean(APP_SETTING_NUX_ENABLED, false), settingsJSON.optInt(APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, Constants.getDefaultAppEventsSessionTimeoutInSeconds()), SmartLoginOption.parseOptions(settingsJSON.optLong(APP_SETTING_SMART_LOGIN_OPTIONS)), FetchedAppSettingsManager.parseDialogConfigurations(settingsJSON.optJSONObject(APP_SETTING_DIALOG_CONFIGS)), automaticLoggingEnabled, errorClassification, settingsJSON.optString(SMART_LOGIN_BOOKMARK_ICON_URL), settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL), inAppPurchaseAutomaticLoggingEnabled, codelessEventsEnabled, eventBindings, settingsJSON.optString(SDK_UPDATE_MESSAGE), trackUninstallEnabled);
        fetchedAppSettings.put(applicationId, result);
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                RestrictiveDataManager.updateFromSetting(settingsJSON.optString(FetchedAppSettingsManager.APP_SETTING_RESTRICTIVE_RULE_FIELD), settingsJSON.optString(FetchedAppSettingsManager.APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD));
            }
        });
        return result;
    }

    public static void setIsUnityInit(boolean flag) {
        isUnityInit = flag;
        if (unityEventBindings != null && isUnityInit) {
            UnityReflection.sendEventMapping(unityEventBindings.toString());
        }
    }

    private static JSONObject getAppSettingsQueryResponse(String applicationId) {
        Bundle appSettingsParams = new Bundle();
        ArrayList<String> appSettingFields = new ArrayList<String>(Arrays.asList(APP_SETTING_FIELDS));
        appSettingsParams.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", appSettingFields));
        GraphRequest request = GraphRequest.newGraphPathRequest(null, applicationId, null);
        request.setSkipClientToken(true);
        request.setParameters(appSettingsParams);
        return request.executeAndWait().getJSONObject();
    }

    private static Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> parseDialogConfigurations(JSONObject dialogConfigResponse) {
        JSONArray dialogConfigData;
        HashMap<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> dialogConfigMap = new HashMap<String, Map<String, FetchedAppSettings.DialogFeatureConfig>>();
        if (dialogConfigResponse != null && (dialogConfigData = dialogConfigResponse.optJSONArray("data")) != null) {
            for (int i = 0; i < dialogConfigData.length(); ++i) {
                FetchedAppSettings.DialogFeatureConfig dialogConfig = FetchedAppSettings.DialogFeatureConfig.parseDialogConfig(dialogConfigData.optJSONObject(i));
                if (dialogConfig == null) continue;
                String dialogName = dialogConfig.getDialogName();
                Map<String, FetchedAppSettings.DialogFeatureConfig> featureMap = dialogConfigMap.get(dialogName);
                if (featureMap == null) {
                    featureMap = new HashMap<String, FetchedAppSettings.DialogFeatureConfig>();
                    dialogConfigMap.put(dialogName, featureMap);
                }
                featureMap.put(dialogConfig.getFeatureName(), dialogConfig);
            }
        }
        return dialogConfigMap;
    }

    public static interface FetchedAppSettingsCallback {
        public void onSuccess(FetchedAppSettings var1);

        public void onError();
    }

    static enum FetchAppSettingState {
        NOT_LOADED,
        LOADING,
        SUCCESS,
        ERROR;

    }
}

