/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RestrictiveDataManager {
    private static final String TAG = RestrictiveDataManager.class.getCanonicalName();
    private static List<RestrictiveRule> restrictiveRules = new ArrayList<RestrictiveRule>();
    private static List<RestrictiveParam> restrictiveParams = new ArrayList<RestrictiveParam>();
    private static Set<String> restrictiveEvents = new HashSet<String>();

    public static void updateFromSetting(String ruleResponse, String eventFilterResponse) {
        try {
            if (ruleResponse != null) {
                JSONArray jsonArray = new JSONArray(ruleResponse);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    String keyRegex = object.optString("key_regex");
                    String valRagex = object.optString("value_regex");
                    String valNegRagex = object.optString("value_negative_regex");
                    String type = object.optString("type");
                    if (Utility.isNullOrEmpty(keyRegex) && Utility.isNullOrEmpty(valRagex) && Utility.isNullOrEmpty(valNegRagex)) continue;
                    restrictiveRules.add(new RestrictiveRule(keyRegex, valRagex, valNegRagex, type));
                }
            }
            if (eventFilterResponse != null) {
                restrictiveParams.clear();
                restrictiveEvents.clear();
                JSONObject jsonObject = new JSONObject(eventFilterResponse);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject json = jsonObject.getJSONObject(key);
                    if (json == null) continue;
                    if (json.optBoolean("is_deprecated_event")) {
                        restrictiveEvents.add(key);
                        continue;
                    }
                    JSONObject paramJson = jsonObject.getJSONObject(key).optJSONObject("restrictive_param");
                    if (paramJson == null) continue;
                    restrictiveParams.add(new RestrictiveParam(key, Utility.convertJSONObjectToStringMap(paramJson)));
                }
            }
        }
        catch (JSONException je) {
            Log.e((String)TAG, (String)"updateRulesFromSetting failed", (Throwable)je);
        }
    }

    static boolean isDeprecatedEvent(String eventName) {
        return restrictiveEvents.contains(eventName);
    }

    @Nullable
    static String getMatchedRuleType(String eventName, String paramKey, String paramVal) {
        for (RestrictiveParam filter : restrictiveParams) {
            if (!eventName.equals(filter.eventName)) continue;
            for (String param : filter.params.keySet()) {
                if (!paramKey.equals(param)) continue;
                return filter.params.get(param);
            }
        }
        for (RestrictiveRule rule : restrictiveRules) {
            if (!Utility.isNullOrEmpty(rule.keyRegex) && !paramKey.matches(rule.keyRegex) || !Utility.isNullOrEmpty(rule.valNegRegex) && paramVal.matches(rule.valNegRegex) || !Utility.isNullOrEmpty(rule.valRegex) && !paramVal.matches(rule.valRegex)) continue;
            return rule.type;
        }
        return null;
    }

    static class RestrictiveParam {
        String eventName;
        Map<String, String> params;

        RestrictiveParam(String eventName, Map<String, String> params) {
            this.eventName = eventName;
            this.params = params;
        }
    }

    static class RestrictiveRule {
        String keyRegex;
        String valRegex;
        String valNegRegex;
        String type;

        RestrictiveRule(String keyRegex, String valRegex, String valNegRegex, String type) {
            this.keyRegex = keyRegex;
            this.valRegex = valRegex;
            this.valNegRegex = valNegRegex;
            this.type = type;
        }
    }
}

