/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.FacebookSdkNotInitializedException;
import com.facebook.GraphRequest;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

final class UserSettingsManager {
    private static final String TAG = UserSettingsManager.class.getName();
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static final String EVENTS_CODELESS_SETUP_ENABLED = "auto_event_setup_enabled";
    private static final long TIMEOUT_7D = 604800000L;
    private static final String ADVERTISER_ID_KEY = "advertiser_id";
    private static final String APPLICATION_FIELDS = "fields";
    private static UserSetting autoInitEnabled = new UserSetting(true, "com.facebook.sdk.AutoInitEnabled");
    private static UserSetting autoLogAppEventsEnabled = new UserSetting(true, "com.facebook.sdk.AutoLogAppEventsEnabled");
    private static UserSetting advertiserIDCollectionEnabled = new UserSetting(true, "com.facebook.sdk.AdvertiserIDCollectionEnabled");
    private static UserSetting codelessSetupEnabled = new UserSetting(false, "auto_event_setup_enabled");
    private static final String USER_SETTINGS = "com.facebook.sdk.USER_SETTINGS";
    private static final String USER_SETTINGS_BITMASK = "com.facebook.sdk.USER_SETTINGS_BITMASK";
    private static SharedPreferences userSettingPref;
    private static SharedPreferences.Editor userSettingPrefEditor;
    private static final String LAST_TIMESTAMP = "last_timestamp";
    private static final String VALUE = "value";
    private static final String AUTOLOG_APPEVENT_NOT_SET_WARNING = "Please set a value for AutoLogAppEventsEnabled. Set the flag to TRUE if you want to collect app install, app launch and in-app purchase events automatically. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    private static final String ADVERTISERID_COLLECTION_NOT_SET_WARNING = "You haven't set a value for AdvertiserIDCollectionEnabled. Set the flag to TRUE if you want to collect Advertiser ID for better advertising and analytics results. To request user consent before collecting data, set the flag value to FALSE, then change to TRUE once user consent is received. Learn more: https://developers.facebook.com/docs/app-events/getting-started-app-events-android#disable-auto-events.";
    private static final String ADVERTISERID_COLLECTION_FALSE_WARNING = "The value for AdvertiserIDCollectionEnabled is currently set to FALSE so you're sending app events without collecting Advertiser ID. This can affect the quality of your advertising and analytics results.";

    UserSettingsManager() {
    }

    public static void initializeIfNotInitialized() {
        if (!FacebookSdk.isInitialized()) {
            return;
        }
        if (!isInitialized.compareAndSet(false, true)) {
            return;
        }
        userSettingPref = FacebookSdk.getApplicationContext().getSharedPreferences(USER_SETTINGS, 0);
        userSettingPrefEditor = userSettingPref.edit();
        UserSettingsManager.initializeUserSetting(autoLogAppEventsEnabled, advertiserIDCollectionEnabled, autoInitEnabled);
        UserSettingsManager.initializeCodelessSetupEnabledAsync();
        UserSettingsManager.logWarnings();
        UserSettingsManager.logIfSDKSettingsChanged();
    }

    private static void initializeUserSetting(UserSetting ... userSettings) {
        for (int i = 0; i < userSettings.length; ++i) {
            UserSetting userSetting = userSettings[i];
            if (userSetting == codelessSetupEnabled) {
                UserSettingsManager.initializeCodelessSetupEnabledAsync();
                continue;
            }
            if (userSetting.value == null) {
                UserSettingsManager.readSettingFromCache(userSetting);
                if (userSetting.value != null) continue;
                UserSettingsManager.loadSettingFromManifest(userSetting);
                continue;
            }
            UserSettingsManager.writeSettingToCache(userSetting);
        }
    }

    private static void initializeCodelessSetupEnabledAsync() {
        UserSettingsManager.readSettingFromCache(codelessSetupEnabled);
        final long currTime = System.currentTimeMillis();
        if (UserSettingsManager.codelessSetupEnabled.value != null && currTime - UserSettingsManager.codelessSetupEnabled.lastTS < 604800000L) {
            return;
        }
        UserSettingsManager.codelessSetupEnabled.value = null;
        UserSettingsManager.codelessSetupEnabled.lastTS = 0L;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FetchedAppSettings appSettings;
                if (advertiserIDCollectionEnabled.getValue() && (appSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false)) != null && appSettings.getCodelessEventsEnabled()) {
                    String advertiser_id = null;
                    Context context = FacebookSdk.getApplicationContext();
                    AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                    if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                        advertiser_id = identifiers.getAndroidAdvertiserId();
                    }
                    if (advertiser_id != null) {
                        Bundle codelessSettingsParams = new Bundle();
                        codelessSettingsParams.putString(UserSettingsManager.ADVERTISER_ID_KEY, identifiers.getAndroidAdvertiserId());
                        codelessSettingsParams.putString(UserSettingsManager.APPLICATION_FIELDS, UserSettingsManager.EVENTS_CODELESS_SETUP_ENABLED);
                        GraphRequest codelessRequest = GraphRequest.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
                        codelessRequest.setSkipClientToken(true);
                        codelessRequest.setParameters(codelessSettingsParams);
                        JSONObject response = codelessRequest.executeAndWait().getJSONObject();
                        if (response != null) {
                            codelessSetupEnabled.value = response.optBoolean(UserSettingsManager.EVENTS_CODELESS_SETUP_ENABLED, false);
                            codelessSetupEnabled.lastTS = currTime;
                            UserSettingsManager.writeSettingToCache(codelessSetupEnabled);
                        }
                    }
                }
            }
        });
    }

    private static void writeSettingToCache(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(VALUE, (Object)userSetting.value);
            jsonObject.put(LAST_TIMESTAMP, userSetting.lastTS);
            userSettingPrefEditor.putString(userSetting.key, jsonObject.toString()).commit();
            UserSettingsManager.logIfSDKSettingsChanged();
        }
        catch (JSONException je) {
            Utility.logd(TAG, (Exception)((Object)je));
        }
    }

    private static void readSettingFromCache(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            String settingStr = userSettingPref.getString(userSetting.key, "");
            if (!settingStr.isEmpty()) {
                JSONObject setting = new JSONObject(settingStr);
                userSetting.value = setting.getBoolean(VALUE);
                userSetting.lastTS = setting.getLong(LAST_TIMESTAMP);
            }
        }
        catch (JSONException je) {
            Utility.logd(TAG, (Exception)((Object)je));
        }
    }

    private static void loadSettingFromManifest(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            Context ctx = FacebookSdk.getApplicationContext();
            ApplicationInfo ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            if (ai != null && ai.metaData != null && ai.metaData.containsKey(userSetting.key)) {
                userSetting.value = ai.metaData.getBoolean(userSetting.key, userSetting.defaultVal);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Utility.logd(TAG, (Exception)((Object)e));
        }
    }

    private static void logWarnings() {
        try {
            Context ctx = FacebookSdk.getApplicationContext();
            ApplicationInfo ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            if (ai != null && ai.metaData != null) {
                if (!ai.metaData.containsKey("com.facebook.sdk.AutoLogAppEventsEnabled")) {
                    Log.w((String)TAG, (String)AUTOLOG_APPEVENT_NOT_SET_WARNING);
                }
                if (!ai.metaData.containsKey("com.facebook.sdk.AdvertiserIDCollectionEnabled")) {
                    Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_NOT_SET_WARNING);
                }
                if (!UserSettingsManager.getAdvertiserIDCollectionEnabled()) {
                    Log.w((String)TAG, (String)ADVERTISERID_COLLECTION_FALSE_WARNING);
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private static void logIfSDKSettingsChanged() {
        if (!isInitialized.get()) {
            return;
        }
        if (!FacebookSdk.isInitialized()) {
            return;
        }
        Context ctx = FacebookSdk.getApplicationContext();
        int bitmask = 0;
        int bit = 0;
        bitmask |= (autoInitEnabled.getValue() ? 1 : 0) << bit++;
        bitmask |= (autoLogAppEventsEnabled.getValue() ? 1 : 0) << bit++;
        int previousBitmask = userSettingPref.getInt(USER_SETTINGS_BITMASK, 0);
        if (previousBitmask != (bitmask |= (advertiserIDCollectionEnabled.getValue() ? 1 : 0) << bit++)) {
            userSettingPrefEditor.putInt(USER_SETTINGS_BITMASK, bitmask).commit();
            int initialBitmask = 0;
            int usageBitmask = 0;
            try {
                ApplicationInfo ai = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                if (ai != null && ai.metaData != null) {
                    String[] keys = new String[]{"com.facebook.sdk.AutoInitEnabled", "com.facebook.sdk.AutoLogAppEventsEnabled", "com.facebook.sdk.AdvertiserIDCollectionEnabled"};
                    boolean[] defaultValues = new boolean[]{true, true, true};
                    for (int i = 0; i < keys.length; ++i) {
                        usageBitmask |= (ai.metaData.containsKey(keys[i]) ? 1 : 0) << i;
                        boolean initialValue = ai.metaData.getBoolean(keys[i], defaultValues[i]);
                        initialBitmask |= (initialValue ? 1 : 0) << i;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException ai) {
                // empty catch block
            }
            InternalAppEventsLogger logger = new InternalAppEventsLogger(ctx);
            Bundle parameters = new Bundle();
            parameters.putInt("usage", usageBitmask);
            parameters.putInt("initial", initialBitmask);
            parameters.putInt("previous", previousBitmask);
            parameters.putInt("current", bitmask);
            logger.logEventImplicitly("fb_sdk_settings_changed", parameters);
        }
    }

    private static void validateInitialized() {
        if (!isInitialized.get()) {
            throw new FacebookSdkNotInitializedException("The UserSettingManager has not been initialized successfully");
        }
    }

    public static void setAutoInitEnabled(boolean flag) {
        UserSettingsManager.autoInitEnabled.value = flag;
        UserSettingsManager.autoInitEnabled.lastTS = System.currentTimeMillis();
        if (isInitialized.get()) {
            UserSettingsManager.writeSettingToCache(autoInitEnabled);
        } else {
            UserSettingsManager.initializeIfNotInitialized();
        }
    }

    public static boolean getAutoInitEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return autoInitEnabled.getValue();
    }

    public static void setAutoLogAppEventsEnabled(boolean flag) {
        UserSettingsManager.autoLogAppEventsEnabled.value = flag;
        UserSettingsManager.autoLogAppEventsEnabled.lastTS = System.currentTimeMillis();
        if (isInitialized.get()) {
            UserSettingsManager.writeSettingToCache(autoLogAppEventsEnabled);
        } else {
            UserSettingsManager.initializeIfNotInitialized();
        }
    }

    public static boolean getAutoLogAppEventsEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return autoLogAppEventsEnabled.getValue();
    }

    public static void setAdvertiserIDCollectionEnabled(boolean flag) {
        UserSettingsManager.advertiserIDCollectionEnabled.value = flag;
        UserSettingsManager.advertiserIDCollectionEnabled.lastTS = System.currentTimeMillis();
        if (isInitialized.get()) {
            UserSettingsManager.writeSettingToCache(advertiserIDCollectionEnabled);
        } else {
            UserSettingsManager.initializeIfNotInitialized();
        }
    }

    public static boolean getAdvertiserIDCollectionEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return advertiserIDCollectionEnabled.getValue();
    }

    public static boolean getCodelessSetupEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return codelessSetupEnabled.getValue();
    }

    private static class UserSetting {
        String key;
        Boolean value;
        boolean defaultVal;
        long lastTS;

        UserSetting(boolean defaultVal, String key) {
            this.defaultVal = defaultVal;
            this.key = key;
        }

        boolean getValue() {
            return this.value == null ? this.defaultVal : this.value;
        }
    }
}

