/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.InAppPurchaseEventManager;
import com.facebook.appevents.internal.SubscriptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppPurchaseActivityLifecycleTracker {
    private static final String TAG = InAppPurchaseActivityLifecycleTracker.class.getCanonicalName();
    private static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    private static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    private static final AtomicBoolean isTracking = new AtomicBoolean(false);
    private static Boolean hasBillingService = null;
    private static Boolean hasBiillingActivity = null;
    private static ServiceConnection serviceConnection;
    private static Application.ActivityLifecycleCallbacks callbacks;
    private static Intent intent;
    private static Object inAppBillingObj;

    public static void update() {
        InAppPurchaseActivityLifecycleTracker.initializeIfNotInitialized();
        if (!hasBillingService.booleanValue()) {
            return;
        }
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            InAppPurchaseActivityLifecycleTracker.startTracking();
        }
    }

    private static void initializeIfNotInitialized() {
        if (hasBillingService != null) {
            return;
        }
        try {
            Class.forName(SERVICE_INTERFACE_NAME);
            hasBillingService = true;
        }
        catch (ClassNotFoundException ignored) {
            hasBillingService = false;
            return;
        }
        try {
            Class.forName(BILLING_ACTIVITY_NAME);
            hasBiillingActivity = true;
        }
        catch (ClassNotFoundException ignored) {
            hasBiillingActivity = false;
        }
        InAppPurchaseEventManager.clearSkuDetailsCache();
        intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                inAppBillingObj = InAppPurchaseEventManager.asInterface(FacebookSdk.getApplicationContext(), service);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        callbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityResumed(Activity activity) {
                FacebookSdk.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Context context = FacebookSdk.getApplicationContext();
                        ArrayList<String> purchasesInapp = InAppPurchaseEventManager.getPurchasesInapp(context, inAppBillingObj);
                        InAppPurchaseActivityLifecycleTracker.logPurchaseInapp(context, purchasesInapp);
                        Map<String, SubscriptionType> purchasesSubs = InAppPurchaseEventManager.getPurchasesSubs(context, inAppBillingObj);
                        InAppPurchaseActivityLifecycleTracker.logPurchaseSubs(context, purchasesSubs, new HashMap());
                        HashSet<Integer> errorCodes = new HashSet<Integer>();
                        purchasesSubs.clear();
                        ArrayList<String> purchasesSubsExpire = InAppPurchaseEventManager.getPurchasesSubsExpire(context, inAppBillingObj, errorCodes);
                        for (String purchase : purchasesSubsExpire) {
                            purchasesSubs.put(purchase, SubscriptionType.EXPIRE);
                        }
                        HashMap<String, String> extraParameters = new HashMap<String, String>();
                        if (!errorCodes.isEmpty()) {
                            extraParameters.put("error_code", TextUtils.join((CharSequence)",", errorCodes));
                        }
                        InAppPurchaseActivityLifecycleTracker.logPurchaseSubs(context, purchasesSubs, extraParameters);
                    }
                });
            }

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                if (hasBiillingActivity.booleanValue() && activity.getLocalClassName().equals(InAppPurchaseActivityLifecycleTracker.BILLING_ACTIVITY_NAME)) {
                    FacebookSdk.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            Context context = FacebookSdk.getApplicationContext();
                            ArrayList<String> purchases = InAppPurchaseEventManager.getPurchasesInapp(context, inAppBillingObj);
                            if (purchases.isEmpty()) {
                                purchases = InAppPurchaseEventManager.getPurchaseHistoryInapp(context, inAppBillingObj);
                            }
                            InAppPurchaseActivityLifecycleTracker.logPurchaseInapp(context, purchases);
                        }
                    });
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
    }

    private static void startTracking() {
        if (!isTracking.compareAndSet(false, true)) {
            return;
        }
        Context context = FacebookSdk.getApplicationContext();
        if (context instanceof Application) {
            Application application = (Application)context;
            application.registerActivityLifecycleCallbacks(callbacks);
            context.bindService(intent, serviceConnection, 1);
        }
    }

    private static void logPurchaseInapp(Context context, ArrayList<String> purchases) {
        if (purchases.isEmpty()) {
            return;
        }
        HashMap<String, String> purchaseMap = new HashMap<String, String>();
        ArrayList<String> skuList = new ArrayList<String>();
        for (String purchase : purchases) {
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                purchaseMap.put(sku, purchase);
                skuList.add(sku);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.getSkuDetails(context, skuList, inAppBillingObj, false);
        for (Map.Entry<String, String> pair : skuDetailsMap.entrySet()) {
            AutomaticAnalyticsLogger.logPurchaseInapp((String)purchaseMap.get(pair.getKey()), pair.getValue());
        }
    }

    private static void logPurchaseSubs(Context context, Map<String, SubscriptionType> purchasesSubsTypeMap, Map<String, String> extraParameter) {
        if (purchasesSubsTypeMap.isEmpty()) {
            return;
        }
        HashMap<String, String> skuPurchaseMap = new HashMap<String, String>();
        ArrayList<String> skuList = new ArrayList<String>();
        for (String purchase : purchasesSubsTypeMap.keySet()) {
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                skuList.add(sku);
                skuPurchaseMap.put(sku, purchase);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.getSkuDetails(context, skuList, inAppBillingObj, true);
        for (String sku : skuDetailsMap.keySet()) {
            String purchase = (String)skuPurchaseMap.get(sku);
            String skuDetail = skuDetailsMap.get(sku);
            SubscriptionType subsType = purchasesSubsTypeMap.get(purchase);
            AutomaticAnalyticsLogger.logPurchaseSubs(subsType, purchase, skuDetail, extraParameter);
        }
    }
}

