/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.CodelessLoggingEventListener;
import com.facebook.appevents.codeless.RCTCodelessLoggingEventListener;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ParameterComponent;
import com.facebook.appevents.codeless.internal.PathComponent;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Utility;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CodelessMatcher {
    private static final String PARENT_CLASS_NAME = "..";
    private static final String CURRENT_CLASS_NAME = ".";
    private static final String TAG = CodelessMatcher.class.getCanonicalName();
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private Set<Activity> activitiesSet = new HashSet<Activity>();
    private Set<ViewMatcher> viewMatchers = new HashSet<ViewMatcher>();
    private HashMap<String, String> delegateMap = new HashMap();

    public void add(Activity activity) {
        if (InternalSettings.isUnityApp()) {
            return;
        }
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't add activity to CodelessMatcher on non-UI thread");
        }
        this.activitiesSet.add(activity);
        this.delegateMap.clear();
        this.startTracking();
    }

    public void remove(Activity activity) {
        if (InternalSettings.isUnityApp()) {
            return;
        }
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't remove activity from CodelessMatcher on non-UI thread");
        }
        this.activitiesSet.remove(activity);
        this.viewMatchers.clear();
        this.delegateMap.clear();
    }

    public static Bundle getParameters(EventBinding mapping, View rootView, View hostView) {
        Bundle params = new Bundle();
        if (null == mapping) {
            return params;
        }
        List<ParameterComponent> parameters = mapping.getViewParameters();
        if (null != parameters) {
            block0: for (ParameterComponent component : parameters) {
                if (component.value != null && component.value.length() > 0) {
                    params.putString(component.name, component.value);
                    continue;
                }
                if (component.path.size() <= 0) continue;
                String pathType = component.pathType;
                List<MatchedView> matchedViews = pathType.equals("relative") ? ViewMatcher.findViewByPath(mapping, hostView, component.path, 0, -1, hostView.getClass().getSimpleName()) : ViewMatcher.findViewByPath(mapping, rootView, component.path, 0, -1, rootView.getClass().getSimpleName());
                for (MatchedView view : matchedViews) {
                    String text;
                    if (view.getView() == null || (text = ViewHierarchy.getTextOfView(view.getView())).length() <= 0) continue;
                    params.putString(component.name, text);
                    continue block0;
                }
            }
        }
        return params;
    }

    private void startTracking() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.matchViews();
        } else {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    CodelessMatcher.this.matchViews();
                }
            });
        }
    }

    private void matchViews() {
        for (Activity activity : this.activitiesSet) {
            View rootView = activity.getWindow().getDecorView().getRootView();
            String activityName = activity.getClass().getSimpleName();
            ViewMatcher matcher = new ViewMatcher(rootView, this.uiThreadHandler, this.delegateMap, activityName);
            this.viewMatchers.add(matcher);
        }
    }

    protected static class ViewMatcher
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener,
    Runnable {
        private WeakReference<View> rootView;
        @Nullable
        private List<EventBinding> eventBindings;
        private final Handler handler;
        private HashMap<String, String> delegateMap;
        private final String activityName;

        public ViewMatcher(View rootView, Handler handler, HashMap<String, String> delegateMap, String activityName) {
            this.rootView = new WeakReference<View>(rootView);
            this.handler = handler;
            this.delegateMap = delegateMap;
            this.activityName = activityName;
            this.handler.postDelayed((Runnable)this, 200L);
        }

        @Override
        public void run() {
            String appId = FacebookSdk.getApplicationId();
            FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
            if (appSettings == null || !appSettings.getCodelessEventsEnabled()) {
                return;
            }
            this.eventBindings = EventBinding.parseArray(appSettings.getEventBindings());
            if (this.eventBindings != null) {
                View rootView = (View)this.rootView.get();
                if (rootView == null) {
                    return;
                }
                ViewTreeObserver observer = rootView.getViewTreeObserver();
                if (observer.isAlive()) {
                    observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    observer.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                }
                this.startMatch();
            }
        }

        public void onGlobalLayout() {
            this.startMatch();
        }

        public void onScrollChanged() {
            this.startMatch();
        }

        private void startMatch() {
            if (this.eventBindings != null && this.rootView.get() != null) {
                for (int i = 0; i < this.eventBindings.size(); ++i) {
                    EventBinding binding = this.eventBindings.get(i);
                    this.findView(binding, (View)this.rootView.get());
                }
            }
        }

        public void findView(EventBinding mapping, View rootView) {
            if (mapping == null || rootView == null) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)mapping.getActivityName()) && !mapping.getActivityName().equals(this.activityName)) {
                return;
            }
            List<PathComponent> path = mapping.getViewPath();
            if (path.size() > 25) {
                return;
            }
            List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, rootView, path, 0, -1, this.activityName);
            for (MatchedView view : matchedViews) {
                this.attachListener(view, rootView, mapping);
            }
        }

        public static List<MatchedView> findViewByPath(EventBinding mapping, View view, List<PathComponent> path, int level, int index, String mapKey) {
            mapKey = mapKey + CodelessMatcher.CURRENT_CLASS_NAME + String.valueOf(index);
            ArrayList<MatchedView> result = new ArrayList<MatchedView>();
            if (null == view) {
                return result;
            }
            if (level >= path.size()) {
                result.add(new MatchedView(view, mapKey));
            } else {
                PathComponent pathElement = path.get(level);
                if (pathElement.className.equals(CodelessMatcher.PARENT_CLASS_NAME)) {
                    ViewParent parent = view.getParent();
                    if (parent instanceof ViewGroup) {
                        ViewGroup viewGroup = (ViewGroup)parent;
                        List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                        int childCount = visibleViews.size();
                        for (int i = 0; i < childCount; ++i) {
                            View child = visibleViews.get(i);
                            List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, path, level + 1, i, mapKey);
                            result.addAll(matchedViews);
                        }
                    }
                    return result;
                }
                if (pathElement.className.equals(CodelessMatcher.CURRENT_CLASS_NAME)) {
                    result.add(new MatchedView(view, mapKey));
                    return result;
                }
                if (!ViewMatcher.isTheSameView(view, pathElement, index)) {
                    return result;
                }
                if (level == path.size() - 1) {
                    result.add(new MatchedView(view, mapKey));
                }
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                int childCount = visibleViews.size();
                for (int i = 0; i < childCount; ++i) {
                    View child = visibleViews.get(i);
                    List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, path, level + 1, i, mapKey);
                    result.addAll(matchedViews);
                }
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTheSameView(View targetView, PathComponent pathElement, int index) {
            if (pathElement.index != -1 && index != pathElement.index) {
                return false;
            }
            if (!targetView.getClass().getCanonicalName().equals(pathElement.className)) {
                if (!pathElement.className.matches(".*android\\..*")) return false;
                String[] names = pathElement.className.split("\\.");
                if (names.length <= 0) return false;
                String SimpleName = names[names.length - 1];
                if (!targetView.getClass().getSimpleName().equals(SimpleName)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.ID.getValue()) > 0 && pathElement.id != targetView.getId()) {
                return false;
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TEXT.getValue()) > 0) {
                String pathText = pathElement.text;
                String text = ViewHierarchy.getTextOfView(targetView);
                String hashedText = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), "");
                if (!pathText.equals(text) && !pathText.equals(hashedText)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.DESCRIPTION.getValue()) > 0) {
                String pathDesc = pathElement.description;
                String targetDesc = targetView.getContentDescription() == null ? "" : String.valueOf(targetView.getContentDescription());
                String hashedDesc = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetDesc), "");
                if (!pathDesc.equals(targetDesc) && !pathDesc.equals(hashedDesc)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.HINT.getValue()) > 0) {
                String pathHint = pathElement.hint;
                String targetHint = ViewHierarchy.getHintOfView(targetView);
                String hashedHint = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetHint), "");
                if (!pathHint.equals(targetHint) && !pathHint.equals(hashedHint)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TAG.getValue()) <= 0) return true;
            String tag = pathElement.tag;
            String targetTag = targetView.getTag() == null ? "" : String.valueOf(targetView.getTag());
            String hashedTag = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetTag), "");
            if (tag.equals(targetTag) || tag.equals(hashedTag)) return true;
            return false;
        }

        private static List<View> findVisibleChildren(ViewGroup viewGroup) {
            ArrayList<View> visibleViews = new ArrayList<View>();
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                visibleViews.add(child);
            }
            return visibleViews;
        }

        private void attachListener(MatchedView matchedView, View rootView, EventBinding mapping) {
            if (mapping == null) {
                return;
            }
            try {
                boolean delegateSupportCodelessLogging;
                View view = matchedView.getView();
                if (view == null) {
                    return;
                }
                View RCTRootView = ViewHierarchy.findRCTRootView(view);
                if (null != RCTRootView && ViewHierarchy.isRCTButton(view, RCTRootView)) {
                    this.attachRCTListener(matchedView, rootView, RCTRootView, mapping);
                    return;
                }
                if (view.getClass().getName().startsWith("com.facebook.react")) {
                    return;
                }
                String mapKey = matchedView.getViewMapKey();
                View.AccessibilityDelegate existingDelegate = ViewHierarchy.getExistingDelegate(view);
                boolean delegateExists = existingDelegate != null;
                boolean isCodelessDelegate = delegateExists && existingDelegate instanceof CodelessLoggingEventListener.AutoLoggingAccessibilityDelegate;
                boolean bl = delegateSupportCodelessLogging = isCodelessDelegate && ((CodelessLoggingEventListener.AutoLoggingAccessibilityDelegate)existingDelegate).getSupportCodelessLogging();
                if (!(this.delegateMap.containsKey(mapKey) || delegateExists && isCodelessDelegate && delegateSupportCodelessLogging)) {
                    CodelessLoggingEventListener.AutoLoggingAccessibilityDelegate delegate = CodelessLoggingEventListener.getAccessibilityDelegate(mapping, rootView, view);
                    view.setAccessibilityDelegate((View.AccessibilityDelegate)delegate);
                    this.delegateMap.put(mapKey, mapping.getEventName());
                }
            }
            catch (FacebookException e) {
                Log.e((String)TAG, (String)"Failed to attach auto logging event listener.", (Throwable)e);
            }
        }

        private void attachRCTListener(MatchedView matchedView, View rootView, View RCTRootView, EventBinding mapping) {
            boolean listenerSupportCodelessLogging;
            if (mapping == null) {
                return;
            }
            View view = matchedView.getView();
            if (view == null || !ViewHierarchy.isRCTButton(view, RCTRootView)) {
                return;
            }
            String mapKey = matchedView.getViewMapKey();
            View.OnTouchListener existingListener = ViewHierarchy.getExistingOnTouchListener(view);
            boolean listenerExists = existingListener != null;
            boolean isCodelessListener = listenerExists && existingListener instanceof RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener;
            boolean bl = listenerSupportCodelessLogging = isCodelessListener && ((RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener)existingListener).getSupportCodelessLogging();
            if (!(this.delegateMap.containsKey(mapKey) || listenerExists && isCodelessListener && listenerSupportCodelessLogging)) {
                RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener listener = RCTCodelessLoggingEventListener.getOnTouchListener(mapping, rootView, view);
                view.setOnTouchListener((View.OnTouchListener)listener);
                this.delegateMap.put(mapKey, mapping.getEventName());
            }
        }
    }

    public static class MatchedView {
        private WeakReference<View> view;
        private String viewMapKey;

        public MatchedView(View view, String viewMapKey) {
            this.view = new WeakReference<View>(view);
            this.viewMapKey = viewMapKey;
        }

        @Nullable
        public View getView() {
            return this.view == null ? null : (View)this.view.get();
        }

        public String getViewMapKey() {
            return this.viewMapKey;
        }
    }
}

