/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.FacebookSdkNotInitializedException;
import com.facebook.GraphRequest;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

final class UserSettingsManager {
    private static final String TAG = UserSettingsManager.class.getName();
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static final String EVENTS_CODELESS_SETUP_ENABLED = "auto_event_setup_enabled";
    private static final long TIMEOUT_7D = 604800000L;
    private static final String ADVERTISER_ID_KEY = "advertiser_id";
    private static final String APPLICATION_FIELDS = "fields";
    private static UserSetting autoLogAppEventsEnabled = new UserSetting(true, "com.facebook.sdk.AutoLogAppEventsEnabled", "com.facebook.sdk.AutoLogAppEventsEnabled");
    private static UserSetting advertiserIDCollectionEnabled = new UserSetting(true, "com.facebook.sdk.AdvertiserIDCollectionEnabled", "com.facebook.sdk.AdvertiserIDCollectionEnabled");
    private static UserSetting codelessSetupEnabled = new UserSetting(false, "auto_event_setup_enabled", null);
    private static final String USER_SETTINGS = "com.facebook.sdk.USER_SETTINGS";
    private static SharedPreferences userSettingPref;
    private static SharedPreferences.Editor userSettingPrefEditor;
    private static final String LAST_TIMESTAMP = "last_timestamp";
    private static final String VALUE = "value";

    UserSettingsManager() {
    }

    public static void initializeIfNotInitialized() {
        if (!FacebookSdk.isInitialized()) {
            return;
        }
        if (!isInitialized.compareAndSet(false, true)) {
            return;
        }
        userSettingPref = FacebookSdk.getApplicationContext().getSharedPreferences(USER_SETTINGS, 0);
        userSettingPrefEditor = userSettingPref.edit();
        UserSettingsManager.initializeUserSetting(autoLogAppEventsEnabled);
        UserSettingsManager.initializeUserSetting(advertiserIDCollectionEnabled);
        UserSettingsManager.initializeCodelessSepupEnabledAsync();
    }

    private static void initializeUserSetting(UserSetting userSetting) {
        if (userSetting == codelessSetupEnabled) {
            UserSettingsManager.initializeCodelessSepupEnabledAsync();
        } else if (userSetting.value == null) {
            UserSettingsManager.readSettingFromCache(userSetting);
            if (userSetting.value == null && userSetting.keyInManifest != null) {
                UserSettingsManager.loadSettingFromManifest(userSetting);
            }
        } else {
            UserSettingsManager.writeSettingToCache(userSetting);
        }
    }

    private static void initializeCodelessSepupEnabledAsync() {
        UserSettingsManager.readSettingFromCache(codelessSetupEnabled);
        final long currTime = System.currentTimeMillis();
        if (UserSettingsManager.codelessSetupEnabled.value != null && currTime - UserSettingsManager.codelessSetupEnabled.lastTS < 604800000L) {
            return;
        }
        UserSettingsManager.codelessSetupEnabled.value = null;
        UserSettingsManager.codelessSetupEnabled.lastTS = 0L;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FetchedAppSettings appSettings;
                if (advertiserIDCollectionEnabled.getValue() && (appSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false)) != null && appSettings.getCodelessEventsEnabled()) {
                    String advertiser_id = null;
                    Context context = FacebookSdk.getApplicationContext();
                    AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                    if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                        advertiser_id = identifiers.getAndroidAdvertiserId();
                    }
                    if (advertiser_id != null) {
                        Bundle codelessSettingsParams = new Bundle();
                        codelessSettingsParams.putString(UserSettingsManager.ADVERTISER_ID_KEY, identifiers.getAndroidAdvertiserId());
                        codelessSettingsParams.putString(UserSettingsManager.APPLICATION_FIELDS, UserSettingsManager.EVENTS_CODELESS_SETUP_ENABLED);
                        GraphRequest codelessRequest = GraphRequest.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
                        codelessRequest.setSkipClientToken(true);
                        codelessRequest.setParameters(codelessSettingsParams);
                        JSONObject response = codelessRequest.executeAndWait().getJSONObject();
                        if (response != null) {
                            codelessSetupEnabled.value = response.optBoolean(UserSettingsManager.EVENTS_CODELESS_SETUP_ENABLED, false);
                            codelessSetupEnabled.lastTS = currTime;
                            UserSettingsManager.writeSettingToCache(codelessSetupEnabled);
                        }
                    }
                }
            }
        });
    }

    private static void writeSettingToCache(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(VALUE, (Object)userSetting.value);
            jsonObject.put(LAST_TIMESTAMP, userSetting.lastTS);
            userSettingPrefEditor.putString(userSetting.keyInCache, jsonObject.toString()).commit();
        }
        catch (JSONException je) {
            Utility.logd(TAG, (Exception)((Object)je));
        }
    }

    private static void readSettingFromCache(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            String settingStr = userSettingPref.getString(userSetting.keyInCache, "");
            if (!settingStr.isEmpty()) {
                JSONObject setting = new JSONObject(settingStr);
                userSetting.value = setting.getBoolean(VALUE);
                userSetting.lastTS = setting.getLong(LAST_TIMESTAMP);
            }
        }
        catch (JSONException je) {
            Utility.logd(TAG, (Exception)((Object)je));
        }
    }

    private static void loadSettingFromManifest(UserSetting userSetting) {
        UserSettingsManager.validateInitialized();
        try {
            ApplicationInfo ai = FacebookSdk.getApplicationContext().getPackageManager().getApplicationInfo(FacebookSdk.getApplicationContext().getPackageName(), 128);
            if (ai != null && ai.metaData != null && ai.metaData.containsKey(userSetting.keyInManifest)) {
                userSetting.value = ai.metaData.getBoolean(userSetting.keyInManifest, userSetting.defaultVal);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Utility.logd(TAG, (Exception)((Object)e));
        }
    }

    private static void validateInitialized() {
        if (!isInitialized.get()) {
            throw new FacebookSdkNotInitializedException("The UserSettingManager has not been initialized successfully");
        }
    }

    public static void setAutoLogAppEventsEnabled(boolean flag) {
        UserSettingsManager.autoLogAppEventsEnabled.value = flag;
        UserSettingsManager.autoLogAppEventsEnabled.lastTS = System.currentTimeMillis();
        if (isInitialized.get()) {
            UserSettingsManager.writeSettingToCache(autoLogAppEventsEnabled);
        } else {
            UserSettingsManager.initializeIfNotInitialized();
        }
    }

    public static boolean getAutoLogAppEventsEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return autoLogAppEventsEnabled.getValue();
    }

    public static void setAdvertiserIDCollectionEnabled(boolean flag) {
        UserSettingsManager.advertiserIDCollectionEnabled.value = flag;
        UserSettingsManager.advertiserIDCollectionEnabled.lastTS = System.currentTimeMillis();
        if (isInitialized.get()) {
            UserSettingsManager.writeSettingToCache(advertiserIDCollectionEnabled);
        } else {
            UserSettingsManager.initializeIfNotInitialized();
        }
    }

    public static boolean getAdvertiserIDCollectionEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return advertiserIDCollectionEnabled.getValue();
    }

    public static boolean getCodelessSetupEnabled() {
        UserSettingsManager.initializeIfNotInitialized();
        return codelessSetupEnabled.getValue();
    }

    private static class UserSetting {
        String keyInCache;
        String keyInManifest;
        Boolean value;
        boolean defaultVal;
        long lastTS;

        UserSetting(boolean defaultVal, String keyInCache, String keyInManifest) {
            this.defaultVal = defaultVal;
            this.keyInCache = keyInCache;
            this.keyInManifest = keyInManifest;
        }

        boolean getValue() {
            return this.value == null ? this.defaultVal : this.value;
        }
    }
}

