/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchedAppGateKeepersManager {
    public static final String APP_EVENTS_IF_AUTO_LOG_SUBS = "app_events_if_auto_log_subs";
    private static final String TAG = FetchedAppGateKeepersManager.class.getCanonicalName();
    private static final String APP_GATEKEEPERS_PREFS_STORE = "com.facebook.internal.preferences.APP_GATEKEEPERS";
    private static final String APP_GATEKEEPERS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_GATEKEEPERS.%s";
    private static final String APP_PLATFORM = "android";
    private static final String APPLICATION_GATEKEEPER_EDGE = "mobile_sdk_gk";
    private static final String APPLICATION_GATEKEEPER_FIELD = "gatekeepers";
    private static final String APPLICATION_GRAPH_DATA = "data";
    private static final String APPLICATION_DEVICE_ID = "device_id";
    private static final String APPLICATION_FIELDS = "fields";
    private static final String APPLICATION_PLATFORM = "platform";
    private static final String APPLICATION_SDK_VERSION = "sdk_version";
    private static final Map<String, JSONObject> fetchedAppGateKeepers = new ConcurrentHashMap<String, JSONObject>();
    private static final long APPLICATION_GATEKEEPER_CACHE_TIMEOUT = 3600000L;
    @Nullable
    private static Long timestamp = null;

    public static synchronized void loadAppGateKeepersAsync() {
        if (FetchedAppGateKeepersManager.isTimestampValid(timestamp)) {
            return;
        }
        final Context context = FacebookSdk.getApplicationContext();
        final String applicationId = FacebookSdk.getApplicationId();
        final String gateKeepersKey = String.format(APP_GATEKEEPERS_PREFS_KEY_FORMAT, applicationId);
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject gateKeepersResultJSON;
                SharedPreferences gateKeepersSharedPrefs = context.getSharedPreferences(FetchedAppGateKeepersManager.APP_GATEKEEPERS_PREFS_STORE, 0);
                String gateKeepersJSONString = gateKeepersSharedPrefs.getString(gateKeepersKey, null);
                if (!Utility.isNullOrEmpty(gateKeepersJSONString)) {
                    JSONObject gateKeepersJSON = null;
                    try {
                        gateKeepersJSON = new JSONObject(gateKeepersJSONString);
                    }
                    catch (JSONException je) {
                        Utility.logd("FacebookSDK", (Exception)((Object)je));
                    }
                    if (gateKeepersJSON != null) {
                        FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON(applicationId, gateKeepersJSON);
                    }
                }
                if ((gateKeepersResultJSON = FetchedAppGateKeepersManager.getAppGateKeepersQueryResponse(applicationId)) != null) {
                    timestamp = System.currentTimeMillis();
                    FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON(applicationId, gateKeepersResultJSON);
                    gateKeepersSharedPrefs.edit().putString(gateKeepersKey, gateKeepersResultJSON.toString()).apply();
                }
            }
        });
    }

    @Nullable
    public static JSONObject queryAppGateKeepers(String applicationId, boolean forceRequery) {
        if (!forceRequery && fetchedAppGateKeepers.containsKey(applicationId)) {
            return fetchedAppGateKeepers.get(applicationId);
        }
        JSONObject response = FetchedAppGateKeepersManager.getAppGateKeepersQueryResponse(applicationId);
        if (response == null) {
            return null;
        }
        Context context = FacebookSdk.getApplicationContext();
        String gateKeepersKey = String.format(APP_GATEKEEPERS_PREFS_KEY_FORMAT, applicationId);
        SharedPreferences gateKeepersSharedPrefs = context.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0);
        gateKeepersSharedPrefs.edit().putString(gateKeepersKey, response.toString()).apply();
        return FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON(applicationId, response);
    }

    public static boolean getGateKeeperForKey(String name, String applicationId, boolean defaultValue) {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync();
        if (applicationId == null || !fetchedAppGateKeepers.containsKey(applicationId)) {
            return defaultValue;
        }
        return fetchedAppGateKeepers.get(applicationId).optBoolean(name, defaultValue);
    }

    private static JSONObject getAppGateKeepersQueryResponse(String applicationId) {
        Bundle appGateKeepersParams = new Bundle();
        AttributionIdentifiers identifiers = AttributionIdentifiers.getCachedIdentifiers();
        String deviceId = "";
        if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
            deviceId = identifiers.getAndroidAdvertiserId();
        }
        String sdkVersion = FacebookSdk.getSdkVersion();
        appGateKeepersParams.putString(APPLICATION_PLATFORM, APP_PLATFORM);
        appGateKeepersParams.putString(APPLICATION_DEVICE_ID, deviceId);
        appGateKeepersParams.putString(APPLICATION_SDK_VERSION, sdkVersion);
        appGateKeepersParams.putString(APPLICATION_FIELDS, APPLICATION_GATEKEEPER_FIELD);
        GraphRequest request = GraphRequest.newGraphPathRequest(null, String.format("%s/%s", applicationId, APPLICATION_GATEKEEPER_EDGE), null);
        request.setSkipClientToken(true);
        request.setParameters(appGateKeepersParams);
        return request.executeAndWait().getJSONObject();
    }

    private static synchronized JSONObject parseAppGateKeepersFromJSON(String applicationId, JSONObject gateKeepersJSON) {
        JSONObject result = fetchedAppGateKeepers.containsKey(applicationId) ? fetchedAppGateKeepers.get(applicationId) : new JSONObject();
        JSONArray arr = gateKeepersJSON.optJSONArray(APPLICATION_GRAPH_DATA);
        JSONObject gateKeepers = null;
        if (arr != null) {
            gateKeepers = arr.optJSONObject(0);
        }
        if (gateKeepers != null && gateKeepers.optJSONArray(APPLICATION_GATEKEEPER_FIELD) != null) {
            JSONArray data = gateKeepers.optJSONArray(APPLICATION_GATEKEEPER_FIELD);
            for (int i = 0; i < data.length(); ++i) {
                try {
                    JSONObject gk = data.getJSONObject(i);
                    result.put(gk.getString("key"), gk.getBoolean("value"));
                    continue;
                }
                catch (JSONException je) {
                    Utility.logd("FacebookSDK", (Exception)((Object)je));
                }
            }
        }
        fetchedAppGateKeepers.put(applicationId, result);
        return result;
    }

    private static boolean isTimestampValid(Long timestamp) {
        if (timestamp == null) {
            return false;
        }
        return System.currentTimeMillis() - timestamp < 3600000L;
    }
}

