/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.ViewIndexingTrigger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SessionLogger;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ActivityLifecycleTracker {
    private static final String TAG = ActivityLifecycleTracker.class.getCanonicalName();
    private static final String INCORRECT_IMPL_WARNING = "Unexpected activity pause without a matching activity resume. Logging data may be incorrect. Make sure you call activateApp from your Application's onCreate method";
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private static volatile ScheduledFuture currentFuture;
    private static final Object currentFutureLock;
    private static AtomicInteger foregroundActivityCount;
    private static volatile SessionInfo currentSession;
    private static AtomicBoolean tracking;
    private static String appId;
    private static long currentActivityAppearTime;
    private static final CodelessMatcher codelessMatcher;
    private static final ViewIndexingTrigger viewIndexingTrigger;
    private static SensorManager sensorManager;
    private static ViewIndexer viewIndexer;
    @Nullable
    private static String deviceSessionID;
    private static Boolean isAppIndexingEnabled;
    private static volatile Boolean isCheckingSession;

    public static void startTracking(Application application, String appId) {
        if (!tracking.compareAndSet(false, true)) {
            return;
        }
        ActivityLifecycleTracker.appId = appId;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityCreated");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityCreated(activity);
            }

            public void onActivityStarted(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityStarted");
            }

            public void onActivityResumed(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityResumed");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityResumed(activity);
            }

            public void onActivityPaused(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityPaused");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityPaused(activity);
            }

            public void onActivityStopped(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityStopped");
                AppEventsLogger.onContextStop();
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityDestroyed");
            }
        });
    }

    public static boolean isTracking() {
        return tracking.get();
    }

    public static UUID getCurrentSessionGuid() {
        return currentSession != null ? currentSession.getSessionId() : null;
    }

    public static void onActivityCreated(Activity activity) {
        long currentTime = System.currentTimeMillis();
        Context applicationContext = activity.getApplicationContext();
        String activityName = Utility.getActivityName((Context)activity);
        SourceApplicationInfo sourceApplicationInfo = SourceApplicationInfo.Factory.create(activity);
        Runnable handleActivityCreate = new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    currentSession = SessionInfo.getStoredSessionInfo();
                }
            }
        };
        singleThreadExecutor.execute(handleActivityCreate);
    }

    public static void onActivityResumed(Activity activity) {
        long currentTime;
        foregroundActivityCount.incrementAndGet();
        ActivityLifecycleTracker.cancelCurrentTask();
        currentActivityAppearTime = currentTime = System.currentTimeMillis();
        final String activityName = Utility.getActivityName((Context)activity);
        codelessMatcher.add(activity);
        Runnable handleActivityResume = new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                    SessionLogger.logActivateApp(activityName, null, appId);
                } else if (currentSession.getSessionLastEventTime() != null) {
                    long suspendTime = currentTime - currentSession.getSessionLastEventTime();
                    if (suspendTime > (long)(ActivityLifecycleTracker.getSessionTimeoutInSeconds() * 1000)) {
                        SessionLogger.logDeactivateApp(activityName, currentSession, appId);
                        SessionLogger.logActivateApp(activityName, null, appId);
                        currentSession = new SessionInfo(currentTime, null);
                    } else if (suspendTime > 1000L) {
                        currentSession.incrementInterruptionCount();
                    }
                }
                currentSession.setSessionLastEventTime(currentTime);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityResume);
        Context applicationContext = activity.getApplicationContext();
        final String appId = FacebookSdk.getApplicationId();
        final FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        if (appSettings != null && appSettings.getCodelessSetupEnabled()) {
            sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
            if (sensorManager == null) {
                return;
            }
            Sensor accelerometer = sensorManager.getDefaultSensor(1);
            viewIndexer = new ViewIndexer(activity);
            viewIndexingTrigger.setOnShakeListener(new ViewIndexingTrigger.OnShakeListener(){

                @Override
                public void onShake() {
                    if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                        ActivityLifecycleTracker.checkCodelessSession(appId);
                    }
                }
            });
            sensorManager.registerListener((SensorEventListener)viewIndexingTrigger, accelerometer, 2);
            if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                viewIndexer.schedule();
            }
        }
    }

    private static void onActivityPaused(Activity activity) {
        int count = foregroundActivityCount.decrementAndGet();
        if (count < 0) {
            foregroundActivityCount.set(0);
            Log.w((String)TAG, (String)INCORRECT_IMPL_WARNING);
        }
        ActivityLifecycleTracker.cancelCurrentTask();
        final long currentTime = System.currentTimeMillis();
        final String activityName = Utility.getActivityName((Context)activity);
        codelessMatcher.remove(activity);
        Runnable handleActivityPaused = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long appearTime;
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                }
                currentSession.setSessionLastEventTime(currentTime);
                if (foregroundActivityCount.get() <= 0) {
                    Runnable task = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (foregroundActivityCount.get() <= 0) {
                                SessionLogger.logDeactivateApp(activityName, currentSession, appId);
                                SessionInfo.clearSavedSessionFromDisk();
                                currentSession = null;
                            }
                            Object object = currentFutureLock;
                            synchronized (object) {
                                currentFuture = null;
                            }
                        }
                    };
                    Object object = currentFutureLock;
                    synchronized (object) {
                        currentFuture = singleThreadExecutor.schedule(task, (long)ActivityLifecycleTracker.getSessionTimeoutInSeconds(), TimeUnit.SECONDS);
                    }
                }
                long timeSpentOnActivityInSeconds = (appearTime = currentActivityAppearTime) > 0L ? (currentTime - appearTime) / 1000L : 0L;
                AutomaticAnalyticsLogger.logActivityTimeSpentEvent(activityName, timeSpentOnActivityInSeconds);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityPaused);
        if (null != viewIndexer) {
            viewIndexer.unschedule();
        }
        if (null != sensorManager) {
            sensorManager.unregisterListener((SensorEventListener)viewIndexingTrigger);
        }
    }

    private static int getSessionTimeoutInSeconds() {
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.getApplicationId());
        if (settings == null) {
            return Constants.getDefaultAppEventsSessionTimeoutInSeconds();
        }
        return settings.getSessionTimeoutInSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelCurrentTask() {
        Object object = currentFutureLock;
        synchronized (object) {
            if (currentFuture != null) {
                currentFuture.cancel(false);
            }
            currentFuture = null;
        }
    }

    public static void checkCodelessSession(final String applicationId) {
        if (isCheckingSession.booleanValue()) {
            return;
        }
        isCheckingSession = true;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                GraphRequest request = GraphRequest.newPostRequest(null, String.format(Locale.US, "%s/app_indexing_session", applicationId), null, null);
                Bundle requestParameters = request.getParameters();
                if (requestParameters == null) {
                    requestParameters = new Bundle();
                }
                Context context = FacebookSdk.getApplicationContext();
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                JSONArray extInfoArray = new JSONArray();
                extInfoArray.put((Object)(Build.MODEL != null ? Build.MODEL : ""));
                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                    extInfoArray.put((Object)identifiers.getAndroidAdvertiserId());
                } else {
                    extInfoArray.put((Object)"");
                }
                extInfoArray.put((Object)"0");
                extInfoArray.put((Object)(AppEventUtility.isEmulator() ? "1" : "0"));
                Locale locale = Utility.getCurrentLocale();
                extInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
                String extInfo = extInfoArray.toString();
                requestParameters.putString("device_session_id", ActivityLifecycleTracker.getCurrentDeviceSessionID());
                requestParameters.putString("extinfo", extInfo);
                request.setParameters(requestParameters);
                if (request != null) {
                    GraphResponse res = request.executeAndWait();
                    JSONObject jsonRes = res.getJSONObject();
                    isAppIndexingEnabled = jsonRes != null && jsonRes.optBoolean("is_app_indexing_enabled", false);
                    if (!isAppIndexingEnabled.booleanValue()) {
                        deviceSessionID = null;
                    } else {
                        viewIndexer.schedule();
                    }
                }
                isCheckingSession = false;
            }
        });
    }

    public static String getCurrentDeviceSessionID() {
        if (null == deviceSessionID) {
            deviceSessionID = UUID.randomUUID().toString();
        }
        return deviceSessionID;
    }

    public static boolean getIsAppIndexingEnabled() {
        return isAppIndexingEnabled;
    }

    public static void updateAppIndexing(Boolean appIndexingEnalbed) {
        isAppIndexingEnabled = appIndexingEnalbed;
    }

    static {
        currentFutureLock = new Object();
        foregroundActivityCount = new AtomicInteger(0);
        tracking = new AtomicBoolean(false);
        codelessMatcher = new CodelessMatcher();
        viewIndexingTrigger = new ViewIndexingTrigger();
        deviceSessionID = null;
        isAppIndexingEnabled = false;
        isCheckingSession = false;
    }
}

