/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookUninstallTracker {
    private static final String TAG = FacebookUninstallTracker.class.getCanonicalName();
    private static final String PLATFORM = "android";
    private static final String SUCCESS = "success";
    private static final String UPLOADED_TOKEN_STORE = "com.facebook.appevents.FacebookUninstallTracker.UPLOADED_TOKEN";
    private static final SharedPreferences uploadedTokenSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.appevents.FacebookUninstallTracker.UPLOADED_TOKEN", 0);

    public static void updateDeviceToken(String deviceToken) {
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        if (appSettings == null) {
            return;
        }
        boolean nowTrackUninstallEnabled = appSettings.getTrackUninstallEnabled();
        String uploadedToken = uploadedTokenSharedPrefs.getString("uploaded_token", null);
        boolean preTrackUninstallEnabled = uploadedTokenSharedPrefs.getBoolean("pre_track_uninstall_enabled", false);
        if (!(!nowTrackUninstallEnabled || preTrackUninstallEnabled && deviceToken.equals(uploadedToken))) {
            FacebookUninstallTracker.sendToServer(deviceToken);
        } else if (!nowTrackUninstallEnabled && preTrackUninstallEnabled) {
            SharedPreferences.Editor editor = uploadedTokenSharedPrefs.edit();
            editor.putBoolean("pre_track_uninstall_enabled", false).apply();
        }
    }

    private static void sendToServer(final String deviceToken) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String appId = FacebookSdk.getApplicationId();
                GraphRequest request = FacebookUninstallTracker.buildPushDeviceTokenRequest(appId, deviceToken);
                if (request != null) {
                    GraphResponse res = request.executeAndWait();
                    try {
                        JSONObject jsonRes = res.getJSONObject();
                        if (jsonRes != null) {
                            if (jsonRes.has(FacebookUninstallTracker.SUCCESS) && jsonRes.getString(FacebookUninstallTracker.SUCCESS).equals("true")) {
                                SharedPreferences.Editor editor = uploadedTokenSharedPrefs.edit();
                                editor.putString("uploaded_token", deviceToken).putBoolean("pre_track_uninstall_enabled", true).apply();
                            } else {
                                Log.e((String)TAG, (String)("Error sending device token to Facebook: " + res.getError()));
                            }
                        }
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"Error decoding server response.", (Throwable)e);
                    }
                }
            }
        });
    }

    @Nullable
    private static GraphRequest buildPushDeviceTokenRequest(String appId, String deviceToken) {
        GraphRequest postRequest = GraphRequest.newPostRequest(null, String.format(Locale.US, "%s/app_push_device_token", appId), null, null);
        postRequest.setSkipClientToken(true);
        Context context = FacebookSdk.getApplicationContext();
        AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
        if (identifiers == null) {
            return null;
        }
        String deviceId = identifiers.getAndroidAdvertiserId();
        Bundle requestParameters = postRequest.getParameters();
        if (requestParameters == null) {
            requestParameters = new Bundle();
        }
        requestParameters.putString("device_id", deviceId);
        requestParameters.putString("device_token", deviceToken);
        requestParameters.putString("platform", PLATFORM);
        postRequest.setParameters(requestParameters);
        return postRequest;
    }
}

