/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.internal.InternalAppEventsLogger;
import com.facebook.appevents.internal.SubscriptionType;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Validate;
import java.math.BigDecimal;
import java.util.Currency;
import org.json.JSONException;
import org.json.JSONObject;

public class AutomaticAnalyticsLogger {
    private static final String TAG = AutomaticAnalyticsLogger.class.getCanonicalName();
    private static final InternalAppEventsLogger internalAppEventsLogger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());

    public static void logActivateAppEvent() {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        boolean autoLogAppEvents = FacebookSdk.getAutoLogAppEventsEnabled();
        Validate.notNull(context, "context");
        if (autoLogAppEvents) {
            if (context instanceof Application) {
                AppEventsLogger.activateApp((Application)context, appId);
            } else {
                Log.w((String)TAG, (String)"Automatic logging of basic events will not happen, because FacebookSdk.getApplicationContext() returns object that is not instance of android.app.Application. Make sure you call FacebookSdk.sdkInitialize() from Application class and pass application context.");
            }
        }
    }

    public static void logActivityTimeSpentEvent(String activityName, long timeSpentInSeconds) {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        Validate.notNull(context, "context");
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(appId, false);
        if (settings != null && settings.getAutomaticLoggingEnabled() && timeSpentInSeconds > 0L) {
            AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_aa_time_spent_view_name", (CharSequence)activityName);
            appEventsLogger.logEvent("fb_aa_time_spent_on_view", timeSpentInSeconds, params);
        }
    }

    public static void logPurchaseInapp(String purchase, String skuDetails) {
        if (!AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            return;
        }
        PurchaseLoggingParameters loggingParameters = AutomaticAnalyticsLogger.getPurchaseLoggingParameters(purchase, skuDetails);
        if (loggingParameters != null) {
            internalAppEventsLogger.logPurchaseImplicitlyInternal(loggingParameters.purchaseAmount, loggingParameters.currency, loggingParameters.param);
        }
    }

    public static void logPurchaseSubs(SubscriptionType subsType, String purchase, String skuDetails) {
        String eventName;
        if (!AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            return;
        }
        String applicationId = FacebookSdk.getApplicationId();
        switch (subsType) {
            case RESTORE: {
                eventName = "SubscriptionRestore";
                break;
            }
            case CANCEL: {
                eventName = "SubscriptionCancel";
                break;
            }
            case HEARTBEAT: {
                eventName = "SubscriptionHeartbeat";
                break;
            }
            case EXPIRE: {
                eventName = "SubscriptionExpire";
                break;
            }
            case NEW: {
                if (FetchedAppGateKeepersManager.getGateKeeperForKey("app_events_if_auto_log_subs", applicationId, true)) {
                    eventName = "Subscribe";
                    break;
                }
                AutomaticAnalyticsLogger.logPurchaseInapp(purchase, skuDetails);
            }
            default: {
                return;
            }
        }
        PurchaseLoggingParameters loggingParameters = AutomaticAnalyticsLogger.getPurchaseLoggingParameters(purchase, skuDetails);
        if (loggingParameters != null) {
            internalAppEventsLogger.logEventImplicitly(eventName, loggingParameters.purchaseAmount, loggingParameters.currency, loggingParameters.param);
        }
    }

    public static boolean isImplicitPurchaseLoggingEnabled() {
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        return settings != null && FacebookSdk.getAutoLogAppEventsEnabled() && settings.getIAPAutomaticLoggingEnabled();
    }

    @Nullable
    private static PurchaseLoggingParameters getPurchaseLoggingParameters(String purchase, String skuDetails) {
        try {
            JSONObject purchaseJSON = new JSONObject(purchase);
            JSONObject skuDetailsJSON = new JSONObject(skuDetails);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_iap_product_id", (CharSequence)purchaseJSON.getString("productId"));
            params.putCharSequence("fb_iap_purchase_time", (CharSequence)purchaseJSON.getString("purchaseTime"));
            params.putCharSequence("fb_iap_purchase_token", (CharSequence)purchaseJSON.getString("purchaseToken"));
            params.putCharSequence("fb_iap_package_name", (CharSequence)purchaseJSON.optString("packageName"));
            params.putCharSequence("fb_iap_product_title", (CharSequence)skuDetailsJSON.optString("title"));
            params.putCharSequence("fb_iap_product_description", (CharSequence)skuDetailsJSON.optString("description"));
            String type = skuDetailsJSON.optString("type");
            params.putCharSequence("fb_iap_product_type", (CharSequence)type);
            if (type.equals("subs")) {
                params.putCharSequence("fb_iap_subs_auto_renewing", (CharSequence)Boolean.toString(purchaseJSON.optBoolean("autoRenewing", false)));
                params.putCharSequence("fb_iap_subs_period", (CharSequence)skuDetailsJSON.optString("subscriptionPeriod"));
                params.putCharSequence("fb_free_trial_period", (CharSequence)skuDetailsJSON.optString("freeTrialPeriod"));
                String introductoryPriceCycles = skuDetailsJSON.optString("introductoryPriceCycles");
                if (!introductoryPriceCycles.isEmpty()) {
                    params.putCharSequence("fb_intro_price_amount_micros", (CharSequence)skuDetailsJSON.optString("introductoryPriceAmountMicros"));
                    params.putCharSequence("fb_intro_price_cycles", (CharSequence)introductoryPriceCycles);
                }
            }
            return new PurchaseLoggingParameters(new BigDecimal((double)skuDetailsJSON.getLong("price_amount_micros") / 1000000.0), Currency.getInstance(skuDetailsJSON.getString("price_currency_code")), params);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error parsing in-app subscription data.", (Throwable)e);
            return null;
        }
    }

    private static class PurchaseLoggingParameters {
        BigDecimal purchaseAmount;
        Currency currency;
        Bundle param;

        PurchaseLoggingParameters(BigDecimal purchaseAmount, Currency currency, Bundle param) {
            this.purchaseAmount = purchaseAmount;
            this.currency = currency;
            this.param = param;
        }
    }
}

