/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import com.facebook.GraphRequest;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.internal.AppEventsLoggerUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SessionEventsState {
    private List<AppEvent> accumulatedEvents = new ArrayList<AppEvent>();
    private List<AppEvent> inFlightEvents = new ArrayList<AppEvent>();
    private int numSkippedEventsDueToFullBuffer;
    private AttributionIdentifiers attributionIdentifiers;
    private String anonymousAppDeviceGUID;
    private final int MAX_ACCUMULATED_LOG_EVENTS = 1000;

    public SessionEventsState(AttributionIdentifiers identifiers, String anonymousGUID) {
        this.attributionIdentifiers = identifiers;
        this.anonymousAppDeviceGUID = anonymousGUID;
    }

    public synchronized void addEvent(AppEvent event) {
        if (this.accumulatedEvents.size() + this.inFlightEvents.size() >= 1000) {
            ++this.numSkippedEventsDueToFullBuffer;
        } else {
            this.accumulatedEvents.add(event);
        }
    }

    public synchronized int getAccumulatedEventCount() {
        return this.accumulatedEvents.size();
    }

    public synchronized void clearInFlightAndStats(boolean moveToAccumulated) {
        if (moveToAccumulated) {
            this.accumulatedEvents.addAll(this.inFlightEvents);
        }
        this.inFlightEvents.clear();
        this.numSkippedEventsDueToFullBuffer = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int populateRequest(GraphRequest request, Context applicationContext, boolean includeImplicitEvents, boolean limitEventUsage) {
        JSONArray jsonArray;
        int numSkipped;
        SessionEventsState sessionEventsState = this;
        synchronized (sessionEventsState) {
            numSkipped = this.numSkippedEventsDueToFullBuffer;
            this.inFlightEvents.addAll(this.accumulatedEvents);
            this.accumulatedEvents.clear();
            jsonArray = new JSONArray();
            for (AppEvent event : this.inFlightEvents) {
                if (event.isChecksumValid()) {
                    if (!includeImplicitEvents && event.getIsImplicit()) continue;
                    jsonArray.put((Object)event.getJSONObject());
                    continue;
                }
                Utility.logd("Event with invalid checksum: %s", event.toString());
            }
            if (jsonArray.length() == 0) {
                return 0;
            }
        }
        this.populateRequest(request, applicationContext, numSkipped, jsonArray, limitEventUsage);
        return jsonArray.length();
    }

    public synchronized List<AppEvent> getEventsToPersist() {
        List<AppEvent> result = this.accumulatedEvents;
        this.accumulatedEvents = new ArrayList<AppEvent>();
        return result;
    }

    public synchronized void accumulatePersistedEvents(List<AppEvent> events) {
        this.accumulatedEvents.addAll(events);
    }

    private void populateRequest(GraphRequest request, Context applicationContext, int numSkipped, JSONArray events, boolean limitEventUsage) {
        String jsonString;
        JSONObject publishParams = null;
        try {
            publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.CUSTOM_APP_EVENTS, this.attributionIdentifiers, this.anonymousAppDeviceGUID, limitEventUsage, applicationContext);
            if (this.numSkippedEventsDueToFullBuffer > 0) {
                publishParams.put("num_skipped_events", numSkipped);
            }
        }
        catch (JSONException e) {
            publishParams = new JSONObject();
        }
        request.setGraphObject(publishParams);
        Bundle requestParameters = request.getParameters();
        if (requestParameters == null) {
            requestParameters = new Bundle();
        }
        if ((jsonString = events.toString()) != null) {
            requestParameters.putString("custom_events", jsonString);
            request.setTag(jsonString);
        }
        request.setParameters(requestParameters);
    }
}

