/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.support.annotation.Nullable;
import android.support.v4.view.NestedScrollingChild;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewHierarchy {
    private static final String TAG = ViewHierarchy.class.getCanonicalName();
    private static final String GET_ACCESSIBILITY_METHOD = "getAccessibilityDelegate";
    private static final String ID_KEY = "id";
    private static final String CLASS_NAME_KEY = "classname";
    private static final String CLASS_TYPE_BITMASK_KEY = "classtypebitmask";
    private static final String TEXT_KEY = "text";
    private static final String DESC_KEY = "description";
    private static final String DIMENSION_KEY = "dimension";
    private static final String TAG_KEY = "tag";
    private static final String CHILDREN_VIEW_KEY = "childviews";
    private static final String HINT_KEY = "hint";
    private static final String DIMENSION_TOP_KEY = "top";
    private static final String DIMENSION_LEFT_KEY = "left";
    private static final String DIMENSION_WIDTH_KEY = "width";
    private static final String DIMENSION_HEIGHT_KEY = "height";
    private static final String DIMENSION_SCROLL_X_KEY = "scrollx";
    private static final String DIMENSION_SCROLL_Y_KEY = "scrolly";
    private static final String DIMENSION_VISIBILITY_KEY = "visibility";
    private static final int TEXTVIEW_BITMASK = 0;
    private static final int IMAGEVIEW_BITMASK = 1;
    private static final int BUTTON_BITMASK = 2;
    private static final int CLICKABLE_VIEW_BITMASK = 5;
    private static final int REACT_NATIVE_BUTTON_BITMASK = 6;
    private static final int ADAPTER_VIEW_ITEM_BITMASK = 9;
    private static final int LABEL_BITMASK = 10;
    private static final int INPUT_BITMASK = 11;
    private static final int PICKER_BITMASK = 12;
    private static final int SWITCH_BITMASK = 13;
    private static final int RADIO_GROUP_BITMASK = 14;
    private static final int CHECKBOX_BITMASK = 15;
    private static final int RATINGBAR_BITMASK = 16;

    @Nullable
    public static ViewGroup getParentOfView(View view) {
        if (null == view) {
            return null;
        }
        ViewParent parent = view.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            return (ViewGroup)parent;
        }
        return null;
    }

    public static List<View> getChildrenOfView(View view) {
        ArrayList<View> children = new ArrayList<View>();
        if (view != null && view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                children.add(viewGroup.getChildAt(i));
            }
        }
        return children;
    }

    public static JSONObject getDictionaryOfView(View view) {
        JSONObject json = new JSONObject();
        try {
            String text = ViewHierarchy.getTextOfView(view);
            String hint = ViewHierarchy.getHintOfView(view);
            Object tag = view.getTag();
            CharSequence description = view.getContentDescription();
            json.put(CLASS_NAME_KEY, (Object)view.getClass().getCanonicalName());
            json.put(CLASS_TYPE_BITMASK_KEY, ViewHierarchy.getClassTypeBitmask(view));
            json.put(ID_KEY, view.getId());
            if (!SensitiveUserDataUtils.isSensitiveUserData(view)) {
                json.put(TEXT_KEY, (Object)text);
            } else {
                json.put(TEXT_KEY, (Object)"");
            }
            json.put(HINT_KEY, (Object)hint);
            if (tag != null) {
                json.put(TAG_KEY, (Object)tag.toString());
            }
            if (description != null) {
                json.put(DESC_KEY, (Object)description.toString());
            }
            JSONObject dimension = ViewHierarchy.getDimensionOfView(view);
            json.put(DIMENSION_KEY, (Object)dimension);
            JSONArray childviews = new JSONArray();
            List<View> children = ViewHierarchy.getChildrenOfView(view);
            for (int i = 0; i < children.size(); ++i) {
                View child = children.get(i);
                JSONObject childInfo = ViewHierarchy.getDictionaryOfView(child);
                childviews.put((Object)childInfo);
            }
            json.put(CHILDREN_VIEW_KEY, (Object)childviews);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create JSONObject for view.", (Throwable)e);
        }
        return json;
    }

    private static int getClassTypeBitmask(View view) {
        String className;
        int bitmask = 0;
        if (view instanceof ImageView) {
            bitmask |= 2;
        }
        if (ViewHierarchy.isClickableView(view)) {
            bitmask |= 0x20;
        }
        if (ViewHierarchy.isAdapterViewItem(view)) {
            bitmask |= 0x200;
        }
        if (view instanceof TextView) {
            bitmask |= 0x400;
            bitmask |= 1;
            if (view instanceof Button) {
                bitmask |= 4;
                if (view instanceof Switch) {
                    bitmask |= 0x2000;
                } else if (view instanceof CheckBox) {
                    bitmask |= 0x8000;
                }
            }
            if (view instanceof EditText) {
                bitmask |= 0x800;
            }
        } else if (view instanceof Spinner || view instanceof DatePicker) {
            bitmask |= 0x1000;
        } else if (view instanceof RatingBar) {
            bitmask |= 0x10000;
        } else if (view instanceof RadioGroup) {
            bitmask |= 0x4000;
        } else if (view instanceof ViewGroup && (className = view.getClass().getName()).equals("com.facebook.react.views.view.ReactViewGroup") && ViewHierarchy.getExistingDelegate(view) != null) {
            bitmask |= 0x40;
        }
        return bitmask;
    }

    public static boolean isClickableView(View view) {
        try {
            Field listenerInfoField = null;
            listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
            if (listenerInfoField != null) {
                listenerInfoField.setAccessible(true);
            }
            Object listenerObj = null;
            listenerObj = listenerInfoField.get(view);
            if (listenerObj == null) {
                return false;
            }
            Field listenerField = null;
            View.OnClickListener listener = null;
            listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
            if (listenerField != null) {
                listener = (View.OnClickListener)listenerField.get(listenerObj);
            }
            return listener != null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to check if the view is clickable.", (Throwable)e);
            return false;
        }
    }

    private static boolean isAdapterViewItem(View view) {
        ViewParent parent = view.getParent();
        return parent != null && (parent instanceof AdapterView || parent instanceof NestedScrollingChild);
    }

    public static String getTextOfView(View view) {
        CharSequence textObj = null;
        if (view instanceof TextView) {
            textObj = ((TextView)view).getText();
            if (view instanceof Switch) {
                boolean isOn = ((Switch)view).isChecked();
                textObj = isOn ? "1" : "0";
            }
        } else if (view instanceof Spinner) {
            Object selectedItem = ((Spinner)view).getSelectedItem();
            if (selectedItem != null) {
                textObj = selectedItem.toString();
            }
        } else if (view instanceof DatePicker) {
            DatePicker picker = (DatePicker)view;
            int y = picker.getYear();
            int m = picker.getMonth();
            int d = picker.getDayOfMonth();
            textObj = String.format("%04d-%02d-%02d", y, m, d);
        } else if (view instanceof TimePicker) {
            TimePicker picker = (TimePicker)view;
            int h = picker.getCurrentHour();
            int m = picker.getCurrentMinute();
            textObj = String.format("%02d:%02d", h, m);
        } else if (view instanceof RadioGroup) {
            RadioGroup radioGroup = (RadioGroup)view;
            int checkedId = radioGroup.getCheckedRadioButtonId();
            int childCount = radioGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = radioGroup.getChildAt(i);
                if (child.getId() != checkedId || !(child instanceof RadioButton)) continue;
                textObj = ((RadioButton)child).getText();
                break;
            }
        } else if (view instanceof RatingBar) {
            RatingBar bar = (RatingBar)view;
            float rating = bar.getRating();
            textObj = String.valueOf(rating);
        }
        return textObj == null ? "" : ((Object)textObj).toString();
    }

    public static String getHintOfView(View view) {
        CharSequence hintObj = null;
        if (view instanceof TextView) {
            hintObj = ((TextView)view).getHint();
        } else if (view instanceof EditText) {
            hintObj = ((EditText)view).getHint();
        }
        return hintObj == null ? "" : ((Object)hintObj).toString();
    }

    private static JSONObject getDimensionOfView(View view) {
        JSONObject dimension = new JSONObject();
        try {
            dimension.put(DIMENSION_TOP_KEY, view.getTop());
            dimension.put(DIMENSION_LEFT_KEY, view.getLeft());
            dimension.put(DIMENSION_WIDTH_KEY, view.getWidth());
            dimension.put(DIMENSION_HEIGHT_KEY, view.getHeight());
            dimension.put(DIMENSION_SCROLL_X_KEY, view.getScrollX());
            dimension.put(DIMENSION_SCROLL_Y_KEY, view.getScrollY());
            dimension.put(DIMENSION_VISIBILITY_KEY, view.getVisibility());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create JSONObject for dimension.", (Throwable)e);
        }
        return dimension;
    }

    @Nullable
    public static View.AccessibilityDelegate getExistingDelegate(View view) {
        try {
            Class<?> viewClass = view.getClass();
            Method getAccessibilityDelegateMethod = viewClass.getMethod(GET_ACCESSIBILITY_METHOD, new Class[0]);
            return (View.AccessibilityDelegate)getAccessibilityDelegateMethod.invoke((Object)view, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

