/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.webkit.WebView;
import bolts.AppLinks;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AnalyticsUserIDStore;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventQueue;
import com.facebook.appevents.FacebookSDKJSInterface;
import com.facebook.appevents.FacebookTimeSpentData;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.UserDataStore;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppEventsLogger {
    private static final String TAG = AppEventsLogger.class.getCanonicalName();
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    private static final int FLUSH_APP_SESSION_INFO_IN_SECONDS = 30;
    public static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final String SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT = "_fbSourceApplicationHasBeenSet";
    private static final String PUSH_PAYLOAD_KEY = "fb_push_payload";
    private static final String PUSH_PAYLOAD_CAMPAIGN_KEY = "campaign";
    private static final String APP_EVENT_NAME_PUSH_OPENED = "fb_mobile_push_opened";
    private static final String APP_EVENT_PUSH_PARAMETER_CAMPAIGN = "fb_push_campaign";
    private static final String APP_EVENT_PUSH_PARAMETER_ACTION = "fb_push_action";
    private final String contextName;
    private final AccessTokenAppIdPair accessTokenAppId;
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    private static FlushBehavior flushBehavior;
    private static Object staticLock;
    private static String anonymousAppDeviceGUID;
    private static String sourceApplication;
    private static boolean isOpenedByAppLink;
    private static boolean isActivateAppEventRequested;
    private static String pushNotificationsRegistrationId;
    public static final String ACTION_APP_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_FLUSHED";
    public static final String APP_EVENTS_EXTRA_NUM_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED";
    public static final String APP_EVENTS_EXTRA_FLUSH_RESULT = "com.facebook.sdk.APP_EVENTS_FLUSH_RESULT";

    public static void activateApp(Application application) {
        AppEventsLogger.activateApp(application, null);
    }

    public static void activateApp(Application application, String applicationId) {
        if (!FacebookSdk.isInitialized()) {
            throw new FacebookException("The Facebook sdk must be initialized before calling activateApp");
        }
        AnalyticsUserIDStore.initStore();
        UserDataStore.initStore();
        if (applicationId == null) {
            applicationId = FacebookSdk.getApplicationId();
        }
        FacebookSdk.publishInstallAsync((Context)application, applicationId);
        ActivityLifecycleTracker.startTracking(application, applicationId);
    }

    @Deprecated
    public static void activateApp(Context context) {
        if (ActivityLifecycleTracker.isTracking()) {
            Log.w((String)TAG, (String)"activateApp events are being logged automatically. There's no need to call activateApp explicitly, this is safe to remove.");
            return;
        }
        FacebookSdk.sdkInitialize(context);
        AppEventsLogger.activateApp(context, Utility.getMetadataApplicationId(context));
    }

    @Deprecated
    public static void activateApp(Context context, String applicationId) {
        if (ActivityLifecycleTracker.isTracking()) {
            Log.w((String)TAG, (String)"activateApp events are being logged automatically. There's no need to call activateApp explicitly, this is safe to remove.");
            return;
        }
        if (context == null || applicationId == null) {
            throw new IllegalArgumentException("Both context and applicationId must be non-null");
        }
        AnalyticsUserIDStore.initStore();
        UserDataStore.initStore();
        if (context instanceof Activity) {
            AppEventsLogger.setSourceApplication((Activity)context);
        } else {
            AppEventsLogger.resetSourceApplication();
            Utility.logd(AppEventsLogger.class.getName(), "To set source application the context of activateApp must be an instance of Activity");
        }
        FacebookSdk.publishInstallAsync(context, applicationId);
        final AppEventsLogger logger = new AppEventsLogger(context, applicationId, null);
        final long eventTime = System.currentTimeMillis();
        final String sourceApplicationInfo = AppEventsLogger.getSourceApplication();
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                logger.logAppSessionResumeEvent(eventTime, sourceApplicationInfo);
            }
        });
    }

    @Deprecated
    public static void deactivateApp(Context context) {
        if (ActivityLifecycleTracker.isTracking()) {
            Log.w((String)TAG, (String)"deactivateApp events are being logged automatically. There's no need to call deactivateApp, this is safe to remove.");
            return;
        }
        AppEventsLogger.deactivateApp(context, Utility.getMetadataApplicationId(context));
    }

    @Deprecated
    public static void deactivateApp(Context context, String applicationId) {
        if (ActivityLifecycleTracker.isTracking()) {
            Log.w((String)TAG, (String)"deactivateApp events are being logged automatically. There's no need to call deactivateApp, this is safe to remove.");
            return;
        }
        if (context == null || applicationId == null) {
            throw new IllegalArgumentException("Both context and applicationId must be non-null");
        }
        AppEventsLogger.resetSourceApplication();
        final AppEventsLogger logger = new AppEventsLogger(context, applicationId, null);
        final long eventTime = System.currentTimeMillis();
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                logger.logAppSessionSuspendEvent(eventTime);
            }
        });
    }

    private void logAppSessionResumeEvent(long eventTime, String sourceApplicationInfo) {
        PersistedAppSessionInfo.onResume(FacebookSdk.getApplicationContext(), this.accessTokenAppId, this, eventTime, sourceApplicationInfo);
    }

    private void logAppSessionSuspendEvent(long eventTime) {
        PersistedAppSessionInfo.onSuspend(FacebookSdk.getApplicationContext(), this.accessTokenAppId, this, eventTime);
    }

    public static void initializeLib(Context context, String applicationId) {
        if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
            return;
        }
        final AppEventsLogger logger = new AppEventsLogger(context, applicationId, null);
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Bundle params = new Bundle();
                try {
                    Class.forName("com.facebook.core.Core");
                    params.putInt("core_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.login.Login");
                    params.putInt("login_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.share.Share");
                    params.putInt("share_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.places.Places");
                    params.putInt("places_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.messenger.Messenger");
                    params.putInt("messenger_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.applinks.AppLinks");
                    params.putInt("applinks_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.marketing.Marketing");
                    params.putInt("marketing_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.facebook.all.All");
                    params.putInt("all_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.android.billingclient.api.BillingClient");
                    params.putInt("billing_client_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    Class.forName("com.android.vending.billing.IInAppBillingService");
                    params.putInt("billing_service_lib_included", 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                logger.logSdkEvent("fb_sdk_initialize", null, params);
            }
        });
    }

    public static AppEventsLogger newLogger(Context context) {
        return new AppEventsLogger(context, null, null);
    }

    public static AppEventsLogger newLogger(Context context, AccessToken accessToken) {
        return new AppEventsLogger(context, null, accessToken);
    }

    public static AppEventsLogger newLogger(Context context, String applicationId, AccessToken accessToken) {
        return new AppEventsLogger(context, applicationId, accessToken);
    }

    public static AppEventsLogger newLogger(Context context, String applicationId) {
        return new AppEventsLogger(context, applicationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlushBehavior getFlushBehavior() {
        Object object = staticLock;
        synchronized (object) {
            return flushBehavior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFlushBehavior(FlushBehavior flushBehavior) {
        Object object = staticLock;
        synchronized (object) {
            AppEventsLogger.flushBehavior = flushBehavior;
        }
    }

    public void logEvent(String eventName) {
        this.logEvent(eventName, null);
    }

    public void logEvent(String eventName, double valueToSum) {
        this.logEvent(eventName, valueToSum, null);
    }

    public void logEvent(String eventName, Bundle parameters) {
        this.logEvent(eventName, null, parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    public void logEvent(String eventName, double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency) {
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            Log.w((String)TAG, (String)"You are logging purchase events while auto-logging of in-app purchase is enabled in the SDK. Make sure you don't log duplicate events");
        }
        this.logPurchase(purchaseAmount, currency, null, false);
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            Log.w((String)TAG, (String)"You are logging purchase events while auto-logging of in-app purchase is enabled in the SDK. Make sure you don't log duplicate events");
        }
        this.logPurchase(purchaseAmount, currency, parameters, false);
    }

    @Deprecated
    public void logPurchaseImplicitly(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        String errMsg = "Function logPurchaseImplicitly() is deprecated and your purchase events cannot be logged with this function. ";
        errMsg = AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled() ? errMsg + "Auto-logging of in-app purchase has been enabled in the SDK, so you don't have to manually log purchases" : errMsg + "Please use logPurchase() function instead.";
        Log.e((String)TAG, (String)errMsg);
    }

    protected void logPurchaseImplicitlyInternal(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        this.logPurchase(purchaseAmount, currency, parameters, true);
    }

    private void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters, boolean isImplicitlyLogged) {
        if (purchaseAmount == null) {
            AppEventsLogger.notifyDeveloperError("purchaseAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLogger.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_currency", currency.getCurrencyCode());
        this.logEvent("fb_mobile_purchase", purchaseAmount.doubleValue(), parameters, isImplicitlyLogged, ActivityLifecycleTracker.getCurrentSessionGuid());
        AppEventsLogger.eagerFlush();
    }

    public void logPushNotificationOpen(Bundle payload) {
        this.logPushNotificationOpen(payload, null);
    }

    public void logPushNotificationOpen(Bundle payload, String action) {
        String campaignId = null;
        try {
            String payloadString = payload.getString(PUSH_PAYLOAD_KEY);
            if (Utility.isNullOrEmpty(payloadString)) {
                return;
            }
            JSONObject facebookPayload = new JSONObject(payloadString);
            campaignId = facebookPayload.getString(PUSH_PAYLOAD_CAMPAIGN_KEY);
        }
        catch (JSONException payloadString) {
            // empty catch block
        }
        if (campaignId == null) {
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Malformed payload specified for logging a push notification open.");
            return;
        }
        Bundle parameters = new Bundle();
        parameters.putString(APP_EVENT_PUSH_PARAMETER_CAMPAIGN, campaignId);
        if (action != null) {
            parameters.putString(APP_EVENT_PUSH_PARAMETER_ACTION, action);
        }
        this.logEvent(APP_EVENT_NAME_PUSH_OPENED, parameters);
    }

    public void logProductItem(String itemID, ProductAvailability availability, ProductCondition condition, String description, String imageLink, String link, String title, BigDecimal priceAmount, Currency currency, String gtin, String mpn, String brand, Bundle parameters) {
        if (itemID == null) {
            AppEventsLogger.notifyDeveloperError("itemID cannot be null");
            return;
        }
        if (availability == null) {
            AppEventsLogger.notifyDeveloperError("availability cannot be null");
            return;
        }
        if (condition == null) {
            AppEventsLogger.notifyDeveloperError("condition cannot be null");
            return;
        }
        if (description == null) {
            AppEventsLogger.notifyDeveloperError("description cannot be null");
            return;
        }
        if (imageLink == null) {
            AppEventsLogger.notifyDeveloperError("imageLink cannot be null");
            return;
        }
        if (link == null) {
            AppEventsLogger.notifyDeveloperError("link cannot be null");
            return;
        }
        if (title == null) {
            AppEventsLogger.notifyDeveloperError("title cannot be null");
            return;
        }
        if (priceAmount == null) {
            AppEventsLogger.notifyDeveloperError("priceAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLogger.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (gtin == null && mpn == null && brand == null) {
            AppEventsLogger.notifyDeveloperError("Either gtin, mpn or brand is required");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_product_item_id", itemID);
        parameters.putString("fb_product_availability", availability.name());
        parameters.putString("fb_product_condition", condition.name());
        parameters.putString("fb_product_description", description);
        parameters.putString("fb_product_image_link", imageLink);
        parameters.putString("fb_product_link", link);
        parameters.putString("fb_product_title", title);
        parameters.putString("fb_product_price_amount", priceAmount.setScale(3, 4).toString());
        parameters.putString("fb_product_price_currency", currency.getCurrencyCode());
        if (gtin != null) {
            parameters.putString("fb_product_gtin", gtin);
        }
        if (mpn != null) {
            parameters.putString("fb_product_mpn", mpn);
        }
        if (brand != null) {
            parameters.putString("fb_product_brand", brand);
        }
        this.logEvent("fb_mobile_catalog_update", parameters);
        AppEventsLogger.eagerFlush();
    }

    public void flush() {
        AppEventQueue.flush(FlushReason.EXPLICIT);
    }

    public static void onContextStop() {
        AppEventQueue.persistToDisk();
    }

    public boolean isValidForAccessToken(AccessToken accessToken) {
        AccessTokenAppIdPair other = new AccessTokenAppIdPair(accessToken);
        return this.accessTokenAppId.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPushNotificationsRegistrationId(String registrationId) {
        Object object = staticLock;
        synchronized (object) {
            if (!Utility.stringsEqualOrEmpty(pushNotificationsRegistrationId, registrationId)) {
                pushNotificationsRegistrationId = registrationId;
                AppEventsLogger logger = AppEventsLogger.newLogger(FacebookSdk.getApplicationContext());
                logger.logEvent("fb_mobile_obtain_push_token");
                if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
                    logger.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPushNotificationsRegistrationId() {
        Object object = staticLock;
        synchronized (object) {
            return pushNotificationsRegistrationId;
        }
    }

    public static void augmentWebView(WebView webView, Context context) {
        int minorRelease;
        String[] parts = Build.VERSION.RELEASE.split("\\.");
        int majorRelease = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
        int n = minorRelease = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        if (Build.VERSION.SDK_INT < 17 || majorRelease < 4 || majorRelease == 4 && minorRelease <= 1) {
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "augmentWebView is only available for Android SDK version >= 17 on devices running Android >= 4.2");
            return;
        }
        webView.addJavascriptInterface((Object)new FacebookSDKJSInterface(context), "fbmq_" + FacebookSdk.getApplicationId());
    }

    public static void setUserID(String userID) {
        AnalyticsUserIDStore.setUserID(userID);
    }

    public static String getUserID() {
        return AnalyticsUserIDStore.getUserID();
    }

    public static void clearUserID() {
        AnalyticsUserIDStore.setUserID(null);
    }

    public static void setUserData(Bundle userData) {
        UserDataStore.setUserDataAndHash(userData);
    }

    public static String getUserData() {
        return UserDataStore.getHashedUserData();
    }

    public static void clearUserData() {
        UserDataStore.setUserDataAndHash(null);
    }

    public static void updateUserProperties(Bundle parameters, GraphRequest.Callback callback) {
        AppEventsLogger.updateUserProperties(parameters, FacebookSdk.getApplicationId(), callback);
    }

    public static void updateUserProperties(final Bundle parameters, final String applicationID, final GraphRequest.Callback callback) {
        AppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String userID = AppEventsLogger.getUserID();
                if (userID == null || userID.isEmpty()) {
                    Logger.log(LoggingBehavior.APP_EVENTS, TAG, "AppEventsLogger userID cannot be null or empty");
                    return;
                }
                Bundle userPropertiesParams = new Bundle();
                userPropertiesParams.putString("user_unique_id", userID);
                userPropertiesParams.putBundle("custom_data", parameters);
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(FacebookSdk.getApplicationContext());
                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                    userPropertiesParams.putString("advertiser_id", identifiers.getAndroidAdvertiserId());
                }
                Bundle data = new Bundle();
                try {
                    JSONObject userData = BundleJSONConverter.convertToJSON(userPropertiesParams);
                    JSONArray dataArray = new JSONArray();
                    dataArray.put((Object)userData);
                    data.putString("data", dataArray.toString());
                }
                catch (JSONException ex) {
                    throw new FacebookException("Failed to construct request", ex);
                }
                GraphRequest request = new GraphRequest(AccessToken.getCurrentAccessToken(), String.format(Locale.US, "%s/user_properties", applicationID), data, HttpMethod.POST, callback);
                request.setSkipClientToken(true);
                request.executeAsync();
            }
        });
    }

    public void logSdkEvent(String eventName, Double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    public String getApplicationId() {
        return this.accessTokenAppId.getApplicationId();
    }

    private AppEventsLogger(Context context, String applicationId, AccessToken accessToken) {
        this(Utility.getActivityName(context), applicationId, accessToken);
    }

    protected AppEventsLogger(String activityName, String applicationId, AccessToken accessToken) {
        Validate.sdkInitialized();
        this.contextName = activityName;
        if (accessToken == null) {
            accessToken = AccessToken.getCurrentAccessToken();
        }
        if (AccessToken.isCurrentAccessTokenActive() && (applicationId == null || applicationId.equals(accessToken.getApplicationId()))) {
            this.accessTokenAppId = new AccessTokenAppIdPair(accessToken);
        } else {
            if (applicationId == null) {
                applicationId = Utility.getMetadataApplicationId(FacebookSdk.getApplicationContext());
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, applicationId);
        }
        AppEventsLogger.initializeTimersIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeTimersIfNeeded() {
        Object object = staticLock;
        synchronized (object) {
            if (backgroundExecutor != null) {
                return;
            }
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        Runnable attributionRecheckRunnable = new Runnable(){

            @Override
            public void run() {
                HashSet<String> applicationIds = new HashSet<String>();
                for (AccessTokenAppIdPair accessTokenAppId : AppEventQueue.getKeySet()) {
                    applicationIds.add(accessTokenAppId.getApplicationId());
                }
                for (String applicationId : applicationIds) {
                    FetchedAppSettingsManager.queryAppSettings(applicationId, true);
                }
            }
        };
        backgroundExecutor.scheduleAtFixedRate(attributionRecheckRunnable, 0L, 86400L, TimeUnit.SECONDS);
    }

    protected void logEventImplicitly(String eventName, BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        this.logEvent(eventName, purchaseAmount.doubleValue(), parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    private void logEvent(String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged, @Nullable UUID currentSessionId) {
        try {
            AppEvent event = new AppEvent(this.contextName, eventName, valueToSum, parameters, isImplicitlyLogged, currentSessionId);
            AppEventsLogger.logEvent(event, this.accessTokenAppId);
        }
        catch (JSONException jsonException) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", jsonException.toString());
        }
        catch (FacebookException e) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event: %s", e.toString());
        }
    }

    private static void logEvent(AppEvent event, AccessTokenAppIdPair accessTokenAppId) {
        AppEventQueue.add(accessTokenAppId, event);
        if (!event.getIsImplicit() && !isActivateAppEventRequested) {
            if (event.getName().equals("fb_mobile_activate_app")) {
                isActivateAppEventRequested = true;
            } else {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Warning: Please call AppEventsLogger.activateApp(...)from the long-lived activity's onResume() methodbefore logging other app events.");
            }
        }
    }

    static void eagerFlush() {
        if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
            AppEventQueue.flush(FlushReason.EAGER_FLUSHING_EVENT);
        }
    }

    private static void notifyDeveloperError(String message) {
        Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", message);
    }

    private static void setSourceApplication(Activity activity) {
        String appLinkReferrerPackage;
        Intent openIntent;
        ComponentName callingApplication = activity.getCallingActivity();
        if (callingApplication != null) {
            String callingApplicationPackage = callingApplication.getPackageName();
            if (callingApplicationPackage.equals(activity.getPackageName())) {
                AppEventsLogger.resetSourceApplication();
                return;
            }
            sourceApplication = callingApplicationPackage;
        }
        if ((openIntent = activity.getIntent()) == null || openIntent.getBooleanExtra(SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, false)) {
            AppEventsLogger.resetSourceApplication();
            return;
        }
        Bundle appLinkData = AppLinks.getAppLinkData((Intent)openIntent);
        if (appLinkData == null) {
            AppEventsLogger.resetSourceApplication();
            return;
        }
        isOpenedByAppLink = true;
        Bundle appLinkReferrerData = appLinkData.getBundle("referer_app_link");
        if (appLinkReferrerData == null) {
            sourceApplication = null;
            return;
        }
        sourceApplication = appLinkReferrerPackage = appLinkReferrerData.getString("package");
        openIntent.putExtra(SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, true);
    }

    static void setSourceApplication(String applicationPackage, boolean openByAppLink) {
        sourceApplication = applicationPackage;
        isOpenedByAppLink = openByAppLink;
    }

    static String getSourceApplication() {
        String openType = "Unclassified";
        if (isOpenedByAppLink) {
            openType = "Applink";
        }
        if (sourceApplication != null) {
            return openType + "(" + sourceApplication + ")";
        }
        return openType;
    }

    static void resetSourceApplication() {
        sourceApplication = null;
        isOpenedByAppLink = false;
    }

    static Executor getAnalyticsExecutor() {
        if (backgroundExecutor == null) {
            AppEventsLogger.initializeTimersIfNeeded();
        }
        return backgroundExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAnonymousAppDeviceGUID(Context context) {
        if (anonymousAppDeviceGUID == null) {
            Object object = staticLock;
            synchronized (object) {
                SharedPreferences preferences;
                if (anonymousAppDeviceGUID == null && (anonymousAppDeviceGUID = (preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0)).getString("anonymousAppDeviceGUID", null)) == null) {
                    anonymousAppDeviceGUID = "XZ" + UUID.randomUUID().toString();
                    context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit().putString("anonymousAppDeviceGUID", anonymousAppDeviceGUID).apply();
                }
            }
        }
        return anonymousAppDeviceGUID;
    }

    static {
        flushBehavior = FlushBehavior.AUTO;
        staticLock = new Object();
    }

    static class PersistedAppSessionInfo {
        private static final String PERSISTED_SESSION_INFO_FILENAME = "AppEventsLogger.persistedsessioninfo";
        private static final Object staticLock = new Object();
        private static boolean hasChanges = false;
        private static boolean isLoaded = false;
        private static Map<AccessTokenAppIdPair, FacebookTimeSpentData> appSessionInfoMap;
        private static final Runnable appSessionInfoFlushRunnable;

        PersistedAppSessionInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void restoreAppSessionInformation(Context context) {
            ObjectInputStream ois = null;
            Object object = staticLock;
            synchronized (object) {
                if (!isLoaded) {
                    try {
                        ois = new ObjectInputStream(context.openFileInput(PERSISTED_SESSION_INFO_FILENAME));
                        appSessionInfoMap = (HashMap)ois.readObject();
                        Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "App session info loaded");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Utility.closeQuietly(ois);
                        context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                        if (appSessionInfoMap == null) {
                            appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                        }
                        isLoaded = true;
                        hasChanges = false;
                    }
                    catch (Exception e) {
                        try {
                            Log.w((String)TAG, (String)("Got unexpected exception restoring app session info: " + e.toString()));
                        }
                        catch (Throwable throwable) {
                            Utility.closeQuietly(ois);
                            context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                            if (appSessionInfoMap == null) {
                                appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                            }
                            isLoaded = true;
                            hasChanges = false;
                            throw throwable;
                        }
                        Utility.closeQuietly(ois);
                        context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                        if (appSessionInfoMap == null) {
                            appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                        }
                        isLoaded = true;
                        hasChanges = false;
                    }
                    Utility.closeQuietly(ois);
                    context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                    if (appSessionInfoMap == null) {
                        appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                    }
                    isLoaded = true;
                    hasChanges = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void saveAppSessionInformation(Context context) {
            ObjectOutputStream oos = null;
            Object object = staticLock;
            synchronized (object) {
                if (hasChanges) {
                    try {
                        oos = new ObjectOutputStream(new BufferedOutputStream(context.openFileOutput(PERSISTED_SESSION_INFO_FILENAME, 0)));
                        oos.writeObject(appSessionInfoMap);
                        hasChanges = false;
                        Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "App session info saved");
                    }
                    catch (Exception e) {
                        try {
                            Log.w((String)TAG, (String)("Got unexpected exception while writing app session info: " + e.toString()));
                        }
                        catch (Throwable throwable) {
                            Utility.closeQuietly(oos);
                            throw throwable;
                        }
                        Utility.closeQuietly(oos);
                    }
                    Utility.closeQuietly(oos);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void onResume(Context context, AccessTokenAppIdPair accessTokenAppId, AppEventsLogger logger, long eventTime, String sourceApplicationInfo) {
            Object object = staticLock;
            synchronized (object) {
                FacebookTimeSpentData timeSpentData = PersistedAppSessionInfo.getTimeSpentData(context, accessTokenAppId);
                timeSpentData.onResume(logger, eventTime, sourceApplicationInfo);
                PersistedAppSessionInfo.onTimeSpentDataUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void onSuspend(Context context, AccessTokenAppIdPair accessTokenAppId, AppEventsLogger logger, long eventTime) {
            Object object = staticLock;
            synchronized (object) {
                FacebookTimeSpentData timeSpentData = PersistedAppSessionInfo.getTimeSpentData(context, accessTokenAppId);
                timeSpentData.onSuspend(logger, eventTime);
                PersistedAppSessionInfo.onTimeSpentDataUpdate();
            }
        }

        private static FacebookTimeSpentData getTimeSpentData(Context context, AccessTokenAppIdPair accessTokenAppId) {
            PersistedAppSessionInfo.restoreAppSessionInformation(context);
            FacebookTimeSpentData result = null;
            result = appSessionInfoMap.get(accessTokenAppId);
            if (result == null) {
                result = new FacebookTimeSpentData();
                appSessionInfoMap.put(accessTokenAppId, result);
            }
            return result;
        }

        private static void onTimeSpentDataUpdate() {
            if (!hasChanges) {
                hasChanges = true;
                backgroundExecutor.schedule(appSessionInfoFlushRunnable, 30L, TimeUnit.SECONDS);
            }
        }

        static {
            appSessionInfoFlushRunnable = new Runnable(){

                @Override
                public void run() {
                    PersistedAppSessionInfo.saveAppSessionInformation(FacebookSdk.getApplicationContext());
                }
            };
        }
    }

    public static enum ProductCondition {
        NEW,
        REFURBISHED,
        USED;

    }

    public static enum ProductAvailability {
        IN_STOCK,
        OUT_OF_STOCK,
        PREORDER,
        AVALIABLE_FOR_ORDER,
        DISCONTINUED;

    }

    public static enum FlushBehavior {
        AUTO,
        EXPLICIT_ONLY;

    }
}

