/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.internal.AppEventUtility;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONException;
import org.json.JSONObject;

public class UserDataStore {
    private static final String TAG = UserDataStore.class.getSimpleName();
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static String hashedUserData;
    private static volatile boolean initialized;
    public static final String EMAIL = "em";
    public static final String FIRST_NAME = "fn";
    public static final String LAST_NAME = "ln";
    public static final String PHONE = "ph";
    public static final String DATE_OF_BIRTH = "db";
    public static final String GENDER = "ge";
    public static final String CITY = "ct";
    public static final String STATE = "st";
    public static final String ZIP = "zp";
    public static final String COUNTRY = "country";

    public static void initStore() {
        if (initialized) {
            return;
        }
        AppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                UserDataStore.initAndWait();
            }
        });
    }

    public static void setUserDataAndHash(final Bundle ud) {
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
            UserDataStore.initAndWait();
        }
        AppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                lock.writeLock().lock();
                try {
                    hashedUserData = UserDataStore.hashUserData(ud);
                    SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString(UserDataStore.USER_DATA_KEY, hashedUserData);
                    editor.apply();
                }
                finally {
                    lock.writeLock().unlock();
                }
            }
        });
    }

    public static String getHashedUserData() {
        if (!initialized) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            UserDataStore.initAndWait();
        }
        lock.readLock().lock();
        try {
            String string = hashedUserData;
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static void initAndWait() {
        if (initialized) {
            return;
        }
        lock.writeLock().lock();
        try {
            if (initialized) {
                return;
            }
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            hashedUserData = sharedPreferences.getString(USER_DATA_KEY, null);
            initialized = true;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static String hashUserData(Bundle ud) {
        if (ud == null) {
            return null;
        }
        JSONObject hashedUserData = new JSONObject();
        for (String key : ud.keySet()) {
            try {
                String value = ud.get(key).toString();
                if (UserDataStore.maybeSHA256Hashed(value)) {
                    hashedUserData.put(key, (Object)value.toLowerCase());
                    continue;
                }
                String normalizedValue = UserDataStore.normalizeData(key, ud.get(key).toString());
                String encryptedValue = UserDataStore.encryptData(normalizedValue);
                if (encryptedValue == null) continue;
                hashedUserData.put(key, (Object)encryptedValue);
            }
            catch (JSONException jSONException) {}
        }
        return hashedUserData.toString();
    }

    private static String encryptData(String data) {
        MessageDigest md;
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(data.getBytes());
        return AppEventUtility.bytesToHex(md.digest());
    }

    private static String normalizeData(String type, String data) {
        String normalizedData = "";
        switch (type) {
            case "em": 
            case "fn": 
            case "ln": 
            case "ct": 
            case "st": 
            case "country": {
                normalizedData = data.trim().toLowerCase();
                break;
            }
            case "ph": {
                normalizedData = data.trim().replaceAll("[^0-9]", "");
                break;
            }
            case "ge": {
                String temp = data.trim().toLowerCase();
                normalizedData = temp.length() > 0 ? temp.substring(0, 1) : "";
                break;
            }
        }
        return normalizedData;
    }

    private static boolean maybeSHA256Hashed(String data) {
        return data.matches("[A-Fa-f0-9]{64}");
    }

    static {
        initialized = false;
    }
}

