/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.SubscriptionType;
import com.facebook.internal.Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppPurchaseEventManager {
    private static final String TAG = InAppPurchaseEventManager.class.getCanonicalName();
    private static final HashMap<String, Method> methodMap = new HashMap();
    private static final HashMap<String, Class<?>> classMap = new HashMap();
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int SKU_DETAIL_EXPIRE_TIME_SEC = 43200;
    private static final String SUBSCRIPTION = "subs";
    private static final String INAPP = "inapp";
    private static final int PURCHASE_EXPIRE_TIME_SEC = 43200;
    private static final int PURCHASE_STOP_QUERY_TIME_SEC = 1200;
    private static final int MAX_QUERY_PURCHASE_NUM = 30;
    private static final String IN_APP_BILLING_SERVICE_STUB = "com.android.vending.billing.IInAppBillingService$Stub";
    private static final String IN_APP_BILLING_SERVICE = "com.android.vending.billing.IInAppBillingService";
    private static final String AS_INTERFACE = "asInterface";
    private static final String GET_SKU_DETAILS = "getSkuDetails";
    private static final String GET_PURCHASES = "getPurchases";
    private static final String GET_PURCHASE_HISTORY = "getPurchaseHistory";
    private static final String IS_BILLING_SUPPORTED = "isBillingSupported";
    private static final String ITEM_ID_LIST = "ITEM_ID_LIST";
    private static final String RESPONSE_CODE = "RESPONSE_CODE";
    private static final String DETAILS_LIST = "DETAILS_LIST";
    private static final String INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    private static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    private static final String PACKAGE_NAME = FacebookSdk.getApplicationContext().getPackageName();
    private static final String LAST_LOGGED_TIME_SEC = "LAST_LOGGED_TIME_SEC";
    private static final long SUBSCRIPTION_HARTBEAT_INTERVAL = 86400L;
    private static final String SKU_DETAILS_STORE = "com.facebook.internal.SKU_DETAILS";
    private static final String PURCHASE_INAPP_STORE = "com.facebook.internal.PURCHASE";
    private static final String PURCHASE_SUBS_STORE = "com.facebook.internal.PURCHASE_SUBS";
    private static final SharedPreferences skuDetailSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.SKU_DETAILS", 0);
    private static final SharedPreferences purchaseInappSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE", 0);
    private static final SharedPreferences purchaseSubsSharedPrefs = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.internal.PURCHASE_SUBS", 0);

    @Nullable
    public static Object asInterface(Context context, IBinder service) {
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE_STUB);
        if (iapClass == null) {
            return null;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, AS_INTERFACE);
        if (method == null) {
            return null;
        }
        Object[] args = new Object[]{service};
        Utility.logd(TAG, "In-app billing service connected");
        return InAppPurchaseEventManager.invokeMethod(iapClass, method, null, args);
    }

    public static Map<String, String> getSkuDetails(Context context, ArrayList<String> skuList, Object inAppBillingObj, boolean isSubscription) {
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.readSkuDetailsFromCache(skuList);
        ArrayList<String> unresolvedSkuList = new ArrayList<String>();
        for (String sku : skuList) {
            if (skuDetailsMap.containsKey(sku)) continue;
            unresolvedSkuList.add(sku);
        }
        skuDetailsMap.putAll(InAppPurchaseEventManager.getSkuDetailsFromGoogle(context, unresolvedSkuList, inAppBillingObj, isSubscription));
        return skuDetailsMap;
    }

    private static Map<String, String> getSkuDetailsFromGoogle(Context context, ArrayList<String> skuList, Object inAppBillingObj, boolean isSubscription) {
        Bundle bundle;
        int response;
        HashMap<String, String> skuDetailsMap = new HashMap<String, String>();
        if (inAppBillingObj == null || skuList.isEmpty()) {
            return skuDetailsMap;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return skuDetailsMap;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_SKU_DETAILS);
        if (method == null) {
            return skuDetailsMap;
        }
        Bundle querySkus = new Bundle();
        querySkus.putStringArrayList(ITEM_ID_LIST, skuList);
        Object localObj = iapClass.cast(inAppBillingObj);
        Object[] args = new Object[]{3, PACKAGE_NAME, isSubscription ? SUBSCRIPTION : INAPP, querySkus};
        Object result = InAppPurchaseEventManager.invokeMethod(iapClass, method, localObj, args);
        if (result != null && (response = (bundle = (Bundle)result).getInt(RESPONSE_CODE)) == 0) {
            ArrayList skuDetailsList = bundle.getStringArrayList(DETAILS_LIST);
            if (skuDetailsList != null && skuList.size() == skuDetailsList.size()) {
                for (int i = 0; i < skuList.size(); ++i) {
                    skuDetailsMap.put(skuList.get(i), (String)skuDetailsList.get(i));
                }
            }
            InAppPurchaseEventManager.writeSkuDetailsToCache(skuDetailsMap);
        }
        return skuDetailsMap;
    }

    private static Map<String, String> readSkuDetailsFromCache(ArrayList<String> skuList) {
        HashMap<String, String> skuDetailsMap = new HashMap<String, String>();
        long nowSec = System.currentTimeMillis() / 1000L;
        for (String sku : skuList) {
            String[] splitted;
            long timeSec;
            String rawString = skuDetailSharedPrefs.getString(sku, null);
            if (rawString == null || nowSec - (timeSec = Long.parseLong((splitted = rawString.split(";", 2))[0])) >= 43200L) continue;
            skuDetailsMap.put(sku, splitted[1]);
        }
        return skuDetailsMap;
    }

    private static void writeSkuDetailsToCache(Map<String, String> skuDetailsMap) {
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences.Editor editor = skuDetailSharedPrefs.edit();
        for (String sku : skuDetailsMap.keySet()) {
            String skuDetail = skuDetailsMap.get(sku);
            editor.putString(sku, nowSec + ";" + skuDetail);
        }
        editor.apply();
    }

    public static Boolean isBillingSupported(Context context, Object inAppBillingObj, String type) {
        Object[] args;
        if (inAppBillingObj == null) {
            return false;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return false;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, IS_BILLING_SUPPORTED);
        if (method == null) {
            return false;
        }
        Object localObj = iapClass.cast(inAppBillingObj);
        Object result = InAppPurchaseEventManager.invokeMethod(iapClass, method, localObj, args = new Object[]{3, PACKAGE_NAME, type});
        return result == null ? false : (Integer)result == 0;
    }

    public static ArrayList<String> getPurchasesInapp(Context context, Object inAppBillingObj) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (inAppBillingObj == null) {
            return purchases;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return purchases;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_PURCHASES);
        if (method == null) {
            return purchases;
        }
        purchases = InAppPurchaseEventManager.getPurchases(context, inAppBillingObj, iapClass, method, INAPP);
        return InAppPurchaseEventManager.filterPurchasesInapp(purchases);
    }

    public static ArrayList<String> getPurchasesSubsExpire(Context context, Object inAppBillingObj) {
        ArrayList<String> expirePurchases = new ArrayList<String>();
        if (inAppBillingObj == null) {
            return expirePurchases;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return expirePurchases;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_PURCHASES);
        if (method == null) {
            return expirePurchases;
        }
        Map keys = purchaseSubsSharedPrefs.getAll();
        if (keys.isEmpty()) {
            return expirePurchases;
        }
        ArrayList<String> currPurchases = InAppPurchaseEventManager.getPurchases(context, inAppBillingObj, iapClass, method, SUBSCRIPTION);
        HashSet<String> currSkuSet = new HashSet<String>();
        for (String string : currPurchases) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                currSkuSet.add(jSONObject.getString("productId"));
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Error parsing purchase json", (Throwable)jSONException);
            }
        }
        HashSet<String> expireSkuSet = new HashSet<String>();
        for (Map.Entry entry : keys.entrySet()) {
            String sku = (String)entry.getKey();
            if (currSkuSet.contains(sku)) continue;
            expireSkuSet.add(sku);
        }
        SharedPreferences.Editor editor = purchaseSubsSharedPrefs.edit();
        for (String expireSku : expireSkuSet) {
            String expirePurchase = purchaseSubsSharedPrefs.getString(expireSku, "");
            editor.remove(expireSku);
            if (expirePurchase.isEmpty()) continue;
            expirePurchases.add(purchaseSubsSharedPrefs.getString(expireSku, ""));
        }
        editor.apply();
        return expirePurchases;
    }

    public static Map<String, SubscriptionType> getPurchasesSubs(Context context, Object inAppBillingObj) {
        HashMap<String, SubscriptionType> purchaseMap = new HashMap<String, SubscriptionType>();
        if (inAppBillingObj == null) {
            return purchaseMap;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return purchaseMap;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_PURCHASES);
        if (method == null) {
            return purchaseMap;
        }
        ArrayList<String> purchases = InAppPurchaseEventManager.getPurchases(context, inAppBillingObj, iapClass, method, SUBSCRIPTION);
        for (String purchase : purchases) {
            SubscriptionType subsType = InAppPurchaseEventManager.getSubsType(purchase);
            if (subsType == SubscriptionType.DUPLICATED || subsType == SubscriptionType.UNKNOWN) continue;
            purchaseMap.put(purchase, subsType);
        }
        return purchaseMap;
    }

    private static SubscriptionType getSubsType(String purchase) {
        try {
            JSONObject oldPurchaseJson;
            SubscriptionType subsType = null;
            long nowSec = System.currentTimeMillis() / 1000L;
            JSONObject purchaseJson = new JSONObject(purchase);
            String sku = purchaseJson.getString("productId");
            String oldPurchase = purchaseSubsSharedPrefs.getString(sku, "");
            JSONObject jSONObject = oldPurchaseJson = oldPurchase.isEmpty() ? new JSONObject() : new JSONObject(oldPurchase);
            if (!oldPurchaseJson.optString("purchaseToken").equals(purchaseJson.get("purchaseToken"))) {
                long purchaseTimeMillis = purchaseJson.getLong("purchaseTime");
                SubscriptionType subscriptionType = subsType = nowSec - purchaseTimeMillis / 1000L < 43200L ? SubscriptionType.NEW : SubscriptionType.HEARTBEAT;
            }
            if (subsType == null && !oldPurchase.isEmpty()) {
                boolean oldAutoRenewing = oldPurchaseJson.getBoolean("autoRenewing");
                boolean newAutoRenewing = purchaseJson.getBoolean("autoRenewing");
                if (!newAutoRenewing && oldAutoRenewing) {
                    subsType = SubscriptionType.CANCEL;
                } else if (!oldAutoRenewing && newAutoRenewing) {
                    subsType = SubscriptionType.RESTORE;
                }
            }
            if (subsType == null && !oldPurchase.isEmpty()) {
                long lastLoggedTimeSec = oldPurchaseJson.getLong(LAST_LOGGED_TIME_SEC);
                subsType = nowSec - lastLoggedTimeSec > 86400L ? SubscriptionType.HEARTBEAT : SubscriptionType.DUPLICATED;
            }
            if (subsType != SubscriptionType.DUPLICATED) {
                purchaseJson.put(LAST_LOGGED_TIME_SEC, nowSec);
                purchaseSubsSharedPrefs.edit().putString(sku, purchaseJson.toString()).apply();
            }
            return subsType;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"parsing purchase failure: ", (Throwable)e);
            return SubscriptionType.UNKNOWN;
        }
    }

    private static ArrayList<String> getPurchases(Context context, Object inAppBillingObj, Class<?> iapClass, Method method, String type) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (InAppPurchaseEventManager.isBillingSupported(context, inAppBillingObj, type).booleanValue()) {
            String continuationToken = null;
            int queriedPurchaseNum = 0;
            do {
                Bundle purchaseDetails;
                int response;
                Object localObj = iapClass.cast(inAppBillingObj);
                Object[] args = new Object[]{3, PACKAGE_NAME, type, continuationToken};
                Object result = InAppPurchaseEventManager.invokeMethod(iapClass, method, localObj, args);
                continuationToken = null;
                if (result == null || (response = (purchaseDetails = (Bundle)result).getInt(RESPONSE_CODE)) != 0) continue;
                ArrayList details = purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST);
                if (details == null) break;
                queriedPurchaseNum += details.size();
                purchases.addAll(details);
                continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
            } while (queriedPurchaseNum < 30 && continuationToken != null);
        }
        return purchases;
    }

    public static ArrayList<String> getPurchaseHistoryInapp(Context context, Object inAppBillingObj) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (inAppBillingObj == null) {
            return purchases;
        }
        Class<?> iapClass = InAppPurchaseEventManager.getClass(context, IN_APP_BILLING_SERVICE);
        if (iapClass == null) {
            return purchases;
        }
        Method method = InAppPurchaseEventManager.getMethod(iapClass, GET_PURCHASE_HISTORY);
        if (method == null) {
            return purchases;
        }
        purchases = InAppPurchaseEventManager.getPurchaseHistory(context, inAppBillingObj, iapClass, method, INAPP);
        return InAppPurchaseEventManager.filterPurchasesInapp(purchases);
    }

    private static ArrayList<String> getPurchaseHistory(Context context, Object inAppBillingObj, Class<?> iapClass, Method method, String type) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (InAppPurchaseEventManager.isBillingSupported(context, inAppBillingObj, type).booleanValue()) {
            String continuationToken = null;
            int queriedPurchaseNum = 0;
            Boolean reachTimeLimit = false;
            do {
                Object localObj = iapClass.cast(inAppBillingObj);
                Object[] args = new Object[]{6, PACKAGE_NAME, type, continuationToken, new Bundle()};
                continuationToken = null;
                Object result = InAppPurchaseEventManager.invokeMethod(iapClass, method, localObj, args);
                if (result == null) continue;
                long nowSec = System.currentTimeMillis() / 1000L;
                Bundle purchaseDetails = (Bundle)result;
                int response = purchaseDetails.getInt(RESPONSE_CODE);
                if (response != 0) continue;
                ArrayList details = purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST);
                for (String detail : details) {
                    try {
                        JSONObject detailJSON = new JSONObject(detail);
                        long purchaseTimeSec = detailJSON.getLong("purchaseTime") / 1000L;
                        if (nowSec - purchaseTimeSec > 1200L) {
                            reachTimeLimit = true;
                            break;
                        }
                        purchases.add(detail);
                        ++queriedPurchaseNum;
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"parsing purchase failure: ", (Throwable)e);
                    }
                }
                continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
            } while (queriedPurchaseNum < 30 && continuationToken != null && !reachTimeLimit.booleanValue());
        }
        return purchases;
    }

    private static ArrayList<String> filterPurchasesInapp(ArrayList<String> purchases) {
        ArrayList<String> filteredPurchase = new ArrayList<String>();
        SharedPreferences.Editor editor = purchaseInappSharedPrefs.edit();
        long nowSec = System.currentTimeMillis() / 1000L;
        for (String purchase : purchases) {
            try {
                String historyPurchaseToken;
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                long purchaseTimeMillis = purchaseJson.getLong("purchaseTime");
                String purchaseToken = purchaseJson.getString("purchaseToken");
                if (nowSec - purchaseTimeMillis / 1000L > 43200L || (historyPurchaseToken = purchaseInappSharedPrefs.getString(sku, "")).equals(purchaseToken)) continue;
                editor.putString(sku, purchaseToken);
                filteredPurchase.add(purchase);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"parsing purchase failure: ", (Throwable)e);
            }
        }
        editor.apply();
        return filteredPurchase;
    }

    @Nullable
    private static Method getMethod(Class<?> classObj, String methodName) {
        Method method = methodMap.get(methodName);
        if (method != null) {
            return method;
        }
        try {
            Class[] paramTypes = null;
            switch (methodName) {
                case "asInterface": {
                    paramTypes = new Class[]{IBinder.class};
                    break;
                }
                case "getSkuDetails": {
                    paramTypes = new Class[]{Integer.TYPE, String.class, String.class, Bundle.class};
                    break;
                }
                case "isBillingSupported": {
                    paramTypes = new Class[]{Integer.TYPE, String.class, String.class};
                    break;
                }
                case "getPurchases": {
                    paramTypes = new Class[]{Integer.TYPE, String.class, String.class, String.class};
                    break;
                }
                case "getPurchaseHistory": {
                    paramTypes = new Class[]{Integer.TYPE, String.class, String.class, String.class, Bundle.class};
                }
            }
            method = classObj.getDeclaredMethod(methodName, paramTypes);
            methodMap.put(methodName, method);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)(classObj.getName() + "." + methodName + " method not found"), (Throwable)e);
        }
        return method;
    }

    @Nullable
    private static Class<?> getClass(Context context, String className) {
        Class<?> classObj = classMap.get(className);
        if (classObj != null) {
            return classObj;
        }
        try {
            classObj = context.getClassLoader().loadClass(className);
            classMap.put(className, classObj);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)(className + " is not available, please add " + className + " to the project."), (Throwable)e);
        }
        return classObj;
    }

    @Nullable
    private static Object invokeMethod(Class classObj, Method methodObj, Object obj, Object[] args) {
        try {
            return methodObj.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Illegal access to method " + classObj.getName() + "." + methodObj.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)("Invocation target exception in " + classObj.getName() + "." + methodObj.getName()), (Throwable)e);
        }
        return null;
    }

    public static void clearSkuDetailsCache() {
        long nowSec = System.currentTimeMillis() / 1000L;
        long lastClearedTimeSec = skuDetailSharedPrefs.getLong(LAST_CLEARED_TIME, 0L);
        if (lastClearedTimeSec == 0L) {
            skuDetailSharedPrefs.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
        } else if (nowSec - lastClearedTimeSec > 604800L) {
            skuDetailSharedPrefs.edit().clear().putLong(LAST_CLEARED_TIME, nowSec).apply();
        }
    }
}

