/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import java.lang.ref.WeakReference;

class CodelessLoggingEventListener {
    private static final String TAG = CodelessLoggingEventListener.class.getCanonicalName();

    CodelessLoggingEventListener() {
    }

    public static AutoLoggingAccessibilityDelegate getAccessibilityDelegate(EventBinding mapping, View rootView, View hostView) {
        return new AutoLoggingAccessibilityDelegate(mapping, rootView, hostView);
    }

    public static class AutoLoggingAccessibilityDelegate
    extends View.AccessibilityDelegate {
        private EventBinding mapping;
        private WeakReference<View> hostView;
        private WeakReference<View> rootView;
        private int accessibilityEventType;
        private View.AccessibilityDelegate existingDelegate;

        public AutoLoggingAccessibilityDelegate(EventBinding mapping, View rootView, View hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingDelegate = ViewHierarchy.getExistingDelegate(hostView);
            this.mapping = mapping;
            this.hostView = new WeakReference<View>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            EventBinding.ActionType type = mapping.getType();
            switch (mapping.getType()) {
                case CLICK: {
                    this.accessibilityEventType = 1;
                    break;
                }
                case SELECTED: {
                    this.accessibilityEventType = 4;
                    break;
                }
                case TEXT_CHANGED: {
                    this.accessibilityEventType = 16;
                    break;
                }
                default: {
                    throw new FacebookException("Unsupported action type: " + type.toString());
                }
            }
        }

        public void sendAccessibilityEvent(View host, int eventType) {
            if (eventType == -1) {
                Log.e((String)TAG, (String)"Unsupported action type");
            }
            if (eventType != this.accessibilityEventType) {
                return;
            }
            if (null != this.existingDelegate && !(this.existingDelegate instanceof AutoLoggingAccessibilityDelegate)) {
                this.existingDelegate.sendAccessibilityEvent(host, eventType);
            }
            this.logEvent();
        }

        private void logEvent() {
            final String eventName = this.mapping.getEventName();
            Bundle parameters = CodelessMatcher.getParameters(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
            if (parameters.containsKey("_valueToSum")) {
                String value = parameters.getString("_valueToSum");
                parameters.putDouble("_valueToSum", AppEventUtility.normalizePrice(value));
            }
            parameters.putString("_is_fb_codeless", "1");
            final Bundle params = parameters;
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Context context = FacebookSdk.getApplicationContext();
                    AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
                    appEventsLogger.logEvent(eventName, params);
                }
            });
        }
    }
}

