/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Intent;
import android.util.Log;
import com.facebook.CallbackManager;
import com.facebook.FacebookSdk;
import com.facebook.internal.Validate;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class CallbackManagerImpl
implements CallbackManager {
    private static final String TAG = CallbackManagerImpl.class.getSimpleName();
    private static final String INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    private static Map<Integer, Callback> staticCallbacks = new HashMap<Integer, Callback>();
    private Map<Integer, Callback> callbacks = new HashMap<Integer, Callback>();

    public static synchronized void registerStaticCallback(int requestCode, Callback callback) {
        Validate.notNull(callback, "callback");
        if (staticCallbacks.containsKey(requestCode)) {
            return;
        }
        staticCallbacks.put(requestCode, callback);
    }

    private static synchronized Callback getStaticCallback(Integer requestCode) {
        return staticCallbacks.get(requestCode);
    }

    private static boolean runStaticCallback(int requestCode, int resultCode, Intent data) {
        Callback callback = CallbackManagerImpl.getStaticCallback(requestCode);
        if (callback != null) {
            return callback.onActivityResult(resultCode, data);
        }
        return false;
    }

    public void registerCallback(int requestCode, Callback callback) {
        Validate.notNull(callback, "callback");
        this.callbacks.put(requestCode, callback);
    }

    public void unregisterCallback(int requestCode) {
        this.callbacks.remove(requestCode);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        Callback callback;
        if (CallbackManagerImpl.isPurchaseIntent(data)) {
            requestCode = RequestCodeOffset.InAppPurchase.toRequestCode();
        }
        if ((callback = this.callbacks.get(requestCode)) != null) {
            return callback.onActivityResult(resultCode, data);
        }
        return CallbackManagerImpl.runStaticCallback(requestCode, resultCode, data);
    }

    private static boolean isPurchaseIntent(Intent data) {
        String purchaseData;
        if (data == null || (purchaseData = data.getStringExtra(INAPP_PURCHASE_DATA)) == null) {
            return false;
        }
        try {
            JSONObject jo = new JSONObject(purchaseData);
            return jo.has("orderId") && jo.has("packageName") && jo.has("productId") && jo.has("purchaseTime") && jo.has("purchaseState") && jo.has("developerPayload") && jo.has("purchaseToken");
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error parsing intent data.", (Throwable)e);
            return false;
        }
    }

    public static enum RequestCodeOffset {
        Login(0),
        Share(1),
        Message(2),
        Like(3),
        GameRequest(4),
        AppGroupCreate(5),
        AppGroupJoin(6),
        AppInvite(7),
        DeviceShare(8),
        InAppPurchase(9);

        private final int offset;

        private RequestCodeOffset(int offset) {
            this.offset = offset;
        }

        public int toRequestCode() {
            return FacebookSdk.getCallbackRequestCodeOffset() + this.offset;
        }
    }

    public static interface Callback {
        public boolean onActivityResult(int var1, Intent var2);
    }
}

