/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.facebook.internal.Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class InAppPurchaseEventManager {
    private static final HashMap<String, Method> methodMap = new HashMap();
    private static final HashMap<String, Class<?>> classMap = new HashMap();
    private static final String TAG = InAppPurchaseEventManager.class.getCanonicalName();
    private static final String GET_INTERFACE_METHOD = "iap_get_interface";
    private static final String GET_SKU_DETAILS_METHOD = "iap_get_sku_details";
    private static final String IN_APP_BILLING_SERVICE_STUB = "com.android.vending.billing.IInAppBillingService$Stub";
    private static final String IN_APP_BILLING_SERVICE = "com.android.vending.billing.IInAppBillingService";
    private static final String ITEM_ID_LIST = "ITEM_ID_LIST";
    private static final String RESPONSE_CODE = "RESPONSE_CODE";
    private static final String DETAILS_LIST = "DETAILS_LIST";

    public static Object getServiceInterface(Context context, IBinder service) {
        try {
            Method getInterfaceMethod = methodMap.get(GET_INTERFACE_METHOD);
            if (getInterfaceMethod == null) {
                Class<?> iapClass = context.getClassLoader().loadClass(IN_APP_BILLING_SERVICE_STUB);
                Class[] paramTypes = new Class[]{IBinder.class};
                getInterfaceMethod = iapClass.getDeclaredMethod("asInterface", paramTypes);
                methodMap.put(GET_INTERFACE_METHOD, getInterfaceMethod);
            }
            Object[] args = new Object[]{service};
            Utility.logd(TAG, "In-app billing service connected");
            return getInterfaceMethod.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"com.android.vending.billing.IInAppBillingService$Stub is not available, please add com.android.vending.billing.IInAppBillingService to the project.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"com.android.vending.billing.IInAppBillingService$Stub.asInterface method not found", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Illegal access to method com.android.vending.billing.IInAppBillingService$Stub.asInterface", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Invocation target exception in com.android.vending.billing.IInAppBillingService$Stub.asInterface", (Throwable)e);
        }
        return null;
    }

    public static String getPurchaseDetails(Context context, String sku, Object inAppBillingObj) {
        if (inAppBillingObj == null || sku == "") {
            return "";
        }
        try {
            Method getSkuDetailsMethod = methodMap.get(GET_SKU_DETAILS_METHOD);
            Class<?> iapClass = classMap.get(IN_APP_BILLING_SERVICE);
            if (getSkuDetailsMethod == null || iapClass == null) {
                iapClass = context.getClassLoader().loadClass(IN_APP_BILLING_SERVICE);
                Class[] paramTypes = new Class[]{Integer.TYPE, String.class, String.class, Bundle.class};
                getSkuDetailsMethod = iapClass.getDeclaredMethod("getSkuDetails", paramTypes);
                methodMap.put(GET_SKU_DETAILS_METHOD, getSkuDetailsMethod);
                classMap.put(IN_APP_BILLING_SERVICE, iapClass);
            }
            ArrayList<String> skuList = new ArrayList<String>();
            skuList.add(sku);
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(ITEM_ID_LIST, skuList);
            Object localObj = iapClass.cast(inAppBillingObj);
            Object[] args = new Object[]{3, context.getPackageName(), "inapp", querySkus};
            Bundle skuDetails = (Bundle)getSkuDetailsMethod.invoke(localObj, args);
            int response = skuDetails.getInt(RESPONSE_CODE);
            if (response == 0) {
                ArrayList details = skuDetails.getStringArrayList(DETAILS_LIST);
                String detail = details.size() < 1 ? "" : (String)details.get(0);
                return detail;
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"com.android.vending.billing.IInAppBillingService is not available, please add com.android.vending.billing.IInAppBillingService to the project, and import the IInAppBillingService.aidl file into this package", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"com.android.vending.billing.IInAppBillingService.getSkuDetails method is not available", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Invocation target exception in com.android.vending.billing.IInAppBillingService.getSkuDetails", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Illegal access to method com.android.vending.billing.IInAppBillingService.getSkuDetails", (Throwable)e);
        }
        return "";
    }
}

