/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.internal.InAppPurchaseEventManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.math.BigDecimal;
import java.util.Currency;
import org.json.JSONException;
import org.json.JSONObject;

public class AutomaticAnalyticsLogger {
    private static final String TAG = AutomaticAnalyticsLogger.class.getCanonicalName();
    private static final String INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    @Nullable
    private static Object inAppBillingObj;

    public static void logActivateAppEvent() {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        boolean autoLogAppEvents = FacebookSdk.getAutoLogAppEventsEnabled();
        Validate.notNull(context, "context");
        if (autoLogAppEvents) {
            if (context instanceof Application) {
                AppEventsLogger.activateApp((Application)context, appId);
            } else {
                Log.w((String)TAG, (String)"Automatic logging of basic events will not happen, because FacebookSdk.getApplicationContext() returns object that is not instance of android.app.Application. Make sure you call FacebookSdk.sdkInitialize() from Application class and pass application context.");
            }
        }
    }

    public static void logActivityTimeSpentEvent(String activityName, long timeSpentInSeconds) {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        Validate.notNull(context, "context");
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(appId, false);
        if (settings != null && settings.getAutomaticLoggingEnabled() && timeSpentInSeconds > 0L) {
            AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_aa_time_spent_view_name", (CharSequence)activityName);
            appEventsLogger.logEvent("fb_aa_time_spent_on_view", timeSpentInSeconds, params);
        }
    }

    public static boolean logInAppPurchaseEvent(final Context context, int resultCode, Intent data) {
        if (data == null || !AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            return false;
        }
        final String purchaseData = data.getStringExtra(INAPP_PURCHASE_DATA);
        if (resultCode == -1) {
            ServiceConnection serviceConnection = new ServiceConnection(){

                public void onServiceDisconnected(ComponentName name) {
                    inAppBillingObj = null;
                    Utility.logd(TAG, "In-app billing service disconnected");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    inAppBillingObj = InAppPurchaseEventManager.getServiceInterface(context, service);
                    try {
                        JSONObject purchaseDetails = new JSONObject(purchaseData);
                        String sku = purchaseDetails.getString("productId");
                        String skuDetails = InAppPurchaseEventManager.getPurchaseDetails(context, sku, inAppBillingObj);
                        if (skuDetails.equals("")) {
                            return;
                        }
                        JSONObject jsonSkuDetails = new JSONObject(skuDetails);
                        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
                        Bundle params = new Bundle(1);
                        params.putCharSequence("fb_iap_product_id", (CharSequence)sku);
                        params.putCharSequence("fb_iap_purchase_time", (CharSequence)purchaseDetails.getString("purchaseTime"));
                        params.putCharSequence("fb_iap_purchase_state", (CharSequence)purchaseDetails.getString("purchaseState"));
                        params.putCharSequence("fb_iap_purchase_token", (CharSequence)purchaseDetails.getString("purchaseToken"));
                        params.putCharSequence("fb_iap_package_name", (CharSequence)purchaseDetails.getString("packageName"));
                        params.putCharSequence("fb_iap_product_type", (CharSequence)jsonSkuDetails.getString("type"));
                        params.putCharSequence("fb_iap_product_title", (CharSequence)jsonSkuDetails.getString("title"));
                        params.putCharSequence("fb_iap_product_description", (CharSequence)jsonSkuDetails.getString("description"));
                        appEventsLogger.logPurchaseImplicitly(new BigDecimal((double)jsonSkuDetails.getInt("price_amount_micros") / 1000000.0), Currency.getInstance(jsonSkuDetails.getString("price_currency_code")), params);
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
                    }
                    finally {
                        context.unbindService((ServiceConnection)this);
                    }
                }
            };
            Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            serviceIntent.setPackage("com.android.vending");
            context.bindService(serviceIntent, serviceConnection, 1);
        }
        return true;
    }

    public static boolean isImplicitPurchaseLoggingEnabled() {
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(appId, false);
        if (settings == null) {
            return false;
        }
        return FacebookSdk.getAutoLogAppEventsEnabled() && settings.getIAPAutomaticLoggingEnabled();
    }
}

