/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import com.facebook.internal.Utility;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/FacebookSignatureValidator;", "", "()V", "FBF_HASH", "", "FBI_HASH", "FBL_HASH", "FBR2_HASH", "FBR_HASH", "IGR_HASH", "MSR_HASH", "validAppSignatureHashes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "validateSignature", "", "context", "Landroid/content/Context;", "packageName", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nFacebookSignatureValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacebookSignatureValidator.kt\ncom/facebook/internal/FacebookSignatureValidator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n12541#2,2:61\n*S KotlinDebug\n*F\n+ 1 FacebookSignatureValidator.kt\ncom/facebook/internal/FacebookSignatureValidator\n*L\n52#1:61,2\n*E\n"})
public final class FacebookSignatureValidator {
    @NotNull
    public static final FacebookSignatureValidator INSTANCE = new FacebookSignatureValidator();
    @NotNull
    private static final String FBI_HASH = "a4b7452e2ed8f5f191058ca7bbfd26b0d3214bfc";
    @NotNull
    private static final String FBL_HASH = "df6b721c8b4d3b6eb44c861d4415007e5a35fc95";
    @NotNull
    private static final String FBR_HASH = "8a3c4b262d721acd49a4bf97d5213199c86fa2b9";
    @NotNull
    private static final String FBR2_HASH = "cc2751449a350f668590264ed76692694a80308a";
    @NotNull
    private static final String MSR_HASH = "9b8f518b086098de3d77736f9458a3d2f6f95a37";
    @NotNull
    private static final String FBF_HASH = "2438bce1ddb7bd026d5ff89f598b3b5e5bb824b3";
    @NotNull
    private static final String IGR_HASH = "c56fb7d591ba6704df047fd98f535372fea00211";
    @NotNull
    private static final HashSet<String> validAppSignatureHashes;

    private FacebookSignatureValidator() {
    }

    @JvmStatic
    public static final boolean validateSignature(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String brand = Build.BRAND;
        int applicationFlags = context.getApplicationInfo().flags;
        Intrinsics.checkNotNullExpressionValue((Object)brand, (String)"brand");
        if (StringsKt.startsWith$default((String)brand, (String)"generic", (boolean)false, (int)2, null) && (applicationFlags & 2) != 0) {
            return true;
        }
        try {
            boolean bl;
            block7: {
                PackageInfo packageInfo;
                block9: {
                    block8: {
                        packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
                        if (packageInfo.signatures == null) break block8;
                        Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"packageInfo.signatures");
                        if (!(((Object[])packageInfo.signatures).length == 0)) break block9;
                    }
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"packageInfo.signatures");
                Object[] $this$all$iv = packageInfo.signatures;
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    Signature it = (Signature)element$iv;
                    boolean bl2 = false;
                    Iterable iterable = validAppSignatureHashes;
                    byte[] byArray = it.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
                    if (CollectionsKt.contains((Iterable)iterable, (Object)Utility.sha1hash(byArray))) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            return bl;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    static {
        Object[] objectArray = new String[]{FBR_HASH, FBR2_HASH, FBI_HASH, FBL_HASH, MSR_HASH, FBF_HASH, IGR_HASH};
        validAppSignatureHashes = SetsKt.hashSetOf((Object[])objectArray);
    }
}

