/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebView;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.UserSettingsManager;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AnalyticsUserIDStore;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventQueue;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.FacebookSDKJSInterface;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.OperationalData;
import com.facebook.appevents.OperationalDataEnum;
import com.facebook.appevents.UserDataStore;
import com.facebook.appevents.gps.ara.GpsAraTriggersManager;
import com.facebook.appevents.gps.pa.PACustomAudienceClient;
import com.facebook.appevents.iap.InAppPurchase;
import com.facebook.appevents.iap.InAppPurchaseDedupeConfig;
import com.facebook.appevents.iap.InAppPurchaseManager;
import com.facebook.appevents.integrity.BannedParamManager;
import com.facebook.appevents.integrity.BlocklistEventsManager;
import com.facebook.appevents.integrity.MACARuleMatchingManager;
import com.facebook.appevents.integrity.ProtectedModeManager;
import com.facebook.appevents.integrity.SensitiveParamsManager;
import com.facebook.appevents.integrity.StdParamsEnforcementManager;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.ondeviceprocessing.OnDeviceProcessingManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.InstallReferrerUtil;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0001\u0018\u0000 <2\u00020\u0001:\u0001<B%\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0000\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017JG\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0005J:\u0010\"\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ)\u0010\"\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010'J\u0088\u0001\u0010(\u001a\u00020\u00112\b\u0010)\u001a\u0004\u0018\u00010\u00052\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010\u00052\b\u0010/\u001a\u0004\u0018\u00010\u00052\b\u00100\u001a\u0004\u0018\u00010\u00052\b\u00101\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u00103\u001a\u0004\u0018\u00010\u00052\b\u00104\u001a\u0004\u0018\u00010\u00052\b\u00105\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u00106\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J&\u00106\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J8\u00106\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00132\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ0\u00107\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0018\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00172\b\u0010:\u001a\u0004\u0018\u00010\u0005J'\u0010;\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010'R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/facebook/appevents/AppEventsLoggerImpl;", "", "context", "Landroid/content/Context;", "applicationId", "", "accessToken", "Lcom/facebook/AccessToken;", "(Landroid/content/Context;Ljava/lang/String;Lcom/facebook/AccessToken;)V", "activityName", "(Ljava/lang/String;Ljava/lang/String;Lcom/facebook/AccessToken;)V", "accessTokenAppId", "Lcom/facebook/appevents/AccessTokenAppIdPair;", "getApplicationId", "()Ljava/lang/String;", "contextName", "flush", "", "isValidForAccessToken", "", "logEvent", "eventName", "parameters", "Landroid/os/Bundle;", "valueToSum", "", "isImplicitlyLogged", "currentSessionId", "Ljava/util/UUID;", "operationalData", "Lcom/facebook/appevents/OperationalData;", "(Ljava/lang/String;Ljava/lang/Double;Landroid/os/Bundle;ZLjava/util/UUID;Lcom/facebook/appevents/OperationalData;)V", "logEventFromSE", "buttonText", "logEventImplicitly", "purchaseAmount", "Ljava/math/BigDecimal;", "currency", "Ljava/util/Currency;", "(Ljava/lang/String;Ljava/lang/Double;Landroid/os/Bundle;)V", "logProductItem", "itemID", "availability", "Lcom/facebook/appevents/AppEventsLogger$ProductAvailability;", "condition", "Lcom/facebook/appevents/AppEventsLogger$ProductCondition;", "description", "imageLink", "link", "title", "priceAmount", "gtin", "mpn", "brand", "logPurchase", "logPurchaseImplicitly", "logPushNotificationOpen", "payload", "action", "logSdkEvent", "Companion", "facebook-core_release"})
public final class AppEventsLoggerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contextName;
    @NotNull
    private AccessTokenAppIdPair accessTokenAppId;
    @NotNull
    private static final String TAG;
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    @NotNull
    private static final String PUSH_PAYLOAD_KEY = "fb_push_payload";
    @NotNull
    private static final String PUSH_PAYLOAD_CAMPAIGN_KEY = "campaign";
    @NotNull
    private static final String APP_EVENT_NAME_PUSH_OPENED = "fb_mobile_push_opened";
    @NotNull
    private static final String APP_EVENT_PUSH_PARAMETER_CAMPAIGN = "fb_push_campaign";
    @NotNull
    private static final String APP_EVENT_PUSH_PARAMETER_ACTION = "fb_push_action";
    @NotNull
    private static final String ACCOUNT_KIT_EVENT_NAME_PREFIX = "fb_ak";
    @Nullable
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    @NotNull
    private static AppEventsLogger.FlushBehavior flushBehaviorField;
    @NotNull
    private static final Object staticLock;
    @Nullable
    private static String anonymousAppDeviceGUID;
    private static boolean isActivateAppEventRequested;
    @Nullable
    private static String pushNotificationsRegistrationIdField;
    @NotNull
    private static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    @NotNull
    public static final String APP_EVENTS_KILLSWITCH = "app_events_killswitch";

    public AppEventsLoggerImpl(@NotNull String activityName, @Nullable String applicationId, @Nullable AccessToken accessToken) {
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        String applicationId2 = applicationId;
        AccessToken accessToken2 = accessToken;
        Validate.sdkInitialized();
        this.contextName = activityName;
        if (accessToken2 == null) {
            accessToken2 = AccessToken.Companion.getCurrentAccessToken();
        }
        if (accessToken2 != null && !accessToken2.isExpired() && (applicationId2 == null || Intrinsics.areEqual((Object)applicationId2, (Object)accessToken2.getApplicationId()))) {
            this.accessTokenAppId = new AccessTokenAppIdPair(accessToken2);
        } else {
            if (applicationId2 == null) {
                applicationId2 = Utility.getMetadataApplicationId(FacebookSdk.getApplicationContext());
            }
            String string = applicationId2;
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, string);
        }
        AppEventsLoggerImpl.Companion.initializeTimersIfNeeded();
    }

    public AppEventsLoggerImpl(@Nullable Context context, @Nullable String applicationId, @Nullable AccessToken accessToken) {
        this(Utility.getActivityName(context), applicationId, accessToken);
    }

    /*
     * WARNING - void declaration
     */
    public final void logEvent(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            this.logEvent((String)eventName, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEvent(@Nullable String string, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void eventName;
            AppEventsLoggerImpl.logEvent$default(this, (String)eventName, null, (Bundle)parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid(), null, 32, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logEvent$default(AppEventsLoggerImpl appEventsLoggerImpl, String string, Bundle bundle, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 2) != 0) {
                bundle = null;
            }
            appEventsLoggerImpl.logEvent(string, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEvent(@Nullable String string, double d) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void valueToSum;
            void eventName;
            this.logEvent((String)eventName, (double)valueToSum, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEvent(@Nullable String string, double d, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void valueToSum;
            void eventName;
            AppEventsLoggerImpl.logEvent$default(this, (String)eventName, (double)valueToSum, (Bundle)parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid(), null, 32, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEventFromSE(@Nullable String string, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            void buttonText;
            Bundle parameters = new Bundle();
            parameters.putString("_is_suggested_event", "1");
            parameters.putString("_button_text", (String)buttonText);
            this.logEvent((String)eventName, parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logPurchase(@Nullable BigDecimal bigDecimal, @Nullable Currency currency) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void currency2;
            void purchaseAmount;
            this.logPurchase((BigDecimal)purchaseAmount, (Currency)currency2, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logPurchase(@Nullable BigDecimal bigDecimal, @Nullable Currency currency, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void currency2;
            void purchaseAmount;
            AppEventsLoggerImpl.logPurchase$default(this, (BigDecimal)purchaseAmount, (Currency)currency2, (Bundle)parameters, false, null, 16, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logPurchase$default(AppEventsLoggerImpl appEventsLoggerImpl, BigDecimal bigDecimal, Currency currency, Bundle bundle, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 4) != 0) {
                bundle = null;
            }
            appEventsLoggerImpl.logPurchase(bigDecimal, currency, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logPurchaseImplicitly(@Nullable BigDecimal bigDecimal, @Nullable Currency currency, @Nullable Bundle bundle, @Nullable OperationalData operationalData) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void operationalData2;
            void parameters;
            void currency2;
            void purchaseAmount;
            this.logPurchase((BigDecimal)purchaseAmount, (Currency)currency2, (Bundle)parameters, true, (OperationalData)operationalData2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logPurchaseImplicitly$default(AppEventsLoggerImpl appEventsLoggerImpl, BigDecimal bigDecimal, Currency currency, Bundle bundle, OperationalData operationalData, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 8) != 0) {
                operationalData = null;
            }
            appEventsLoggerImpl.logPurchaseImplicitly(bigDecimal, currency, bundle, operationalData);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logPurchase(@Nullable BigDecimal bigDecimal, @Nullable Currency currency, @Nullable Bundle bundle, boolean bl, @Nullable OperationalData operationalData) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void operationalData2;
            void isImplicitlyLogged;
            void currency2;
            void purchaseAmount;
            void parameters;
            Bundle parameters2 = parameters;
            if (purchaseAmount == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("purchaseAmount cannot be null");
                return;
            }
            if (currency2 == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("currency cannot be null");
                return;
            }
            if (parameters2 == null) {
                parameters2 = new Bundle();
            }
            parameters2.putString("fb_currency", currency2.getCurrencyCode());
            this.logEvent("fb_mobile_purchase", purchaseAmount.doubleValue(), parameters2, (boolean)isImplicitlyLogged, ActivityLifecycleTracker.getCurrentSessionGuid(), (OperationalData)operationalData2);
            Companion.eagerFlush();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logPurchase$default(AppEventsLoggerImpl appEventsLoggerImpl, BigDecimal bigDecimal, Currency currency, Bundle bundle, boolean bl, OperationalData operationalData, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 0x10) != 0) {
                operationalData = null;
            }
            appEventsLoggerImpl.logPurchase(bigDecimal, currency, bundle, bl, operationalData);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logPushNotificationOpen(@NotNull Bundle bundle, @Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void action;
            void payload;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            String campaignId = null;
            try {
                String payloadString = payload.getString(PUSH_PAYLOAD_KEY);
                if (Utility.isNullOrEmpty(payloadString)) {
                    return;
                }
                JSONObject facebookPayload = new JSONObject(payloadString);
                campaignId = facebookPayload.getString(PUSH_PAYLOAD_CAMPAIGN_KEY);
            }
            catch (JSONException payloadString) {
                // empty catch block
            }
            if (campaignId == null) {
                Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Malformed payload specified for logging a push notification open.");
                return;
            }
            Bundle parameters = new Bundle();
            parameters.putString(APP_EVENT_PUSH_PARAMETER_CAMPAIGN, campaignId);
            if (action != null) {
                parameters.putString(APP_EVENT_PUSH_PARAMETER_ACTION, (String)action);
            }
            this.logEvent(APP_EVENT_NAME_PUSH_OPENED, parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logProductItem(@Nullable String string, @Nullable AppEventsLogger.ProductAvailability productAvailability, @Nullable AppEventsLogger.ProductCondition productCondition, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable BigDecimal bigDecimal, @Nullable Currency currency, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void brand;
            void mpn;
            void gtin;
            void currency2;
            void priceAmount;
            void title;
            void link;
            void imageLink;
            void description;
            void condition;
            void availability;
            void itemID;
            void parameters;
            Bundle parameters2 = parameters;
            if (itemID == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("itemID cannot be null");
                return;
            }
            if (availability == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("availability cannot be null");
                return;
            }
            if (condition == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("condition cannot be null");
                return;
            }
            if (description == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("description cannot be null");
                return;
            }
            if (imageLink == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("imageLink cannot be null");
                return;
            }
            if (link == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("link cannot be null");
                return;
            }
            if (title == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("title cannot be null");
                return;
            }
            if (priceAmount == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("priceAmount cannot be null");
                return;
            }
            if (currency2 == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("currency cannot be null");
                return;
            }
            if (gtin == null && mpn == null && brand == null) {
                AppEventsLoggerImpl.Companion.notifyDeveloperError("Either gtin, mpn or brand is required");
                return;
            }
            if (parameters2 == null) {
                parameters2 = new Bundle();
            }
            parameters2.putString("fb_product_item_id", (String)itemID);
            parameters2.putString("fb_product_availability", availability.name());
            parameters2.putString("fb_product_condition", condition.name());
            parameters2.putString("fb_product_description", (String)description);
            parameters2.putString("fb_product_image_link", (String)imageLink);
            parameters2.putString("fb_product_link", (String)link);
            parameters2.putString("fb_product_title", (String)title);
            parameters2.putString("fb_product_price_amount", priceAmount.setScale(3, 4).toString());
            parameters2.putString("fb_product_price_currency", currency2.getCurrencyCode());
            if (gtin != null) {
                parameters2.putString("fb_product_gtin", (String)gtin);
            }
            if (mpn != null) {
                parameters2.putString("fb_product_mpn", (String)mpn);
            }
            if (brand != null) {
                parameters2.putString("fb_product_brand", (String)brand);
            }
            this.logEvent("fb_mobile_catalog_update", parameters2);
            Companion.eagerFlush();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public final void flush() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            AppEventQueue.flush(FlushReason.EXPLICIT);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidForAccessToken(@NotNull AccessToken accessToken) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void accessToken2;
            Intrinsics.checkNotNullParameter((Object)accessToken2, (String)"accessToken");
            AccessTokenAppIdPair other = new AccessTokenAppIdPair((AccessToken)accessToken2);
            return Intrinsics.areEqual((Object)this.accessTokenAppId, (Object)other);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logSdkEvent(@NotNull String string, @Nullable Double d, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!StringsKt.startsWith$default((String)eventName, (String)ACCOUNT_KIT_EVENT_NAME_PREFIX, (boolean)false, (int)2, null)) {
                Log.e((String)TAG, (String)"logSdkEvent is deprecated and only supports account kit for legacy, please use logEvent instead");
                return;
            }
            if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                void parameters;
                void valueToSum;
                AppEventsLoggerImpl.logEvent$default(this, (String)eventName, (Double)valueToSum, (Bundle)parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid(), null, 32, null);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @NotNull
    public final String getApplicationId() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return this.accessTokenAppId.getApplicationId();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEventImplicitly(@Nullable String string, @Nullable Double d, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void valueToSum;
            void eventName;
            AppEventsLoggerImpl.logEvent$default(this, (String)eventName, (Double)valueToSum, (Bundle)parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid(), null, 32, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEventImplicitly(@Nullable String string, @Nullable BigDecimal bigDecimal, @Nullable Currency currency, @Nullable Bundle bundle, @Nullable OperationalData operationalData) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void operationalData2;
            void eventName;
            void currency2;
            void purchaseAmount;
            void parameters;
            Bundle parameters2 = parameters;
            if (purchaseAmount == null || currency2 == null) {
                Utility.logd(TAG, "purchaseAmount and currency cannot be null");
                return;
            }
            if (parameters2 == null) {
                parameters2 = new Bundle();
            }
            parameters2.putString("fb_currency", currency2.getCurrencyCode());
            this.logEvent((String)eventName, purchaseAmount.doubleValue(), parameters2, true, ActivityLifecycleTracker.getCurrentSessionGuid(), (OperationalData)operationalData2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logEventImplicitly$default(AppEventsLoggerImpl appEventsLoggerImpl, String string, BigDecimal bigDecimal, Currency currency, Bundle bundle, OperationalData operationalData, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 0x10) != 0) {
                operationalData = null;
            }
            appEventsLoggerImpl.logEventImplicitly(string, bigDecimal, currency, bundle, operationalData);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logEvent(@Nullable String string, @Nullable Double d, @Nullable Bundle bundle, boolean bl, @Nullable UUID uUID, @Nullable OperationalData operationalData) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Pair<Bundle, OperationalData> pair;
            Object[] objectArray;
            void valueToSum;
            void isImplicitlyLogged;
            void operationalData2;
            void parameters;
            void eventName;
            CharSequence charSequence = (CharSequence)eventName;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            Bundle modifiedParameters = parameters;
            OperationalData modifiedOperationalData = operationalData2;
            if (isImplicitlyLogged == false && AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled() && (Intrinsics.areEqual((Object)eventName, (Object)"fb_mobile_purchase") || Intrinsics.areEqual((Object)eventName, (Object)"Subscribe") || Intrinsics.areEqual((Object)eventName, (Object)"StartTrial"))) {
                Log.w((String)TAG, (String)"You are logging purchase events while auto-logging of in-app purchase is enabled in the SDK. Make sure you don't log duplicate events");
                if (FeatureManager.isEnabled(FeatureManager.Feature.AndroidManualImplicitPurchaseDedupe) && Intrinsics.areEqual((Object)eventName, (Object)"fb_mobile_purchase") || FeatureManager.isEnabled(FeatureManager.Feature.AndroidManualImplicitSubsDedupe) && (Intrinsics.areEqual((Object)eventName, (Object)"Subscribe") || Intrinsics.areEqual((Object)eventName, (Object)"StartTrial"))) {
                    Double purchaseAmount = InAppPurchaseDedupeConfig.INSTANCE.getValueOfManualEvent((Double)valueToSum, (Bundle)parameters);
                    Currency currency = InAppPurchaseDedupeConfig.INSTANCE.getCurrencyOfManualEvent((Bundle)parameters);
                    if (purchaseAmount != null && currency != null) {
                        InAppPurchase purchase = new InAppPurchase((String)eventName, purchaseAmount, currency);
                        Bundle dedupeParameters = InAppPurchaseManager.performDedupe(CollectionsKt.listOf((Object)purchase), System.currentTimeMillis(), false, CollectionsKt.listOf((Object)new Pair((Object)parameters, (Object)operationalData2)));
                        objectArray = InAppPurchaseDedupeConfig.INSTANCE.addDedupeParameters(dedupeParameters, modifiedParameters, (OperationalData)operationalData2);
                        Bundle newParameters = (Bundle)objectArray.component1();
                        OperationalData newOperationalData = (OperationalData)objectArray.component2();
                        modifiedParameters = newParameters;
                        modifiedOperationalData = newOperationalData;
                    }
                }
            }
            if (FetchedAppGateKeepersManager.getGateKeeperForKey(APP_EVENTS_KILLSWITCH, FacebookSdk.getApplicationId(), false)) {
                pair = new Pair<Bundle, OperationalData>[]{eventName};
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "KillSwitch is enabled and fail to log app event: %s", pair);
                return;
            }
            if (BlocklistEventsManager.isInBlocklist((String)eventName)) {
                return;
            }
            pair = Companion.addImplicitPurchaseParameters(modifiedParameters, modifiedOperationalData, (boolean)isImplicitlyLogged);
            Bundle newParameters = (Bundle)pair.component1();
            OperationalData newOperationalData = (OperationalData)pair.component2();
            modifiedParameters = newParameters;
            modifiedOperationalData = newOperationalData;
            try {
                void currentSessionId;
                if (!ProtectedModeManager.INSTANCE.protectedModeIsApplied(modifiedParameters)) {
                    SensitiveParamsManager.processFilterSensitiveParams(modifiedParameters, (String)eventName);
                }
                BannedParamManager.processFilterBannedParams(modifiedParameters);
                MACARuleMatchingManager.processParameters(modifiedParameters, (String)eventName);
                StdParamsEnforcementManager.processFilterParamSchemaBlocking(modifiedParameters);
                ProtectedModeManager.processParametersForProtectedMode(modifiedParameters);
                AppEvent event = new AppEvent(this.contextName, (String)eventName, (Double)valueToSum, modifiedParameters, (boolean)isImplicitlyLogged, ActivityLifecycleTracker.isInBackground(), (UUID)currentSessionId, modifiedOperationalData);
                AppEventsLoggerImpl.Companion.logEvent(event, this.accessTokenAppId);
            }
            catch (JSONException jsonException) {
                objectArray = new Object[]{jsonException.toString()};
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", objectArray);
            }
            catch (FacebookException e) {
                objectArray = new Object[]{e.toString()};
                Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event: %s", objectArray);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static /* synthetic */ void logEvent$default(AppEventsLoggerImpl appEventsLoggerImpl, String string, Double d, Bundle bundle, boolean bl, UUID uUID, OperationalData operationalData, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if ((n & 0x20) != 0) {
                operationalData = null;
            }
            appEventsLoggerImpl.logEvent(string, d, bundle, bl, uUID, operationalData);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final AppEventsLogger.FlushBehavior getFlushBehavior() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return Companion.getFlushBehavior();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    @JvmStatic
    public static final void setFlushBehavior(@NotNull AppEventsLogger.FlushBehavior flushBehavior) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            AppEventsLogger.FlushBehavior flushBehavior2;
            Companion.setFlushBehavior(flushBehavior2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getPushNotificationsRegistrationId() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return Companion.getPushNotificationsRegistrationId();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    @JvmStatic
    public static final void setPushNotificationsRegistrationId(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String registrationId;
            Companion.setPushNotificationsRegistrationId(registrationId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void activateApp(@NotNull Application application, @Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void applicationId;
            Application application2;
            Companion.activateApp(application2, (String)applicationId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<Bundle, OperationalData> addImplicitPurchaseParameters(@Nullable Bundle bundle, @Nullable OperationalData operationalData, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            void isImplicitlyLogged;
            void operationalData2;
            Bundle params;
            return Companion.addImplicitPurchaseParameters(params, (OperationalData)operationalData2, (boolean)isImplicitlyLogged);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    @JvmStatic
    public static final void functionDEPRECATED(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String extraMsg;
            Companion.functionDEPRECATED(extraMsg);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void initializeLib(@NotNull Context context, @Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void applicationId;
            Context context2;
            Companion.initializeLib(context2, (String)applicationId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @JvmStatic
    public static final void onContextStop() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            Companion.onContextStop();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getInstallReferrer() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return Companion.getInstallReferrer();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    @JvmStatic
    public static final void setInstallReferrer(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String referrer;
            Companion.setInstallReferrer(referrer);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void augmentWebView(@NotNull WebView webView, @Nullable Context context) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void context2;
            WebView webView2;
            Companion.augmentWebView(webView2, (Context)context2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final Executor getAnalyticsExecutor() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return Companion.getAnalyticsExecutor();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getAnonymousAppDeviceGUID(@NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            Context context2;
            return Companion.getAnonymousAppDeviceGUID(context2);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ Object access$getStaticLock$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return staticLock;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ ScheduledThreadPoolExecutor access$getBackgroundExecutor$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return backgroundExecutor;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ boolean access$isActivateAppEventRequested$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return false;
        }
        try {
            return isActivateAppEventRequested;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return false;
        }
    }

    public static final /* synthetic */ void access$setActivateAppEventRequested$cp(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            boolean bl2;
            isActivateAppEventRequested = bl2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    public static final /* synthetic */ String access$getAnonymousAppDeviceGUID$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return anonymousAppDeviceGUID;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ AppEventsLogger.FlushBehavior access$getFlushBehaviorField$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return flushBehaviorField;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ void access$setFlushBehaviorField$cp(AppEventsLogger.FlushBehavior flushBehavior) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            AppEventsLogger.FlushBehavior flushBehavior2;
            flushBehaviorField = flushBehavior2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    public static final /* synthetic */ String access$getPushNotificationsRegistrationIdField$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return pushNotificationsRegistrationIdField;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    public static final /* synthetic */ void access$setPushNotificationsRegistrationIdField$cp(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String string2;
            pushNotificationsRegistrationIdField = string2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    public static final /* synthetic */ void access$setBackgroundExecutor$cp(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2;
            backgroundExecutor = scheduledThreadPoolExecutor2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    public static final /* synthetic */ void access$setAnonymousAppDeviceGUID$cp(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String string2;
            anonymousAppDeviceGUID = string2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    static {
        String string = AppEventsLoggerImpl.class.getCanonicalName();
        TAG = string == null ? "com.facebook.appevents.AppEventsLoggerImpl" : string;
        flushBehaviorField = AppEventsLogger.FlushBehavior.AUTO;
        staticLock = new Object();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J4\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u001f2\b\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\u0015H\u0007J\u001a\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u0006\u0010)\u001a\u00020\u0019J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0004H\u0007J\b\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0007J\b\u0010/\u001a\u00020\u0013H\u0007J\n\u00100\u001a\u0004\u0018\u00010\u0004H\u0007J\n\u00101\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u00102\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u00103\u001a\u00020\u0019H\u0002J\u0018\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0004H\u0002J\b\u0010;\u001a\u00020\u0019H\u0007J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u0013H\u0007J\u0012\u0010>\u001a\u00020\u00192\b\u0010?\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010@\u001a\u00020\u00192\b\u0010A\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/facebook/appevents/AppEventsLoggerImpl$Companion;", "", "()V", "ACCOUNT_KIT_EVENT_NAME_PREFIX", "", "APP_EVENTS_KILLSWITCH", "APP_EVENT_NAME_PUSH_OPENED", "APP_EVENT_PREFERENCES", "APP_EVENT_PUSH_PARAMETER_ACTION", "APP_EVENT_PUSH_PARAMETER_CAMPAIGN", "APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS", "", "PUSH_PAYLOAD_CAMPAIGN_KEY", "PUSH_PAYLOAD_KEY", "TAG", "anonymousAppDeviceGUID", "backgroundExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "flushBehaviorField", "Lcom/facebook/appevents/AppEventsLogger$FlushBehavior;", "isActivateAppEventRequested", "", "pushNotificationsRegistrationIdField", "staticLock", "activateApp", "", "application", "Landroid/app/Application;", "applicationId", "addImplicitPurchaseParameters", "Lkotlin/Pair;", "Landroid/os/Bundle;", "Lcom/facebook/appevents/OperationalData;", "params", "operationalData", "isImplicitlyLogged", "augmentWebView", "webView", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "eagerFlush", "functionDEPRECATED", "extraMsg", "getAnalyticsExecutor", "Ljava/util/concurrent/Executor;", "getAnonymousAppDeviceGUID", "getFlushBehavior", "getInstallReferrer", "getPushNotificationsRegistrationId", "initializeLib", "initializeTimersIfNeeded", "logEvent", "event", "Lcom/facebook/appevents/AppEvent;", "accessTokenAppId", "Lcom/facebook/appevents/AccessTokenAppIdPair;", "notifyDeveloperError", "message", "onContextStop", "setFlushBehavior", "flushBehavior", "setInstallReferrer", "referrer", "setPushNotificationsRegistrationId", "registrationId", "facebook-core_release"})
    @SourceDebugExtension(value={"SMAP\nAppEventsLoggerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEventsLoggerImpl.kt\ncom/facebook/appevents/AppEventsLoggerImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,861:1\n1#2:862\n37#3,2:863\n*S KotlinDebug\n*F\n+ 1 AppEventsLoggerImpl.kt\ncom/facebook/appevents/AppEventsLoggerImpl$Companion\n*L\n707#1:863,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final AppEventsLogger.FlushBehavior getFlushBehavior() {
            Object object = AppEventsLoggerImpl.access$getStaticLock$cp();
            synchronized (object) {
                boolean bl = false;
                AppEventsLogger.FlushBehavior flushBehavior = AppEventsLoggerImpl.access$getFlushBehaviorField$cp();
                return flushBehavior;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void setFlushBehavior(@NotNull AppEventsLogger.FlushBehavior flushBehavior) {
            Intrinsics.checkNotNullParameter((Object)((Object)flushBehavior), (String)"flushBehavior");
            Object object = AppEventsLoggerImpl.access$getStaticLock$cp();
            synchronized (object) {
                boolean bl = false;
                AppEventsLoggerImpl.access$setFlushBehaviorField$cp(flushBehavior);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final String getPushNotificationsRegistrationId() {
            Object object = AppEventsLoggerImpl.access$getStaticLock$cp();
            synchronized (object) {
                boolean bl = false;
                String string = AppEventsLoggerImpl.access$getPushNotificationsRegistrationIdField$cp();
                return string;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void setPushNotificationsRegistrationId(@Nullable String registrationId) {
            Object object = AppEventsLoggerImpl.access$getStaticLock$cp();
            synchronized (object) {
                boolean bl = false;
                if (!Utility.stringsEqualOrEmpty(AppEventsLoggerImpl.access$getPushNotificationsRegistrationIdField$cp(), registrationId)) {
                    AppEventsLoggerImpl.access$setPushNotificationsRegistrationIdField$cp(registrationId);
                    AppEventsLoggerImpl logger = new AppEventsLoggerImpl(FacebookSdk.getApplicationContext(), null, null);
                    logger.logEvent("fb_mobile_obtain_push_token");
                    if (Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                        logger.flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmStatic
        public final void activateApp(@NotNull Application application, @Nullable String applicationId) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            String applicationId2 = applicationId;
            if (!FacebookSdk.isInitialized()) {
                throw new FacebookException("The Facebook sdk must be initialized before calling activateApp");
            }
            AnalyticsUserIDStore.initStore();
            UserDataStore.initStore();
            if (applicationId2 == null) {
                applicationId2 = FacebookSdk.getApplicationId();
            }
            FacebookSdk.publishInstallAsync((Context)application, applicationId2);
            ActivityLifecycleTracker.startTracking(application, applicationId2);
            if (FeatureManager.isEnabled(FeatureManager.Feature.GPSPACAProcessing)) {
                PACustomAudienceClient.INSTANCE.joinCustomAudience(applicationId2, "fb_mobile_app_install");
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.GPSARATriggers)) {
                AppEvent event = new AppEvent("unknown", "MOBILE_INSTALL_EVENT", null, null, false, ActivityLifecycleTracker.isInBackground(), ActivityLifecycleTracker.getCurrentSessionGuid(), null);
                GpsAraTriggersManager.INSTANCE.registerTriggerAsync(applicationId2, event);
            }
        }

        @JvmStatic
        @NotNull
        public final Pair<Bundle, OperationalData> addImplicitPurchaseParameters(@Nullable Bundle params, @Nullable OperationalData operationalData, boolean isImplicitlyLogged) {
            String productId;
            Bundle modifiedParams = params;
            OperationalData modifiedOperationalData = operationalData;
            Pair<Bundle, OperationalData> modifiedParamsAndData = null;
            String isImplicitPurchaseEnabled = AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled() ? "1" : "0";
            modifiedParamsAndData = OperationalData.Companion.addParameterAndReturn(OperationalDataEnum.IAPParameters, "is_implicit_purchase_logging_enabled", isImplicitPurchaseEnabled, modifiedParams, modifiedOperationalData);
            Object object = OperationalData.Companion.getParameter(OperationalDataEnum.IAPParameters, "fb_iap_product_id", modifiedParams, modifiedOperationalData);
            String string = productId = object instanceof String ? (String)object : null;
            if (!isImplicitlyLogged) {
                Bundle bundle = modifiedParams;
                if ((bundle != null ? bundle.getString("fb_content_id") : null) == null && productId != null) {
                    modifiedParamsAndData = OperationalData.Companion.addParameterAndReturn(OperationalDataEnum.IAPParameters, "fb_content_id", productId, modifiedParams, modifiedOperationalData);
                    modifiedParams = (Bundle)modifiedParamsAndData.getFirst();
                    modifiedOperationalData = (OperationalData)modifiedParamsAndData.getSecond();
                    modifiedParamsAndData = OperationalData.Companion.addParameterAndReturn(OperationalDataEnum.IAPParameters, "android_dynamic_ads_content_id", "client_manual", modifiedParams, modifiedOperationalData);
                }
            }
            modifiedParams = (Bundle)modifiedParamsAndData.getFirst();
            modifiedOperationalData = (OperationalData)modifiedParamsAndData.getSecond();
            String isAutoLoggingEnabled = UserSettingsManager.getAutoLogAppEventsEnabled() ? "1" : "0";
            modifiedParamsAndData = OperationalData.Companion.addParameterAndReturn(OperationalDataEnum.IAPParameters, "is_autolog_app_events_enabled", isAutoLoggingEnabled, modifiedParams, modifiedOperationalData);
            modifiedParams = (Bundle)modifiedParamsAndData.getFirst();
            modifiedOperationalData = (OperationalData)modifiedParamsAndData.getSecond();
            return new Pair((Object)modifiedParams, (Object)modifiedOperationalData);
        }

        @JvmStatic
        public final void functionDEPRECATED(@NotNull String extraMsg) {
            Intrinsics.checkNotNullParameter((Object)extraMsg, (String)"extraMsg");
            Log.w((String)AppEventsLoggerImpl.access$getTAG$cp(), (String)("This function is deprecated. " + extraMsg));
        }

        @JvmStatic
        public final void initializeLib(@NotNull Context context, @Nullable String applicationId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
                return;
            }
            AppEventsLoggerImpl logger = new AppEventsLoggerImpl(context, applicationId, null);
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AppEventsLoggerImpl.access$getBackgroundExecutor$cp();
            if (scheduledThreadPoolExecutor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            scheduledThreadPoolExecutor.execute(() -> Companion.initializeLib$lambda$4(context, logger));
        }

        @JvmStatic
        public final void onContextStop() {
            AppEventQueue.persistToDisk();
        }

        @JvmStatic
        @Nullable
        public final String getInstallReferrer() {
            InstallReferrerUtil.tryUpdateReferrerInfo(new InstallReferrerUtil.Callback(){

                public void onReceiveReferrerUrl(@Nullable String s) {
                    AppEventsLoggerImpl.Companion.setInstallReferrer(s);
                }
            });
            Context ctx = FacebookSdk.getApplicationContext();
            SharedPreferences preferences2 = ctx.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
            return preferences2.getString("install_referrer", null);
        }

        @JvmStatic
        public final void setInstallReferrer(@Nullable String referrer) {
            Context ctx = FacebookSdk.getApplicationContext();
            SharedPreferences preferences2 = ctx.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
            if (referrer != null) {
                preferences2.edit().putString("install_referrer", referrer).apply();
            }
        }

        @JvmStatic
        public final void augmentWebView(@NotNull WebView webView, @Nullable Context context) {
            int minorRelease;
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            String string = Build.VERSION.RELEASE;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            int majorRelease = !(parts.length == 0) ? Integer.parseInt(parts[0]) : 0;
            int n = minorRelease = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            if (Build.VERSION.SDK_INT < 17 || majorRelease < 4 || majorRelease == 4 && minorRelease <= 1) {
                Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, AppEventsLoggerImpl.access$getTAG$cp(), "augmentWebView is only available for Android SDK version >= 17 on devices running Android >= 4.2");
                return;
            }
            webView.addJavascriptInterface((Object)new FacebookSDKJSInterface(context), "fbmq_" + FacebookSdk.getApplicationId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeTimersIfNeeded() {
            Object object;
            Object object2 = AppEventsLoggerImpl.access$getStaticLock$cp();
            synchronized (object2) {
                boolean bl = false;
                if (AppEventsLoggerImpl.access$getBackgroundExecutor$cp() != null) {
                    return;
                }
                AppEventsLoggerImpl.access$setBackgroundExecutor$cp(new ScheduledThreadPoolExecutor(1));
                object = Unit.INSTANCE;
            }
            Runnable attributionRecheckRunnable = Companion::initializeTimersIfNeeded$lambda$6;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AppEventsLoggerImpl.access$getBackgroundExecutor$cp();
            if (scheduledThreadPoolExecutor == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            scheduledThreadPoolExecutor.scheduleAtFixedRate(attributionRecheckRunnable, 0L, 86400L, TimeUnit.SECONDS);
        }

        private final void logEvent(AppEvent event, AccessTokenAppIdPair accessTokenAppId) {
            AppEventQueue.add(accessTokenAppId, event);
            if (FeatureManager.isEnabled(FeatureManager.Feature.OnDevicePostInstallEventProcessing) && OnDeviceProcessingManager.isOnDeviceProcessingEnabled()) {
                OnDeviceProcessingManager.sendCustomEventAsync(accessTokenAppId.getApplicationId(), event);
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.GPSARATriggers)) {
                GpsAraTriggersManager.INSTANCE.registerTriggerAsync(accessTokenAppId.getApplicationId(), event);
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.GPSPACAProcessing)) {
                PACustomAudienceClient.INSTANCE.joinCustomAudience(accessTokenAppId.getApplicationId(), event);
            }
            if (!event.getIsImplicit() && !AppEventsLoggerImpl.access$isActivateAppEventRequested$cp()) {
                if (Intrinsics.areEqual((Object)event.getName(), (Object)"fb_mobile_activate_app")) {
                    AppEventsLoggerImpl.access$setActivateAppEventRequested$cp(true);
                } else {
                    Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Warning: Please call AppEventsLogger.activateApp(...)from the long-lived activity's onResume() methodbefore logging other app events.");
                }
            }
        }

        public final void eagerFlush() {
            if (this.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                AppEventQueue.flush(FlushReason.EAGER_FLUSHING_EVENT);
            }
        }

        private final void notifyDeveloperError(String message) {
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", message);
        }

        @JvmStatic
        @NotNull
        public final Executor getAnalyticsExecutor() {
            if (AppEventsLoggerImpl.access$getBackgroundExecutor$cp() == null) {
                this.initializeTimersIfNeeded();
            }
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AppEventsLoggerImpl.access$getBackgroundExecutor$cp();
            if (scheduledThreadPoolExecutor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return scheduledThreadPoolExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final String getAnonymousAppDeviceGUID(@NotNull Context context) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (AppEventsLoggerImpl.access$getAnonymousAppDeviceGUID$cp() == null) {
                object = AppEventsLoggerImpl.access$getStaticLock$cp();
                synchronized (object) {
                    boolean bl = false;
                    if (AppEventsLoggerImpl.access$getAnonymousAppDeviceGUID$cp() == null) {
                        SharedPreferences preferences2 = context.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
                        AppEventsLoggerImpl.access$setAnonymousAppDeviceGUID$cp(preferences2.getString("anonymousAppDeviceGUID", null));
                        if (AppEventsLoggerImpl.access$getAnonymousAppDeviceGUID$cp() == null) {
                            AppEventsLoggerImpl.access$setAnonymousAppDeviceGUID$cp("XZ" + UUID.randomUUID());
                            context.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0).edit().putString("anonymousAppDeviceGUID", AppEventsLoggerImpl.access$getAnonymousAppDeviceGUID$cp()).apply();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            String string = AppEventsLoggerImpl.access$getAnonymousAppDeviceGUID$cp();
            if (string == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            return string;
        }

        private static final void initializeLib$lambda$4(Context $context, AppEventsLoggerImpl $logger) {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
            Bundle params = new Bundle();
            String[] stringArray = new String[]{"com.facebook.core.Core", "com.facebook.login.Login", "com.facebook.share.Share", "com.facebook.places.Places", "com.facebook.messenger.Messenger", "com.facebook.applinks.AppLinks", "com.facebook.marketing.Marketing", "com.facebook.gamingservices.GamingServices", "com.facebook.all.All", "com.android.billingclient.api.BillingClient", "com.android.vending.billing.IInAppBillingService"};
            String[] classes = stringArray;
            String[] stringArray2 = new String[]{"core_lib_included", "login_lib_included", "share_lib_included", "places_lib_included", "messenger_lib_included", "applinks_lib_included", "marketing_lib_included", "gamingservices_lib_included", "all_lib_included", "billing_client_lib_included", "billing_service_lib_included"};
            String[] keys = stringArray2;
            if (classes.length != keys.length) {
                throw new FacebookException("Number of class names and key names should match");
            }
            int bitmask = 0;
            int n = classes.length;
            for (int i = 0; i < n; ++i) {
                String className = classes[i];
                String keyName = keys[i];
                try {
                    Class.forName(className);
                    params.putInt(keyName, 1);
                    bitmask |= 1 << i;
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            SharedPreferences preferences2 = $context.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
            int previousBitmask = preferences2.getInt("kitsBitmask", 0);
            if (previousBitmask != bitmask) {
                preferences2.edit().putInt("kitsBitmask", bitmask).apply();
                $logger.logEventImplicitly("fb_sdk_initialize", null, params);
            }
        }

        private static final void initializeTimersIfNeeded$lambda$6() {
            Set applicationIds = new HashSet();
            for (AccessTokenAppIdPair accessTokenAppId : AppEventQueue.getKeySet()) {
                applicationIds.add(accessTokenAppId.getApplicationId());
            }
            for (String applicationId : applicationIds) {
                FetchedAppSettingsManager.queryAppSettings(applicationId, true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

