/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.OperationalData;
import com.facebook.appevents.OperationalDataEnum;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.integrity.IntegrityManager;
import com.facebook.appevents.integrity.RedactedEventsManager;
import com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager;
import com.facebook.internal.Logger;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.BQ\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010B'\b\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u0012\u0006\u0010\u0013\u001a\u00020\n\u0012\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\u0018J;\u0010\"\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u0018J\u0010\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0003H\u0016J(\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030)2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/facebook/appevents/AppEvent;", "Ljava/io/Serializable;", "contextName", "", "eventName", "valueToSum", "", "parameters", "Landroid/os/Bundle;", "isImplicitlyLogged", "", "isInBackground", "currentSessionId", "Ljava/util/UUID;", "operationalParameters", "Lcom/facebook/appevents/OperationalData;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Landroid/os/Bundle;ZZLjava/util/UUID;Lcom/facebook/appevents/OperationalData;)V", "jsonString", "operationalJsonString", "isImplicit", "inBackground", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "()Z", "jsonObject", "Lorg/json/JSONObject;", "getJsonObject", "()Lorg/json/JSONObject;", "name", "getName", "()Ljava/lang/String;", "operationalJsonObject", "getOperationalJsonObject", "getIsImplicit", "getJSONObject", "getJSONObjectForAppEvent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Landroid/os/Bundle;Ljava/util/UUID;)Lorg/json/JSONObject;", "getOperationalJSONObject", "type", "Lcom/facebook/appevents/OperationalDataEnum;", "toString", "validateParameters", "", "isOperational", "writeReplace", "", "Companion", "SerializationProxyV2", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AppEvent
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSONObject jsonObject;
    @NotNull
    private final JSONObject operationalJsonObject;
    private final boolean isImplicit;
    private final boolean inBackground;
    @NotNull
    private final String name;
    private static final long serialVersionUID = 1L;
    @NotNull
    private static final HashSet<String> validatedIdentifiers = new HashSet();
    private static final int MAX_IDENTIFIER_LENGTH = 40;

    @NotNull
    public final JSONObject getJsonObject() {
        return this.jsonObject;
    }

    @NotNull
    public final JSONObject getOperationalJsonObject() {
        return this.operationalJsonObject;
    }

    public final boolean isImplicit() {
        return this.isImplicit;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public AppEvent(@NotNull String contextName, @NotNull String eventName, @Nullable Double valueToSum, @Nullable Bundle parameters, boolean isImplicitlyLogged, boolean isInBackground, @Nullable UUID currentSessionId, @Nullable OperationalData operationalParameters) throws JSONException, FacebookException {
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        this.isImplicit = isImplicitlyLogged;
        this.inBackground = isInBackground;
        this.name = eventName;
        OperationalData operationalData = operationalParameters;
        if (operationalData == null || (operationalData = operationalData.toJSON()) == null) {
            operationalData = new JSONObject();
        }
        this.operationalJsonObject = operationalData;
        this.jsonObject = this.getJSONObjectForAppEvent(contextName, eventName, valueToSum, parameters, currentSessionId);
    }

    public /* synthetic */ AppEvent(String string, String string2, Double d, Bundle bundle, boolean bl, boolean bl2, UUID uUID, OperationalData operationalData, int n, DefaultConstructorMarker defaultConstructorMarker) throws JSONException, FacebookException {
        if ((n & 0x80) != 0) {
            operationalData = null;
        }
        this(string, string2, d, bundle, bl, bl2, uUID, operationalData);
    }

    private AppEvent(String jsonString, String operationalJsonString, boolean isImplicit, boolean inBackground) {
        this.jsonObject = new JSONObject(jsonString);
        this.operationalJsonObject = new JSONObject(operationalJsonString);
        this.isImplicit = isImplicit;
        String string = this.jsonObject.optString("_eventName");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.optString(Con\u2026nts.EVENT_NAME_EVENT_KEY)");
        this.name = string;
        this.inBackground = inBackground;
    }

    public final boolean getIsImplicit() {
        return this.isImplicit;
    }

    @NotNull
    public final JSONObject getJSONObject() {
        return this.jsonObject;
    }

    @NotNull
    public final JSONObject getOperationalJSONObject() {
        return this.operationalJsonObject;
    }

    @Nullable
    public final JSONObject getOperationalJSONObject(@NotNull OperationalDataEnum type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.operationalJsonObject.optJSONObject(type.getValue());
    }

    private final JSONObject getJSONObjectForAppEvent(String contextName, String eventName, Double valueToSum, Bundle parameters, UUID currentSessionId) {
        Companion.validateIdentifier(eventName);
        JSONObject eventObject = new JSONObject();
        String finalEventName = RestrictiveDataManager.processEvent(eventName);
        if (Intrinsics.areEqual((Object)finalEventName, (Object)eventName)) {
            finalEventName = RedactedEventsManager.processEventsRedaction(eventName);
        }
        eventObject.put("_eventName", (Object)finalEventName);
        eventObject.put("_logTime", System.currentTimeMillis() / (long)1000);
        eventObject.put("_ui", (Object)contextName);
        if (currentSessionId != null) {
            eventObject.put("_session_id", (Object)currentSessionId);
        }
        if (parameters != null) {
            Map processedParam = AppEvent.validateParameters$default(this, parameters, false, 2, null);
            for (String key : processedParam.keySet()) {
                eventObject.put(key, processedParam.get(key));
            }
        }
        if (valueToSum != null) {
            eventObject.put("_valueToSum", valueToSum.doubleValue());
        }
        if (this.inBackground) {
            eventObject.put("_inBackground", (Object)"1");
        }
        if (this.isImplicit) {
            eventObject.put("_implicitlyLogged", (Object)"1");
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)eventObject.toString(), (String)"eventObject.toString()");
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Created app event '%s'", objectArray);
        }
        return eventObject;
    }

    private final Map<String, String> validateParameters(Bundle parameters, boolean isOperational) {
        Map paramMap = new HashMap();
        for (String key : parameters.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Companion.validateIdentifier(key);
            Object value = parameters.get(key);
            if (!(value instanceof String) && !(value instanceof Number)) {
                String string = "Parameter value '%s' for key '%s' should be a string or a numeric type.";
                Object[] objectArray = new Object[]{value, key};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                throw new FacebookException(string2);
            }
            paramMap.put(key, value.toString());
        }
        if (!isOperational) {
            IntegrityManager.processParameters(paramMap);
            RestrictiveDataManager.processParameters(TypeIntrinsics.asMutableMap((Object)paramMap), this.name);
            EventDeactivationManager.processDeprecatedParameters(TypeIntrinsics.asMutableMap((Object)paramMap), this.name);
        }
        return paramMap;
    }

    static /* synthetic */ Map validateParameters$default(AppEvent appEvent, Bundle bundle, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return appEvent.validateParameters(bundle, bl);
    }

    private final Object writeReplace() throws ObjectStreamException {
        String string = this.jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        String string2 = this.operationalJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"operationalJsonObject.toString()");
        return new SerializationProxyV2(string, string2, this.isImplicit, this.inBackground);
    }

    @NotNull
    public String toString() {
        String string = "\"%s\", implicit: %b, json: %s";
        Object[] objectArray = new Object[]{this.jsonObject.optString("_eventName"), this.isImplicit, this.jsonObject.toString()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public /* synthetic */ AppEvent(String jsonString, String operationalJsonString, boolean isImplicit, boolean inBackground, DefaultConstructorMarker $constructor_marker) {
        this(jsonString, operationalJsonString, isImplicit, inBackground);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/AppEvent$Companion;", "", "()V", "MAX_IDENTIFIER_LENGTH", "", "serialVersionUID", "", "validatedIdentifiers", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "validateIdentifier", "", "identifier", "facebook-core_release"})
    @SourceDebugExtension(value={"SMAP\nAppEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEvent.kt\ncom/facebook/appevents/AppEvent$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void validateIdentifier(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            String regex = "^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$";
            if (((CharSequence)identifier).length() == 0 || identifier.length() > 40) {
                Locale locale = Locale.ROOT;
                String string = "Identifier '%s' must be less than %d characters";
                Object[] objectArray = new Object[]{identifier, 40};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                throw new FacebookException(string2);
            }
            boolean alreadyValidated = false;
            Object object = validatedIdentifiers;
            synchronized (object) {
                boolean $i$a$-synchronized-AppEvent$Companion$validateIdentifier$32 = false;
                alreadyValidated = validatedIdentifiers.contains(identifier);
                Unit $i$a$-synchronized-AppEvent$Companion$validateIdentifier$32 = Unit.INSTANCE;
            }
            if (!alreadyValidated) {
                CharSequence charSequence = identifier;
                if (new Regex(regex).matches(charSequence)) {
                    object = validatedIdentifiers;
                    synchronized (object) {
                        boolean bl = false;
                        boolean bl2 = validatedIdentifiers.add(identifier);
                    }
                } else {
                    object = "Skipping event named '%s' due to illegal name - must be under 40 chars and alphanumeric, _, - or space, and not start with a space or hyphen.";
                    Object[] objectArray = new Object[]{identifier};
                    String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    throw new FacebookException(string);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/appevents/AppEvent$SerializationProxyV2;", "Ljava/io/Serializable;", "jsonString", "", "operationalJsonString", "isImplicit", "", "inBackground", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "readResolve", "", "Companion", "facebook-core_release"})
    public static final class SerializationProxyV2
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String jsonString;
        @NotNull
        private final String operationalJsonString;
        private final boolean isImplicit;
        private final boolean inBackground;
        private static final long serialVersionUID = 20160803001L;

        public SerializationProxyV2(@NotNull String jsonString, @NotNull String operationalJsonString, boolean isImplicit, boolean inBackground) {
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            Intrinsics.checkNotNullParameter((Object)operationalJsonString, (String)"operationalJsonString");
            this.jsonString = jsonString;
            this.operationalJsonString = operationalJsonString;
            this.isImplicit = isImplicit;
            this.inBackground = inBackground;
        }

        private final Object readResolve() throws JSONException, ObjectStreamException {
            return new AppEvent(this.jsonString, this.operationalJsonString, this.isImplicit, this.inBackground, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/appevents/AppEvent$SerializationProxyV2$Companion;", "", "()V", "serialVersionUID", "", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

