/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.Utility;
import com.facebook.internal.gatekeeper.GateKeeper;
import com.facebook.internal.gatekeeper.GateKeeperRuntimeCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u001fH\u0007J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004J\u0017\u0010$\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020'J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0007J\u001f\u0010)\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0015H\u0001\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020'H\u0002J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u001fH\u0007J\b\u0010/\u001a\u00020'H\u0007J\u001a\u00100\u001a\u00020'2\b\b\u0002\u0010\u001d\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u00064"}, d2={"Lcom/facebook/internal/FetchedAppGateKeepersManager;", "", "()V", "APPLICATION_FIELDS", "", "APPLICATION_GATEKEEPER_CACHE_TIMEOUT", "", "APPLICATION_GATEKEEPER_EDGE", "APPLICATION_GATEKEEPER_FIELD", "APPLICATION_GRAPH_DATA", "APPLICATION_PLATFORM", "APPLICATION_SDK_VERSION", "APP_GATEKEEPERS_PREFS_KEY_FORMAT", "APP_GATEKEEPERS_PREFS_STORE", "APP_PLATFORM", "TAG", "callbacks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/facebook/internal/FetchedAppGateKeepersManager$Callback;", "fetchedAppGateKeepers", "", "Lorg/json/JSONObject;", "gateKeeperRuntimeCache", "Lcom/facebook/internal/gatekeeper/GateKeeperRuntimeCache;", "isLoading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "timestamp", "Ljava/lang/Long;", "getAppGateKeepersQueryResponse", "applicationId", "getGateKeeperForKey", "", "name", "defaultValue", "getGateKeepersForApplication", "", "isTimestampValid", "(Ljava/lang/Long;)Z", "loadAppGateKeepersAsync", "", "callback", "parseAppGateKeepersFromJSON", "gateKeepersJSON", "parseAppGateKeepersFromJSON$facebook_core_release", "pollCallbacks", "queryAppGateKeepers", "forceRequery", "resetRuntimeGateKeeperCache", "setRuntimeGateKeeper", "gateKeeper", "Lcom/facebook/internal/gatekeeper/GateKeeper;", "Callback", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nFetchedAppGateKeepersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchedAppGateKeepersManager.kt\ncom/facebook/internal/FetchedAppGateKeepersManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,261:1\n1855#2,2:262\n125#3:264\n152#3,3:265\n*S KotlinDebug\n*F\n+ 1 FetchedAppGateKeepersManager.kt\ncom/facebook/internal/FetchedAppGateKeepersManager\n*L\n158#1:262,2\n169#1:264\n169#1:265,3\n*E\n"})
public final class FetchedAppGateKeepersManager {
    @NotNull
    public static final FetchedAppGateKeepersManager INSTANCE = new FetchedAppGateKeepersManager();
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(FetchedAppGateKeepersManager.class).getSimpleName();
    @NotNull
    private static final String APP_GATEKEEPERS_PREFS_STORE = "com.facebook.internal.preferences.APP_GATEKEEPERS";
    @NotNull
    private static final String APP_GATEKEEPERS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_GATEKEEPERS.%s";
    @NotNull
    private static final String APP_PLATFORM = "android";
    @NotNull
    private static final String APPLICATION_GATEKEEPER_EDGE = "mobile_sdk_gk";
    @NotNull
    private static final String APPLICATION_GATEKEEPER_FIELD = "gatekeepers";
    @NotNull
    private static final String APPLICATION_GRAPH_DATA = "data";
    @NotNull
    private static final String APPLICATION_FIELDS = "fields";
    @NotNull
    private static final String APPLICATION_PLATFORM = "platform";
    @NotNull
    private static final String APPLICATION_SDK_VERSION = "sdk_version";
    @NotNull
    private static final AtomicBoolean isLoading = new AtomicBoolean(false);
    @NotNull
    private static final ConcurrentLinkedQueue<Callback> callbacks = new ConcurrentLinkedQueue();
    @NotNull
    private static final Map<String, JSONObject> fetchedAppGateKeepers = new ConcurrentHashMap();
    private static final long APPLICATION_GATEKEEPER_CACHE_TIMEOUT = 3600000L;
    @Nullable
    private static Long timestamp;
    @Nullable
    private static GateKeeperRuntimeCache gateKeeperRuntimeCache;

    private FetchedAppGateKeepersManager() {
    }

    public final void loadAppGateKeepersAsync() {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(null);
    }

    @JvmStatic
    public static final synchronized void loadAppGateKeepersAsync(@Nullable Callback callback2) {
        if (callback2 != null) {
            callbacks.add(callback2);
        }
        String applicationId = FacebookSdk.getApplicationId();
        if (INSTANCE.isTimestampValid(timestamp) && fetchedAppGateKeepers.containsKey(applicationId)) {
            INSTANCE.pollCallbacks();
            return;
        }
        Context context = FacebookSdk.getApplicationContext();
        String string = APP_GATEKEEPERS_PREFS_KEY_FORMAT;
        Object[] objectArray = new Object[]{applicationId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String gateKeepersKey = string2;
        if (context == null) {
            return;
        }
        SharedPreferences gateKeepersSharedPrefs = context.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0);
        String gateKeepersJSONString = gateKeepersSharedPrefs.getString(gateKeepersKey, null);
        if (!Utility.isNullOrEmpty(gateKeepersJSONString)) {
            JSONObject gateKeepersJSON = null;
            try {
                gateKeepersJSON = new JSONObject(gateKeepersJSONString);
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
            if (gateKeepersJSON != null) {
                FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON$facebook_core_release(applicationId, gateKeepersJSON);
            }
        }
        Executor executor2 = FacebookSdk.getExecutor();
        if (executor2 == null) {
            return;
        }
        Executor executor3 = executor2;
        if (!isLoading.compareAndSet(false, true)) {
            return;
        }
        executor3.execute(() -> FetchedAppGateKeepersManager.loadAppGateKeepersAsync$lambda$0(applicationId, context, gateKeepersKey));
    }

    private final void pollCallbacks() {
        Handler handler = new Handler(Looper.getMainLooper());
        while (!callbacks.isEmpty()) {
            Callback callback2 = callbacks.poll();
            if (callback2 == null) continue;
            handler.post(() -> FetchedAppGateKeepersManager.pollCallbacks$lambda$1(callback2));
        }
    }

    @JvmStatic
    @NotNull
    public static final JSONObject queryAppGateKeepers(@NotNull String applicationId, boolean forceRequery) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        if (!forceRequery && fetchedAppGateKeepers.containsKey(applicationId)) {
            JSONObject jSONObject = fetchedAppGateKeepers.get(applicationId);
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            return jSONObject;
        }
        JSONObject response = INSTANCE.getAppGateKeepersQueryResponse(applicationId);
        Context context = FacebookSdk.getApplicationContext();
        String string = APP_GATEKEEPERS_PREFS_KEY_FORMAT;
        Object[] objectArray = new Object[]{applicationId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String gateKeepersKey = string2;
        SharedPreferences gateKeepersSharedPrefs = context.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0);
        gateKeepersSharedPrefs.edit().putString(gateKeepersKey, response.toString()).apply();
        return FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON$facebook_core_release(applicationId, response);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Boolean> getGateKeepersForApplication(@Nullable String applicationId) {
        Map map;
        List<GateKeeper> cacheList;
        this.loadAppGateKeepersAsync();
        if (applicationId == null || !fetchedAppGateKeepers.containsKey(applicationId)) {
            return new HashMap();
        }
        GateKeeperRuntimeCache gateKeeperRuntimeCache = FetchedAppGateKeepersManager.gateKeeperRuntimeCache;
        List<GateKeeper> list = cacheList = gateKeeperRuntimeCache != null ? gateKeeperRuntimeCache.dumpGateKeepers(applicationId) : null;
        if (cacheList != null) {
            HashMap cacheMap = new HashMap();
            Iterable $this$forEach$iv = cacheList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GateKeeper it = (GateKeeper)element$iv;
                boolean bl = false;
                ((Map)cacheMap).put(it.getName(), it.getValue());
            }
            map = cacheMap;
        } else {
            void var3_4;
            Collection<GateKeeper> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map output = new HashMap();
            JSONObject jSONObject = fetchedAppGateKeepers.get(applicationId);
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            JSONObject jsonObject = jSONObject;
            Iterator jsonIterator = jsonObject.keys();
            while (jsonIterator.hasNext()) {
                String key = (String)jsonIterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                output.put(key, jsonObject.optBoolean(key));
            }
            GateKeeperRuntimeCache gateKeeperRuntimeCache2 = FetchedAppGateKeepersManager.gateKeeperRuntimeCache;
            if (gateKeeperRuntimeCache2 == null) {
                gateKeeperRuntimeCache2 = new GateKeeperRuntimeCache();
            }
            GateKeeperRuntimeCache runtimeCache = gateKeeperRuntimeCache2;
            Map element$iv = output;
            String string = applicationId;
            GateKeeperRuntimeCache gateKeeperRuntimeCache3 = runtimeCache;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new GateKeeper((String)it.getKey(), (Boolean)it.getValue()));
            }
            collection = (List)destination$iv$iv;
            gateKeeperRuntimeCache3.setGateKeepers(string, (List<GateKeeper>)collection);
            FetchedAppGateKeepersManager.gateKeeperRuntimeCache = runtimeCache;
            map = var3_4;
        }
        return map;
    }

    @JvmStatic
    public static final boolean getGateKeeperForKey(@NotNull String name, @Nullable String applicationId, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Boolean> map = INSTANCE.getGateKeepersForApplication(applicationId);
        if (!map.containsKey(name)) {
            bl = defaultValue;
        } else {
            Boolean bl2 = map.get(name);
            if (bl2 != null) {
                bl = bl2;
            } else {
                return defaultValue;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final void setRuntimeGateKeeper(@NotNull String applicationId, @NotNull GateKeeper gateKeeper) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)gateKeeper, (String)"gateKeeper");
        GateKeeperRuntimeCache gateKeeperRuntimeCache = FetchedAppGateKeepersManager.gateKeeperRuntimeCache;
        if ((gateKeeperRuntimeCache != null ? gateKeeperRuntimeCache.getGateKeeper(applicationId, gateKeeper.getName()) : null) != null) {
            GateKeeperRuntimeCache gateKeeperRuntimeCache2 = FetchedAppGateKeepersManager.gateKeeperRuntimeCache;
            if (gateKeeperRuntimeCache2 != null) {
                gateKeeperRuntimeCache2.setGateKeeper(applicationId, gateKeeper);
            }
        } else {
            Log.w((String)TAG, (String)"Missing gatekeeper runtime cache");
        }
    }

    public static /* synthetic */ void setRuntimeGateKeeper$default(String string, GateKeeper gateKeeper, int n, Object object) {
        if ((n & 1) != 0) {
            string = FacebookSdk.getApplicationId();
        }
        FetchedAppGateKeepersManager.setRuntimeGateKeeper(string, gateKeeper);
    }

    @JvmStatic
    public static final void resetRuntimeGateKeeperCache() {
        block0: {
            GateKeeperRuntimeCache gateKeeperRuntimeCache = FetchedAppGateKeepersManager.gateKeeperRuntimeCache;
            if (gateKeeperRuntimeCache == null) break block0;
            GateKeeperRuntimeCache.resetCache$default(gateKeeperRuntimeCache, null, 1, null);
        }
    }

    private final JSONObject getAppGateKeepersQueryResponse(String applicationId) {
        Bundle appGateKeepersParams = new Bundle();
        appGateKeepersParams.putString(APPLICATION_PLATFORM, APP_PLATFORM);
        appGateKeepersParams.putString(APPLICATION_SDK_VERSION, FacebookSdk.getSdkVersion());
        appGateKeepersParams.putString(APPLICATION_FIELDS, APPLICATION_GATEKEEPER_FIELD);
        String string = "app/%s";
        Object[] objectArray = new Object[]{APPLICATION_GATEKEEPER_EDGE};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        GraphRequest request = GraphRequest.Companion.newGraphPathRequest(null, string2, null);
        request.setParameters(appGateKeepersParams);
        JSONObject jSONObject = request.executeAndWait().getJsonObject();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    @JvmStatic
    @VisibleForTesting(otherwise=2)
    @NotNull
    public static final synchronized JSONObject parseAppGateKeepersFromJSON$facebook_core_release(@NotNull String applicationId, @Nullable JSONObject gateKeepersJSON) {
        JSONObject gateKeepers;
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject result;
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        JSONObject jSONObject3 = fetchedAppGateKeepers.get(applicationId);
        if (jSONObject3 == null) {
            jSONObject3 = result = new JSONObject();
        }
        if (((jSONObject2 = gateKeepersJSON) != null && (jSONObject2 = jSONObject2.optJSONArray(APPLICATION_GRAPH_DATA)) != null ? jSONObject2.optJSONObject(0) : (jSONObject = null)) == null) {
            jSONObject = new JSONObject();
        }
        if ((jSONArray = (gateKeepers = jSONObject).optJSONArray(APPLICATION_GATEKEEPER_FIELD)) == null) {
            jSONArray = new JSONArray();
        }
        JSONArray data = jSONArray;
        int n = data.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject gk = data.getJSONObject(i);
                result.put(gk.getString("key"), gk.getBoolean("value"));
                continue;
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
        }
        fetchedAppGateKeepers.put(applicationId, result);
        return result;
    }

    private final boolean isTimestampValid(Long timestamp) {
        return timestamp == null ? false : System.currentTimeMillis() - timestamp < 3600000L;
    }

    private static final void loadAppGateKeepersAsync$lambda$0(String $applicationId, Context $context, String $gateKeepersKey) {
        Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$gateKeepersKey, (String)"$gateKeepersKey");
        JSONObject gateKeepersResultJSON = INSTANCE.getAppGateKeepersQueryResponse($applicationId);
        if (gateKeepersResultJSON.length() != 0) {
            FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON$facebook_core_release($applicationId, gateKeepersResultJSON);
            SharedPreferences gateKeepersSharedPrefs = $context.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0);
            gateKeepersSharedPrefs.edit().putString($gateKeepersKey, gateKeepersResultJSON.toString()).apply();
            timestamp = System.currentTimeMillis();
        }
        INSTANCE.pollCallbacks();
        isLoading.set(false);
    }

    private static final void pollCallbacks$lambda$1(Callback $callback) {
        $callback.onCompleted();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/facebook/internal/FetchedAppGateKeepersManager$Callback;", "", "onCompleted", "", "facebook-core_release"})
    public static interface Callback {
        public void onCompleted();
    }
}

