/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\rH\u0002J$\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/appevents/internal/SessionLogger;", "", "()V", "INACTIVE_SECONDS_QUANTA", "", "TAG", "", "kotlin.jvm.PlatformType", "getQuantaIndex", "", "timeBetweenSessions", "", "logActivateApp", "", "activityName", "sourceApplicationInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "appId", "context", "Landroid/content/Context;", "logClockSkewEvent", "logDeactivateApp", "sessionInfo", "Lcom/facebook/appevents/internal/SessionInfo;", "facebook-core_release"})
public final class SessionLogger {
    @NotNull
    public static final SessionLogger INSTANCE = new SessionLogger();
    private static final String TAG = SessionLogger.class.getCanonicalName();
    @NotNull
    private static final long[] INACTIVE_SECONDS_QUANTA;

    private SessionLogger() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logActivateApp(@NotNull String string, @Nullable SourceApplicationInfo sourceApplicationInfo, @Nullable String string2, @NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            void sourceApplicationInfo2;
            void context2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            String string3 = sourceApplicationInfo2;
            if (string3 == null || (string3 = ((SourceApplicationInfo)((Object)string3)).toString()) == null) {
                string3 = "Unclassified";
            }
            String sourAppInfoStr = string3;
            Bundle eventParams = new Bundle();
            eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
            InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(activityName, (String)appId, null);
            logger.logEvent("fb_mobile_activate_app", eventParams);
            if (InternalAppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                logger.flush();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logDeactivateApp(@NotNull String string, @Nullable SessionInfo sessionInfo, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            long sessionLength;
            long interruptionDurationMillis;
            long l;
            void sessionInfo2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            if (sessionInfo2 == null) {
                return;
            }
            Long l2 = sessionInfo2.getDiskRestoreTime();
            if (l2 != null) {
                l = l2;
            } else {
                Long l3 = sessionInfo2.getSessionLastEventTime();
                l = interruptionDurationMillis = 0L - (l3 != null ? l3 : 0L);
            }
            if (interruptionDurationMillis < 0L) {
                interruptionDurationMillis = 0L;
                INSTANCE.logClockSkewEvent();
            }
            if ((sessionLength = sessionInfo2.getSessionLength()) < 0L) {
                INSTANCE.logClockSkewEvent();
                sessionLength = 0L;
            }
            Bundle eventParams = new Bundle();
            eventParams.putInt("fb_mobile_app_interruptions", sessionInfo2.getInterruptionCount());
            Locale locale = Locale.ROOT;
            String string3 = "session_quanta_%d";
            Object[] objectArray = new Object[1];
            objectArray[0] = SessionLogger.getQuantaIndex(interruptionDurationMillis);
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            eventParams.putString("fb_mobile_time_between_sessions", string4);
            SourceApplicationInfo sourceApplicationInfo = sessionInfo2.getSourceApplicationInfo();
            Object object = sourceApplicationInfo;
            if (object == null || (object = ((SourceApplicationInfo)object).toString()) == null) {
                object = "Unclassified";
            }
            Object sourAppInfoStr = object;
            eventParams.putString("fb_mobile_launch_source", (String)sourAppInfoStr);
            Long l4 = sessionInfo2.getSessionLastEventTime();
            eventParams.putLong("_logTime", (l4 != null ? l4 : 0L) / (long)1000);
            InternalAppEventsLogger.Companion.createInstance(activityName, (String)appId, null).logEvent("fb_mobile_deactivate_app", (double)sessionLength / (double)1000L, eventParams);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    private final void logClockSkewEvent() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String string = TAG;
            Intrinsics.checkNotNull((Object)string);
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, "Clock skew detected");
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final int getQuantaIndex(long l) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return 0;
        }
        try {
            long timeBetweenSessions;
            int quantaIndex;
            for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
            }
            return quantaIndex;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return 0;
        }
    }

    static {
        long[] lArray = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};
        INACTIVE_SECONDS_QUANTA = lArray;
    }
}

