/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.OperationalData;
import com.facebook.appevents.OperationalDataEnum;
import com.facebook.appevents.iap.InAppPurchase;
import com.facebook.appevents.iap.InAppPurchaseDedupeConfig;
import com.facebook.appevents.iap.InAppPurchaseEventManager;
import com.facebook.appevents.iap.InAppPurchaseManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J*\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J>\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J0\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J \u0010\u001e\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020#H\u0007J\u001a\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0007J4\u0010(\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010)\u001a\u00020!2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010*\u001a\u00020!H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger;", "", "()V", "APP_EVENTS_IF_AUTO_LOG_SUBS", "", "TAG", "kotlin.jvm.PlatformType", "internalAppEventsLogger", "Lcom/facebook/appevents/InternalAppEventsLogger;", "getPurchaseDedupeParameters", "Landroid/os/Bundle;", "purchaseLoggingParametersList", "", "Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger$PurchaseLoggingParameters;", "getPurchaseLoggingParameters", "purchase", "skuDetails", "billingClientVersion", "Lcom/facebook/appevents/iap/InAppPurchaseUtils$BillingClientVersion;", "extraParameter", "", "getPurchaseParametersGPBLV2V4", "type", "params", "operationalData", "Lcom/facebook/appevents/OperationalData;", "purchaseJSON", "Lorg/json/JSONObject;", "skuDetailsJSON", "getPurchaseParametersGPBLV5V7", "getSubscriptionDedupeParameters", "eventName", "isImplicitPurchaseLoggingEnabled", "", "logActivateAppEvent", "", "logActivityTimeSpentEvent", "activityName", "timeSpentInSeconds", "", "logPurchase", "isSubscription", "isFirstAppLaunch", "PurchaseLoggingParameters", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nAutomaticAnalyticsLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticAnalyticsLogger.kt\ncom/facebook/appevents/internal/AutomaticAnalyticsLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,532:1\n1549#2:533\n1620#2,3:534\n215#3,2:537\n*S KotlinDebug\n*F\n+ 1 AutomaticAnalyticsLogger.kt\ncom/facebook/appevents/internal/AutomaticAnalyticsLogger\n*L\n198#1:533\n198#1:534,3\n480#1:537,2\n*E\n"})
public final class AutomaticAnalyticsLogger {
    @NotNull
    public static final AutomaticAnalyticsLogger INSTANCE = new AutomaticAnalyticsLogger();
    private static final String TAG = AutomaticAnalyticsLogger.class.getCanonicalName();
    @NotNull
    private static final String APP_EVENTS_IF_AUTO_LOG_SUBS = "app_events_if_auto_log_subs";
    @NotNull
    private static final InternalAppEventsLogger internalAppEventsLogger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());

    private AutomaticAnalyticsLogger() {
    }

    @JvmStatic
    public static final void logActivateAppEvent() {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        boolean autoLogAppEvents = FacebookSdk.getAutoLogAppEventsEnabled();
        if (autoLogAppEvents) {
            if (context instanceof Application) {
                AppEventsLogger.Companion.activateApp((Application)context, appId);
            } else {
                Log.w((String)TAG, (String)"Automatic logging of basic events will not happen, because FacebookSdk.getApplicationContext() returns object that is not instance of android.app.Application. Make sure you call FacebookSdk.sdkInitialize() from Application class and pass application context.");
            }
        }
    }

    @JvmStatic
    public static final void logActivityTimeSpentEvent(@Nullable String activityName, long timeSpentInSeconds) {
        Context context = FacebookSdk.getApplicationContext();
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(appId, false);
        if (settings != null && settings.getAutomaticLoggingEnabled() && timeSpentInSeconds > 0L) {
            InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
            Bundle params = new Bundle(1);
            params.putCharSequence("fb_aa_time_spent_view_name", (CharSequence)activityName);
            logger.logEvent("fb_aa_time_spent_on_view", timeSpentInSeconds, params);
        }
    }

    @JvmStatic
    public static final void logPurchase(@NotNull String purchase, @NotNull String skuDetails, boolean isSubscription, @Nullable InAppPurchaseUtils.BillingClientVersion billingClientVersion, boolean isFirstAppLaunch) {
        String eventName;
        boolean logAsSubs;
        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
        Intrinsics.checkNotNullParameter((Object)skuDetails, (String)"skuDetails");
        if (!INSTANCE.isImplicitPurchaseLoggingEnabled()) {
            return;
        }
        List<PurchaseLoggingParameters> list = INSTANCE.getPurchaseLoggingParameters(purchase, skuDetails, billingClientVersion);
        if (list == null) {
            return;
        }
        List<PurchaseLoggingParameters> loggingParameters = list;
        if (loggingParameters.isEmpty()) {
            return;
        }
        boolean bl = logAsSubs = isSubscription && FetchedAppGateKeepersManager.getGateKeeperForKey(APP_EVENTS_IF_AUTO_LOG_SUBS, FacebookSdk.getApplicationId(), false);
        String string = logAsSubs ? (isFirstAppLaunch ? "SubscriptionRestore" : (InAppPurchaseEventManager.INSTANCE.hasFreeTrialPeirod(skuDetails) ? "StartTrial" : "Subscribe")) : (eventName = isFirstAppLaunch ? "fb_mobile_purchase_restored" : "fb_mobile_purchase");
        Bundle dedupeParameters = isSubscription && FeatureManager.isEnabled(FeatureManager.Feature.AndroidManualImplicitSubsDedupe) ? AutomaticAnalyticsLogger.getSubscriptionDedupeParameters(loggingParameters, eventName) : (!isSubscription && FeatureManager.isEnabled(FeatureManager.Feature.AndroidManualImplicitPurchaseDedupe) ? AutomaticAnalyticsLogger.getPurchaseDedupeParameters(loggingParameters) : null);
        InAppPurchaseDedupeConfig.INSTANCE.addDedupeParameters(dedupeParameters, loggingParameters.get(0).getParam(), loggingParameters.get(0).getOperationalData());
        if (!Intrinsics.areEqual((Object)eventName, (Object)"fb_mobile_purchase")) {
            internalAppEventsLogger.logEventImplicitly(eventName, loggingParameters.get(0).getPurchaseAmount(), loggingParameters.get(0).getCurrency(), loggingParameters.get(0).getParam(), loggingParameters.get(0).getOperationalData());
        } else {
            internalAppEventsLogger.logPurchaseImplicitly(loggingParameters.get(0).getPurchaseAmount(), loggingParameters.get(0).getCurrency(), loggingParameters.get(0).getParam(), loggingParameters.get(0).getOperationalData());
        }
    }

    public static /* synthetic */ void logPurchase$default(String string, String string2, boolean bl, InAppPurchaseUtils.BillingClientVersion billingClientVersion, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        AutomaticAnalyticsLogger.logPurchase(string, string2, bl, billingClientVersion, bl2);
    }

    @JvmStatic
    @Nullable
    public static final synchronized Bundle getPurchaseDedupeParameters(@NotNull List<PurchaseLoggingParameters> purchaseLoggingParametersList) {
        Intrinsics.checkNotNullParameter(purchaseLoggingParametersList, (String)"purchaseLoggingParametersList");
        PurchaseLoggingParameters purchaseParams = purchaseLoggingParametersList.get(0);
        InAppPurchase inAppPurchase = new InAppPurchase("fb_mobile_purchase", purchaseParams.getPurchaseAmount().doubleValue(), purchaseParams.getCurrency());
        return InAppPurchaseManager.performDedupe(CollectionsKt.listOf((Object)inAppPurchase), System.currentTimeMillis(), true, CollectionsKt.listOf((Object)new Pair((Object)purchaseParams.getParam(), (Object)purchaseParams.getOperationalData())));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final synchronized Bundle getSubscriptionDedupeParameters(@NotNull List<PurchaseLoggingParameters> purchaseLoggingParametersList, @NotNull String eventName) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        InAppPurchase inAppPurchase;
        Intrinsics.checkNotNullParameter(purchaseLoggingParametersList, (String)"purchaseLoggingParametersList");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        ArrayList<InAppPurchase> purchasesToDedupe = new ArrayList<InAppPurchase>();
        for (PurchaseLoggingParameters purchaseParams : purchaseLoggingParametersList) {
            inAppPurchase = new InAppPurchase(eventName, purchaseParams.getPurchaseAmount().doubleValue(), purchaseParams.getCurrency());
            purchasesToDedupe.add(inAppPurchase);
        }
        Iterable iterable = purchaseLoggingParametersList;
        boolean bl = true;
        long l = System.currentTimeMillis();
        List list = purchasesToDedupe;
        boolean $i$f$map = false;
        inAppPurchase = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PurchaseLoggingParameters purchaseLoggingParameters = (PurchaseLoggingParameters)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new Pair((Object)it.getParam(), (Object)it.getOperationalData()));
        }
        collection = (List)destination$iv$iv;
        return InAppPurchaseManager.performDedupe(list, l, bl, (List<Pair<Bundle, OperationalData>>)collection);
    }

    @JvmStatic
    public static final boolean isImplicitPurchaseLoggingEnabled() {
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        return settings != null && FacebookSdk.getAutoLogAppEventsEnabled() && settings.getIAPAutomaticLoggingEnabled();
    }

    private final List<PurchaseLoggingParameters> getPurchaseLoggingParameters(String purchase, String skuDetails, InAppPurchaseUtils.BillingClientVersion billingClientVersion) {
        return this.getPurchaseLoggingParameters(purchase, skuDetails, new HashMap(), billingClientVersion);
    }

    private final PurchaseLoggingParameters getPurchaseParametersGPBLV2V4(String type, Bundle params, OperationalData operationalData, JSONObject purchaseJSON, JSONObject skuDetailsJSON) {
        if (Intrinsics.areEqual((Object)type, (Object)InAppPurchaseUtils.IAPProductType.SUBS.getType())) {
            String string = Boolean.toString(purchaseJSON.optBoolean("autoRenewing", false));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(\n              \u2026      )\n                )");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_subs_auto_renewing", string, params, operationalData);
            String string2 = skuDetailsJSON.optString("subscriptionPeriod");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"skuDetailsJSON.optString\u2026_IAP_SUBSCRIPTION_PERIOD)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_subs_period", string2, params, operationalData);
            String string3 = skuDetailsJSON.optString("freeTrialPeriod");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"skuDetailsJSON.optString\u2026GP_IAP_FREE_TRIAL_PERIOD)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_free_trial_period", string3, params, operationalData);
            String introductoryPriceCycles = skuDetailsJSON.optString("introductoryPriceCycles");
            Intrinsics.checkNotNullExpressionValue((Object)introductoryPriceCycles, (String)"introductoryPriceCycles");
            if (((CharSequence)introductoryPriceCycles).length() > 0) {
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_intro_price_cycles", introductoryPriceCycles, params, operationalData);
            }
            String introductoryPricePeriod = skuDetailsJSON.optString("introductoryPricePeriod");
            Intrinsics.checkNotNullExpressionValue((Object)introductoryPricePeriod, (String)"introductoryPricePeriod");
            if (((CharSequence)introductoryPricePeriod).length() > 0) {
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_intro_period", introductoryPricePeriod, params, operationalData);
            }
            String introductoryPriceAmountMicros = skuDetailsJSON.optString("introductoryPriceAmountMicros");
            Intrinsics.checkNotNullExpressionValue((Object)introductoryPriceAmountMicros, (String)"introductoryPriceAmountMicros");
            if (((CharSequence)introductoryPriceAmountMicros).length() > 0) {
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_intro_price_amount_micros", introductoryPriceAmountMicros, params, operationalData);
            }
        }
        BigDecimal bigDecimal = new BigDecimal((double)skuDetailsJSON.getLong("price_amount_micros") / 1000000.0);
        Currency currency = Currency.getInstance(skuDetailsJSON.getString("price_currency_code"));
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(skuDetailsJS\u2026RICE_CURRENCY_CODE_V2V4))");
        return new PurchaseLoggingParameters(bigDecimal, currency, params, operationalData);
    }

    private final List<PurchaseLoggingParameters> getPurchaseParametersGPBLV5V7(String type, Bundle params, OperationalData operationalData, JSONObject skuDetailsJSON) {
        if (Intrinsics.areEqual((Object)type, (Object)InAppPurchaseUtils.IAPProductType.SUBS.getType())) {
            List subscriptionParametersList = new ArrayList();
            JSONArray jSONArray = skuDetailsJSON.getJSONArray("subscriptionOfferDetails");
            if (jSONArray == null) {
                return null;
            }
            JSONArray subscriptionOfferDetailsJSONArray = jSONArray;
            int numberOfBasePlans = subscriptionOfferDetailsJSONArray.length();
            for (int index = 0; index < numberOfBasePlans; ++index) {
                JSONObject subscriptionJSON;
                JSONObject jSONObject = skuDetailsJSON.getJSONArray("subscriptionOfferDetails").getJSONObject(index);
                if (jSONObject == null) {
                    return null;
                }
                JSONObject subscriptionOfferDetailsJSON = jSONObject;
                Bundle planSpecificBundle = new Bundle(params);
                OperationalData planSpecificOperationalData = operationalData.copy();
                String basePlanId = subscriptionOfferDetailsJSON.getString("basePlanId");
                Intrinsics.checkNotNullExpressionValue((Object)basePlanId, (String)"basePlanId");
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_base_plan", basePlanId, planSpecificBundle, planSpecificOperationalData);
                JSONArray pricingPhases = subscriptionOfferDetailsJSON.getJSONArray("pricingPhases");
                if (pricingPhases.getJSONObject(pricingPhases.length() - 1) == null) {
                    return null;
                }
                String string = subscriptionJSON.optString("billingPeriod");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"subscriptionJSON.optStri\u2026IOD\n                    )");
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_subs_period", string, planSpecificBundle, planSpecificOperationalData);
                if (subscriptionJSON.has("recurrenceMode") && subscriptionJSON.getInt("recurrenceMode") != 3) {
                    OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_subs_auto_renewing", "true", planSpecificBundle, planSpecificOperationalData);
                } else {
                    OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_subs_auto_renewing", "false", planSpecificBundle, planSpecificOperationalData);
                }
                BigDecimal bigDecimal = new BigDecimal((double)subscriptionJSON.getLong("priceAmountMicros") / 1000000.0);
                Currency currency = Currency.getInstance(subscriptionJSON.getString("priceCurrencyCode"));
                Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(subscription\u2026RICE_CURRENCY_CODE_V5V7))");
                subscriptionParametersList.add(new PurchaseLoggingParameters(bigDecimal, currency, planSpecificBundle, planSpecificOperationalData));
            }
            return subscriptionParametersList;
        }
        Object[] objectArray = skuDetailsJSON.getJSONObject("oneTimePurchaseOfferDetails");
        if (objectArray == null) {
            return null;
        }
        Object[] oneTimePurchaseOfferDetailsJSON = objectArray;
        objectArray = new PurchaseLoggingParameters[1];
        BigDecimal bigDecimal = new BigDecimal((double)oneTimePurchaseOfferDetailsJSON.getLong("priceAmountMicros") / 1000000.0);
        Currency currency = Currency.getInstance(oneTimePurchaseOfferDetailsJSON.getString("priceCurrencyCode"));
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(oneTimePurch\u2026RICE_CURRENCY_CODE_V5V7))");
        objectArray[0] = new PurchaseLoggingParameters(bigDecimal, currency, params, operationalData);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private final List<PurchaseLoggingParameters> getPurchaseLoggingParameters(String purchase, String skuDetails, Map<String, String> extraParameter, InAppPurchaseUtils.BillingClientVersion billingClientVersion) {
        try {
            List list;
            JSONObject purchaseJSON = new JSONObject(purchase);
            JSONObject skuDetailsJSON = new JSONObject(skuDetails);
            Bundle params = new Bundle(1);
            OperationalData operationalData = new OperationalData();
            if (billingClientVersion != null) {
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_sdk_supported_library_versions", billingClientVersion.getType(), params, operationalData);
            }
            String string = purchaseJSON.getString("productId");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"purchaseJSON.getString(C\u2026stants.GP_IAP_PRODUCT_ID)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_product_id", string, params, operationalData);
            String string2 = purchaseJSON.getString("productId");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchaseJSON.getString(C\u2026stants.GP_IAP_PRODUCT_ID)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_content_id", string2, params, operationalData);
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "android_dynamic_ads_content_id", "client_implicit", params, operationalData);
            String string3 = purchaseJSON.getString("purchaseTime");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"purchaseJSON.getString(C\u2026nts.GP_IAP_PURCHASE_TIME)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_purchase_time", string3, params, operationalData);
            String string4 = purchaseJSON.getString("purchaseToken");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"purchaseJSON.getString(C\u2026ts.GP_IAP_PURCHASE_TOKEN)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_purchase_token", string4, params, operationalData);
            String string5 = purchaseJSON.optString("packageName");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"purchaseJSON.optString(C\u2026ants.GP_IAP_PACKAGE_NAME)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_package_name", string5, params, operationalData);
            String string6 = skuDetailsJSON.optString("title");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"skuDetailsJSON.optString(Constants.GP_IAP_TITLE)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_product_title", string6, params, operationalData);
            String string7 = skuDetailsJSON.optString("description");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"skuDetailsJSON.optString\u2026tants.GP_IAP_DESCRIPTION)");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_product_description", string7, params, operationalData);
            String type = skuDetailsJSON.optString("type");
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_product_type", type, params, operationalData);
            String specificBillingLibraryVersion = InAppPurchaseManager.getSpecificBillingLibraryVersion();
            if (specificBillingLibraryVersion != null) {
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, "fb_iap_client_library_version", specificBillingLibraryVersion, params, operationalData);
            }
            Map<String, String> $this$forEach$iv = extraParameter;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                OperationalData.Companion.addParameter(OperationalDataEnum.IAPParameters, k, v, params, operationalData);
            }
            if (skuDetailsJSON.has("price_amount_micros")) {
                Object[] objectArray = new PurchaseLoggingParameters[]{this.getPurchaseParametersGPBLV2V4(type, params, operationalData, purchaseJSON, skuDetailsJSON)};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
            } else {
                list = skuDetailsJSON.has("subscriptionOfferDetails") || skuDetailsJSON.has("oneTimePurchaseOfferDetails") ? this.getPurchaseParametersGPBLV5V7(type, params, operationalData, skuDetailsJSON) : null;
            }
            return list;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error parsing in-app purchase/subscription data.", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to get purchase logging parameters,", (Throwable)e);
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/facebook/appevents/internal/AutomaticAnalyticsLogger$PurchaseLoggingParameters;", "", "purchaseAmount", "Ljava/math/BigDecimal;", "currency", "Ljava/util/Currency;", "param", "Landroid/os/Bundle;", "operationalData", "Lcom/facebook/appevents/OperationalData;", "(Ljava/math/BigDecimal;Ljava/util/Currency;Landroid/os/Bundle;Lcom/facebook/appevents/OperationalData;)V", "getCurrency", "()Ljava/util/Currency;", "setCurrency", "(Ljava/util/Currency;)V", "getOperationalData", "()Lcom/facebook/appevents/OperationalData;", "setOperationalData", "(Lcom/facebook/appevents/OperationalData;)V", "getParam", "()Landroid/os/Bundle;", "setParam", "(Landroid/os/Bundle;)V", "getPurchaseAmount", "()Ljava/math/BigDecimal;", "setPurchaseAmount", "(Ljava/math/BigDecimal;)V", "facebook-core_release"})
    public static final class PurchaseLoggingParameters {
        @NotNull
        private BigDecimal purchaseAmount;
        @NotNull
        private Currency currency;
        @NotNull
        private Bundle param;
        @NotNull
        private OperationalData operationalData;

        public PurchaseLoggingParameters(@NotNull BigDecimal purchaseAmount, @NotNull Currency currency, @NotNull Bundle param, @NotNull OperationalData operationalData) {
            Intrinsics.checkNotNullParameter((Object)purchaseAmount, (String)"purchaseAmount");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            Intrinsics.checkNotNullParameter((Object)operationalData, (String)"operationalData");
            this.purchaseAmount = purchaseAmount;
            this.currency = currency;
            this.param = param;
            this.operationalData = operationalData;
        }

        @NotNull
        public final BigDecimal getPurchaseAmount() {
            return this.purchaseAmount;
        }

        public final void setPurchaseAmount(@NotNull BigDecimal bigDecimal) {
            Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"<set-?>");
            this.purchaseAmount = bigDecimal;
        }

        @NotNull
        public final Currency getCurrency() {
            return this.currency;
        }

        public final void setCurrency(@NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"<set-?>");
            this.currency = currency;
        }

        @NotNull
        public final Bundle getParam() {
            return this.param;
        }

        public final void setParam(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"<set-?>");
            this.param = bundle;
        }

        @NotNull
        public final OperationalData getOperationalData() {
            return this.operationalData;
        }

        public final void setOperationalData(@NotNull OperationalData operationalData) {
            Intrinsics.checkNotNullParameter((Object)operationalData, (String)"<set-?>");
            this.operationalData = operationalData;
        }
    }
}

