/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Patterns;
import android.view.View;
import android.widget.TextView;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/codeless/internal/SensitiveUserDataUtils;", "", "()V", "isCreditCard", "", "view", "Landroid/widget/TextView;", "isEmail", "isPassword", "isPersonName", "isPhoneNumber", "isPostalAddress", "isSensitiveUserData", "Landroid/view/View;", "facebook-core_release"})
public final class SensitiveUserDataUtils {
    @NotNull
    public static final SensitiveUserDataUtils INSTANCE = new SensitiveUserDataUtils();

    private SensitiveUserDataUtils() {
    }

    @JvmStatic
    public static final boolean isSensitiveUserData(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(SensitiveUserDataUtils.class)) {
            return false;
        }
        try {
            View view2;
            if (view2 instanceof TextView) {
                return INSTANCE.isPassword((TextView)view2) || INSTANCE.isCreditCard((TextView)view2) || INSTANCE.isPersonName((TextView)view2) || INSTANCE.isPostalAddress((TextView)view2) || INSTANCE.isPhoneNumber((TextView)view2) || INSTANCE.isEmail((TextView)view2);
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SensitiveUserDataUtils.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPassword(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            int inputType = view.getInputType();
            if (inputType == 128) {
                return true;
            }
            TransformationMethod method = view.getTransformationMethod();
            return method instanceof PasswordTransformationMethod;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEmail(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            int inputType = view.getInputType();
            if (inputType == 32) {
                return true;
            }
            String text = ViewHierarchy.getTextOfView((View)view);
            return text == null || ((CharSequence)text).length() == 0 ? false : Patterns.EMAIL_ADDRESS.matcher(text).matches();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPersonName(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            int inputType = view.getInputType();
            return inputType == 96;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPostalAddress(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            int inputType = view.getInputType();
            return inputType == 112;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPhoneNumber(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            int inputType = view.getInputType();
            return inputType == 3;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCreditCard(TextView textView) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view;
            CharSequence charSequence = ViewHierarchy.getTextOfView((View)view);
            Regex regex = new Regex("\\s");
            String string = "";
            String ccNumber = regex.replace(charSequence, string);
            int length = ccNumber.length();
            if (length < 12 || length > 19) {
                return false;
            }
            int sum = 0;
            boolean alternate = false;
            for (int i = length - 1; -1 < i; --i) {
                char digit = ccNumber.charAt(i);
                if (!Character.isDigit(digit)) {
                    return false;
                }
                int n = CharsKt.digitToInt((char)digit);
                if (alternate && (n *= 2) > 9) {
                    n = n % 10 + 1;
                }
                sum += n;
                alternate = !alternate;
            }
            return sum % 10 == 0;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }
}

