/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.cloudbridge;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.cloudbridge.AppEventsConversionsAPITransformerWebRequests;
import com.facebook.appevents.cloudbridge.SettingsAPIFields;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR@\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e8A@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/facebook/appevents/cloudbridge/AppEventsCAPIManager;", "", "()V", "SETTINGS_PATH", "", "TAG", "kotlin.jvm.PlatformType", "isEnabled", "", "isEnabled$facebook_core_release", "()Z", "setEnabled$facebook_core_release", "(Z)V", "valuesToSave", "", "savedCloudBridgeCredentials", "getSavedCloudBridgeCredentials$facebook_core_release", "()Ljava/util/Map;", "setSavedCloudBridgeCredentials$facebook_core_release", "(Ljava/util/Map;)V", "enable", "", "getCAPIGSettingsFromGraphResponse", "response", "Lcom/facebook/GraphResponse;", "getCAPIGSettingsFromGraphResponse$facebook_core_release", "facebook-core_release"})
public final class AppEventsCAPIManager {
    @NotNull
    public static final AppEventsCAPIManager INSTANCE = new AppEventsCAPIManager();
    @NotNull
    private static final String SETTINGS_PATH = "/cloudbridge_settings";
    private static final String TAG = AppEventsCAPIManager.class.getCanonicalName();
    private static boolean isEnabled;

    private AppEventsCAPIManager() {
    }

    public final boolean isEnabled$facebook_core_release() {
        return isEnabled;
    }

    public final void setEnabled$facebook_core_release(boolean bl) {
        isEnabled = bl;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, Object> getSavedCloudBridgeCredentials$facebook_core_release() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsCAPIManager.class)) {
            return null;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.facebook.sdk.CloudBridgeSavedCredentials", 0);
            if (sharedPreferences == null) {
                return null;
            }
            SharedPreferences sharedPref = sharedPreferences;
            String datasetID = sharedPref.getString(SettingsAPIFields.DATASETID.getRawValue(), null);
            String url = sharedPref.getString(SettingsAPIFields.URL.getRawValue(), null);
            String accessKey = sharedPref.getString(SettingsAPIFields.ACCESSKEY.getRawValue(), null);
            CharSequence charSequence = datasetID;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)url) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)accessKey) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            Map savedSettings = new LinkedHashMap();
            savedSettings.put(SettingsAPIFields.URL.getRawValue(), url);
            savedSettings.put(SettingsAPIFields.DATASETID.getRawValue(), datasetID);
            savedSettings.put(SettingsAPIFields.ACCESSKEY.getRawValue(), accessKey);
            Object[] objectArray = new Object[]{datasetID, url, accessKey};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG.toString(), " \n\nLoading Cloudbridge settings from saved Prefs: \n================\n DATASETID: %s\n URL: %s \n ACCESSKEY: %s \n\n ", objectArray);
            return savedSettings;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsCAPIManager.class);
            return null;
        }
    }

    public final void setSavedCloudBridgeCredentials$facebook_core_release(@Nullable Map<String, ? extends Object> valuesToSave) {
        Context context = FacebookSdk.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.facebook.sdk.CloudBridgeSavedCredentials", 0);
        if (sharedPreferences == null) {
            return;
        }
        SharedPreferences sharedPref = sharedPreferences;
        if (valuesToSave == null) {
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.clear();
            editor.apply();
            return;
        }
        Object datasetID = valuesToSave.get(SettingsAPIFields.DATASETID.getRawValue());
        Object url = valuesToSave.get(SettingsAPIFields.URL.getRawValue());
        Object accessKey = valuesToSave.get(SettingsAPIFields.ACCESSKEY.getRawValue());
        if (datasetID == null || url == null || accessKey == null) {
            return;
        }
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(SettingsAPIFields.DATASETID.getRawValue(), datasetID.toString());
        editor.putString(SettingsAPIFields.URL.getRawValue(), url.toString());
        editor.putString(SettingsAPIFields.ACCESSKEY.getRawValue(), accessKey.toString());
        editor.apply();
        Object[] objectArray = new Object[]{datasetID, url, accessKey};
        Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG.toString(), " \n\nSaving Cloudbridge settings from saved Prefs: \n================\n DATASETID: %s\n URL: %s \n ACCESSKEY: %s \n\n ", objectArray);
    }

    @JvmStatic
    public static final void enable() {
        try {
            GraphRequest.Callback callback2 = AppEventsCAPIManager::enable$lambda$0;
            GraphRequest graphReq = new GraphRequest(null, FacebookSdk.getApplicationId() + SETTINGS_PATH, null, HttpMethod.GET, callback2, null, 32, null);
            String string = TAG;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            Object[] objectArray = new Object[]{graphReq};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, " \n\nCreating Graph Request: \n=============\n%s\n\n ", objectArray);
            graphReq.executeAsync();
        }
        catch (JSONException e) {
            String string = TAG;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            Object[] objectArray = new Object[]{ExceptionsKt.stackTraceToString((Throwable)e)};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, " \n\nGraph Request Exception: \n=============\n%s\n\n ", objectArray);
        }
    }

    public final void getCAPIGSettingsFromGraphResponse$facebook_core_release(@NotNull GraphResponse response) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getError() != null) {
            String string = TAG;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            Object[] objectArray = new Object[]{response.getError().toString(), String.valueOf(response.getError().getException())};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, " \n\nGraph Response Error: \n================\nResponse Error: %s\nResponse Error Exception: %s\n\n ", objectArray);
            Map<String, Object> cbCredentials = AppEventsCAPIManager.getSavedCloudBridgeCredentials$facebook_core_release();
            if (cbCredentials != null) {
                URL extractURL = new URL(String.valueOf(cbCredentials.get(SettingsAPIFields.URL.getRawValue())));
                AppEventsConversionsAPITransformerWebRequests.configure(String.valueOf(cbCredentials.get(SettingsAPIFields.DATASETID.getRawValue())), extractURL.getProtocol() + "://" + extractURL.getHost(), String.valueOf(cbCredentials.get(SettingsAPIFields.ACCESSKEY.getRawValue())));
                isEnabled = true;
            }
            return;
        }
        String string = TAG;
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        Object[] cbCredentials = new Object[]{response};
        Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, " \n\nGraph Response Received: \n================\n%s\n\n ", cbCredentials);
        JSONObject result = response.getJSONObject();
        String url = null;
        String datasetID = null;
        String accessKey = null;
        Map<String, Object> config = null;
        try {
            JSONObject jSONObject = result;
            Object object = jSONObject != null ? jSONObject.get("data") : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONArray");
            List<String> data = Utility.convertJSONArrayToList((JSONArray)object);
            config = Utility.convertJSONObjectToHashMap(new JSONObject((String)CollectionsKt.firstOrNull(data)));
            url = (String)config.get(SettingsAPIFields.URL.getRawValue());
            datasetID = (String)config.get(SettingsAPIFields.DATASETID.getRawValue());
            accessKey = (String)config.get(SettingsAPIFields.ACCESSKEY.getRawValue());
        }
        catch (JSONException e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{ExceptionsKt.stackTraceToString((Throwable)e)};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string2, "CloudBridge Settings API response is not a valid json: \n%s ", objectArray);
            return;
        }
        catch (NullPointerException e) {
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            Object[] objectArray = new Object[]{ExceptionsKt.stackTraceToString((Throwable)e)};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string3, "CloudBridge Settings API response is not a valid json: \n%s ", objectArray);
            return;
        }
        if (url == null || datasetID == null || accessKey == null) {
            String string4 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string4, "CloudBridge Settings API response doesn't have valid data");
            return;
        }
        try {
            AppEventsConversionsAPITransformerWebRequests.configure(datasetID, url, accessKey);
            this.setSavedCloudBridgeCredentials$facebook_core_release(config);
        }
        catch (MalformedURLException e) {
            String string5 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"TAG");
            Object[] objectArray = new Object[]{ExceptionsKt.stackTraceToString((Throwable)e)};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string5, "CloudBridge Settings API response doesn't have valid url\n %s ", objectArray);
            return;
        }
        if (config.get(SettingsAPIFields.ENABLED.getRawValue()) != null) {
            Object object = config.get(SettingsAPIFields.ENABLED.getRawValue());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object;
        } else {
            bl = false;
        }
        isEnabled = bl;
    }

    private static final void enable$lambda$0(GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        INSTANCE.getCAPIGSettingsFromGraphResponse$facebook_core_release(response);
    }
}

