/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.errorreport;

import androidx.annotation.RestrictTo;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/facebook/internal/instrument/errorreport/ErrorReportData;", "", "message", "", "(Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "errorMessage", "filename", "isValid", "", "()Z", "parameters", "Lorg/json/JSONObject;", "getParameters", "()Lorg/json/JSONObject;", "timestamp", "", "Ljava/lang/Long;", "clear", "", "compareTo", "", "data", "save", "toString", "Companion", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorReportData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String filename;
    @Nullable
    private String errorMessage;
    @Nullable
    private Long timestamp;
    @NotNull
    private static final String PRARAM_ERROR_MESSAGE = "error_message";
    @NotNull
    private static final String PARAM_TIMESTAMP = "timestamp";

    public ErrorReportData(@Nullable String message) {
        this.timestamp = System.currentTimeMillis() / (long)1000;
        this.errorMessage = message;
        StringBuffer stringBuffer = new StringBuffer().append("error_log_");
        Long l = this.timestamp;
        Intrinsics.checkNotNull((Object)l, (String)"null cannot be cast to non-null type kotlin.Long");
        String string = stringBuffer.append(l).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer()\n         \u2026)\n            .toString()");
        this.filename = string;
    }

    public ErrorReportData(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        this.filename = string;
        JSONObject obj = InstrumentUtility.readFile(this.filename, true);
        if (obj != null) {
            this.timestamp = obj.optLong(PARAM_TIMESTAMP, 0L);
            this.errorMessage = obj.optString(PRARAM_ERROR_MESSAGE, null);
        }
    }

    public final int compareTo(@NotNull ErrorReportData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Long l = this.timestamp;
        if (l == null) {
            return -1;
        }
        long ts = l;
        Long l2 = data.timestamp;
        if (l2 == null) {
            return 1;
        }
        long dts = l2;
        return Intrinsics.compare((long)dts, (long)ts);
    }

    public final boolean isValid() {
        return this.errorMessage != null && this.timestamp != null;
    }

    public final void save() {
        if (this.isValid()) {
            InstrumentUtility.writeFile(this.filename, this.toString());
        }
    }

    public final void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @NotNull
    public String toString() {
        JSONObject jSONObject = this.getParameters();
        if (jSONObject == null) {
            return super.toString();
        }
        JSONObject params = jSONObject;
        String string = params.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.toString()");
        return string;
    }

    @Nullable
    public final JSONObject getParameters() {
        JSONObject obj = new JSONObject();
        try {
            if (this.timestamp != null) {
                obj.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            obj.put(PRARAM_ERROR_MESSAGE, (Object)this.errorMessage);
            return obj;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/instrument/errorreport/ErrorReportData$Companion;", "", "()V", "PARAM_TIMESTAMP", "", "PRARAM_ERROR_MESSAGE", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

