/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u001b\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J+\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0007J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001e"}, d2={"Lcom/facebook/appevents/ml/Operator;", "", "()V", "addmv", "", "x", "Lcom/facebook/appevents/ml/MTensor;", "b", "concatenate", "tensors", "", "([Lcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "conv1D", "w", "dense", "embedding", "texts", "", "seqLength", "", "([Ljava/lang/String;ILcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "flatten", "startDim", "maxPool1D", "poolSize", "mul", "relu", "softmax", "transpose2D", "transpose3D", "facebook-core_release"})
public final class Operator {
    @NotNull
    public static final Operator INSTANCE = new Operator();

    private Operator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void addmv(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            void b;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int seqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            float[] xData = x.getData();
            float[] bData = b.getData();
            for (int i = 0; i < exampleSize; ++i) {
                for (int j = 0; j < seqLength; ++j) {
                    for (int k = 0; k < inputSize; ++k) {
                        int n = i * seqLength * inputSize + j * inputSize + k;
                        xData[n] = xData[n] + bData[k];
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor mul(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSize = w.getShape(0);
            int outputSize = w.getShape(1);
            int[] nArray = new int[]{exampleSize, outputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] wData = w.getData();
            float[] yData = y.getData();
            for (int i = 0; i < exampleSize; ++i) {
                for (int j = 0; j < outputSize; ++j) {
                    yData[i * outputSize + j] = 0.0f;
                    for (int k = 0; k < inputSize; ++k) {
                        int n = i * outputSize + j;
                        yData[n] = yData[n] + xData[i * inputSize + k] * wData[k * outputSize + j];
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    public static final void relu(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            float[] xData = x.getData();
            int n = xData.length;
            for (int i = 0; i < n; ++i) {
                if (!(xData[i] < 0.0f)) continue;
                xData[i] = 0.0f;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    @JvmStatic
    public static final void flatten(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            int startDim;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (startDim >= x.getShapeSize()) {
                return;
            }
            int outputSize = 1;
            int n2 = x.getShapeSize();
            for (void i = startDim; i < n2; ++i) {
                outputSize *= x.getShape((int)i);
            }
            int[] newShape = new int[startDim + true];
            for (int i = 0; i < startDim; ++i) {
                newShape[i] = x.getShape(i);
            }
            newShape[startDim] = outputSize;
            x.reshape(newShape);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor concatenate(@NotNull MTensor[] mTensorArray) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor[] tensors;
            Intrinsics.checkNotNullParameter((Object)tensors, (String)"tensors");
            int exampleSize = tensors[0].getShape(0);
            int outputSize = 0;
            int n = tensors.length;
            for (int i = 0; i < n; ++i) {
                outputSize += tensors[i].getShape(1);
            }
            int[] nArray = new int[]{exampleSize, outputSize};
            MTensor y = new MTensor(nArray);
            float[] yData = y.getData();
            for (int n2 = 0; n2 < exampleSize; ++n2) {
                int desPos = n2 * outputSize;
                int n3 = tensors.length;
                for (int i = 0; i < n3; ++i) {
                    float[] xData = tensors[i].getData();
                    int inputSize = tensors[i].getShape(1);
                    System.arraycopy(xData, n2 * inputSize, yData, desPos, inputSize);
                    desPos += inputSize;
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    public static final void softmax(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSize = x.getShape(1);
            float[] xData = x.getData();
            for (int n = 0; n < exampleSize; ++n) {
                int i;
                int startIndex = n * inputSize;
                int endIndex = startIndex + inputSize;
                float max = Float.MIN_VALUE;
                float sum = 0.0f;
                for (i = startIndex; i < endIndex; ++i) {
                    if (!(xData[i] > max)) continue;
                    max = xData[i];
                }
                for (i = startIndex; i < endIndex; ++i) {
                    xData[i] = (float)Math.exp(xData[i] - max);
                    sum += xData[i];
                }
                for (i = startIndex; i < endIndex; ++i) {
                    xData[i] = xData[i] / sum;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor dense(@NotNull MTensor mTensor, @NotNull MTensor mTensor2, @NotNull MTensor mTensor3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void b;
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int outputSize = b.getShape(0);
            MTensor y = Operator.mul(x, (MTensor)w);
            float[] bData = b.getData();
            float[] yData = y.getData();
            for (int i = 0; i < exampleSize; ++i) {
                for (int j = 0; j < outputSize; ++j) {
                    int n = i * outputSize + j;
                    yData[n] = yData[n] + bData[j];
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor embedding(@NotNull String[] stringArray, int n, @NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int seqLength;
            void w;
            String[] texts;
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = texts.length;
            int embeddingSize = w.getShape(1);
            int[] nArray = new int[]{exampleSize, seqLength, embeddingSize};
            MTensor y = new MTensor(nArray);
            float[] yData = y.getData();
            float[] wData = w.getData();
            for (int i = 0; i < exampleSize; ++i) {
                int[] vectorizedText = Utils.INSTANCE.vectorize(texts[i], seqLength);
                for (int j = 0; j < seqLength; ++j) {
                    System.arraycopy(wData, vectorizedText[j] * embeddingSize, yData, embeddingSize * seqLength * i + embeddingSize * j, embeddingSize);
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor transpose2D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            int[] nArray = new int[]{n, m};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    yData[j * m + i] = xData[i * n + j];
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor transpose3D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            int p = x.getShape(2);
            int[] nArray = new int[]{p, n, m};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < p; ++k) {
                        yData[k * m * n + j * m + i] = xData[i * n * p + j * p + k];
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor conv1D(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int kernelSize = w.getShape(0);
            int outputSeqLength = inputSeqLength - kernelSize + 1;
            int outputSize = w.getShape(2);
            int[] nArray = new int[]{exampleSize, outputSeqLength, outputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            float[] wData = w.getData();
            for (int n = 0; n < exampleSize; ++n) {
                for (int o = 0; o < outputSize; ++o) {
                    for (int i = 0; i < outputSeqLength; ++i) {
                        float sum = 0.0f;
                        for (int m = 0; m < kernelSize; ++m) {
                            for (int k = 0; k < inputSize; ++k) {
                                sum += xData[n * (inputSeqLength * inputSize) + (m + i) * inputSize + k] * wData[(m * inputSize + k) * outputSize + o];
                            }
                        }
                        yData[n * (outputSeqLength * outputSize) + i * outputSize + o] = sum;
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor maxPool1D(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int poolSize;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int outputSeqLength = inputSeqLength - poolSize + 1;
            int[] nArray = new int[]{exampleSize, outputSeqLength, inputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            for (int n2 = 0; n2 < exampleSize; ++n2) {
                for (int c = 0; c < inputSize; ++c) {
                    for (int i = 0; i < outputSeqLength; ++i) {
                        int yIndex = n2 * outputSeqLength * inputSize + i * inputSize + c;
                        int xIndex = n2 * inputSeqLength * inputSize + i * inputSize + c;
                        yData[yIndex] = Float.MIN_VALUE;
                        for (int r = 0; r < poolSize; ++r) {
                            yData[yIndex] = Math.max(yData[yIndex], xData[xIndex + r * inputSize]);
                        }
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }
}

