/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.Patterns;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\r\u0010#\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\u001c\u0010,\u001a\u00020!2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0016H\u0007J\u0012\u0010.\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010/H\u0007Jl\u0010.\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u00042\b\u00102\u001a\u0004\u0018\u00010\u00042\b\u00103\u001a\u0004\u0018\u00010\u00042\b\u00104\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\b\u00107\u001a\u0004\u0018\u00010\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\b\u00109\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010:\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010/H\u0002J\u0018\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/facebook/appevents/UserDataStore;", "", "()V", "CITY", "", "COUNTRY", "DATA_SEPARATOR", "DATE_OF_BIRTH", "EMAIL", "FIRST_NAME", "GENDER", "INTERNAL_USER_DATA_KEY", "LAST_NAME", "MAX_NUM", "", "PHONE", "STATE", "TAG", "kotlin.jvm.PlatformType", "USER_DATA_KEY", "ZIP", "enabledInternalUserData", "", "getEnabledInternalUserData", "()Ljava/util/Map;", "externalHashedUserData", "Ljava/util/concurrent/ConcurrentHashMap;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "internalHashedUserData", "sharedPreferences", "Landroid/content/SharedPreferences;", "clear", "", "getAllHashedUserData", "getHashedUserData", "getHashedUserData$facebook_core_release", "initAndWait", "initStore", "maybeSHA256Hashed", "", "data", "normalizeData", "type", "setInternalUd", "ud", "setUserDataAndHash", "Landroid/os/Bundle;", "email", "firstName", "lastName", "phone", "dateOfBirth", "gender", "city", "state", "zip", "country", "updateHashUserData", "writeDataIntoCache", "key", "value", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nUserDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserDataStore.kt\ncom/facebook/appevents/UserDataStore\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,270:1\n107#2:271\n79#2,22:272\n107#2:296\n79#2,22:297\n37#3,2:294\n*S KotlinDebug\n*F\n+ 1 UserDataStore.kt\ncom/facebook/appevents/UserDataStore\n*L\n211#1:271\n211#1:272,22\n242#1:296\n242#1:297,22\n214#1:294,2\n*E\n"})
public final class UserDataStore {
    @NotNull
    public static final UserDataStore INSTANCE = new UserDataStore();
    private static final String TAG = UserDataStore.class.getSimpleName();
    @NotNull
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    @NotNull
    private static final String INTERNAL_USER_DATA_KEY = "com.facebook.appevents.UserDataStore.internalUserData";
    private static SharedPreferences sharedPreferences;
    @NotNull
    private static final AtomicBoolean initialized;
    private static final int MAX_NUM = 5;
    @NotNull
    private static final String DATA_SEPARATOR = ",";
    @NotNull
    private static final ConcurrentHashMap<String, String> externalHashedUserData;
    @NotNull
    private static final ConcurrentHashMap<String, String> internalHashedUserData;
    @NotNull
    public static final String EMAIL = "em";
    @NotNull
    public static final String FIRST_NAME = "fn";
    @NotNull
    public static final String LAST_NAME = "ln";
    @NotNull
    public static final String PHONE = "ph";
    @NotNull
    public static final String DATE_OF_BIRTH = "db";
    @NotNull
    public static final String GENDER = "ge";
    @NotNull
    public static final String CITY = "ct";
    @NotNull
    public static final String STATE = "st";
    @NotNull
    public static final String ZIP = "zp";
    @NotNull
    public static final String COUNTRY = "country";

    private UserDataStore() {
    }

    @JvmStatic
    public static final void initStore() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            if (initialized.get()) {
                return;
            }
            INSTANCE.initAndWait();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeDataIntoCache(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void value;
            void key;
            FacebookSdk.getExecutor().execute(() -> UserDataStore.writeDataIntoCache$lambda$0((String)key, (String)value));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final void setUserDataAndHash(@Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Bundle ud;
            InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(() -> UserDataStore.setUserDataAndHash$lambda$1(ud));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setUserDataAndHash(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            void country;
            void zip;
            void state;
            void city;
            void gender;
            void dateOfBirth;
            void phone;
            void lastName;
            void firstName;
            String email;
            Bundle ud = new Bundle();
            if (email != null) {
                ud.putString(EMAIL, email);
            }
            if (firstName != null) {
                ud.putString(FIRST_NAME, (String)firstName);
            }
            if (lastName != null) {
                ud.putString(LAST_NAME, (String)lastName);
            }
            if (phone != null) {
                ud.putString(PHONE, (String)phone);
            }
            if (dateOfBirth != null) {
                ud.putString(DATE_OF_BIRTH, (String)dateOfBirth);
            }
            if (gender != null) {
                ud.putString(GENDER, (String)gender);
            }
            if (city != null) {
                ud.putString(CITY, (String)city);
            }
            if (state != null) {
                ud.putString(STATE, (String)state);
            }
            if (zip != null) {
                ud.putString(ZIP, (String)zip);
            }
            if (country != null) {
                ud.putString(COUNTRY, (String)country);
            }
            UserDataStore.setUserDataAndHash(ud);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    @JvmStatic
    public static final void clear() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            InternalAppEventsLogger.Companion.getAnalyticsExecutor().execute(UserDataStore::clear$lambda$2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getHashedUserData$facebook_core_release() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            if (!initialized.get()) {
                Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
                INSTANCE.initAndWait();
            }
            return Utility.mapToJsonStr((Map<String, String>)externalHashedUserData);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getAllHashedUserData() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            if (!initialized.get()) {
                INSTANCE.initAndWait();
            }
            Map allHashedUserData = new HashMap();
            allHashedUserData.putAll((Map)externalHashedUserData);
            allHashedUserData.putAll(INSTANCE.getEnabledInternalUserData());
            return Utility.mapToJsonStr(allHashedUserData);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    private final Map<String, String> getEnabledInternalUserData() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            Map enabledInternalUD = new HashMap();
            Set<String> ruleNames = MetadataRule.Companion.getEnabledRuleNames();
            for (String ruleKey : internalHashedUserData.keySet()) {
                if (!ruleNames.contains(ruleKey)) continue;
                enabledInternalUD.put(ruleKey, ((Map)internalHashedUserData).get(ruleKey));
            }
            return enabledInternalUD;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private final synchronized void initAndWait() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String string;
            SharedPreferences sharedPreferences;
            String externalUdRaw;
            String string2;
            if (initialized.get()) {
                return;
            }
            SharedPreferences sharedPreferences2 = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"getDefaultSharedPreferen\u2026.getApplicationContext())");
            UserDataStore.sharedPreferences = sharedPreferences2;
            SharedPreferences sharedPreferences3 = UserDataStore.sharedPreferences;
            if (sharedPreferences3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences3 = null;
            }
            if ((string2 = sharedPreferences3.getString(USER_DATA_KEY, "")) == null) {
                string2 = externalUdRaw = "";
            }
            if ((sharedPreferences = UserDataStore.sharedPreferences) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences = null;
            }
            if ((string = sharedPreferences.getString(INTERNAL_USER_DATA_KEY, "")) == null) {
                string = "";
            }
            String internalUdRaw = string;
            externalHashedUserData.putAll(Utility.jsonStrToMap(externalUdRaw));
            internalHashedUserData.putAll(Utility.jsonStrToMap(internalUdRaw));
            initialized.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHashUserData(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void ud;
            if (ud == null) {
                return;
            }
            for (String key : ud.keySet()) {
                Object rawVal;
                if (ud.get(key) == null) continue;
                String value = rawVal.toString();
                if (this.maybeSHA256Hashed(value)) {
                    Map map = externalHashedUserData;
                    String string = value.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                    map.put(key, string);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String encryptedValue = Utility.sha256hash(this.normalizeData(key, value));
                if (encryptedValue == null) continue;
                ((Map)externalHashedUserData).put(key, encryptedValue);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setInternalUd(@NotNull Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Map<String, String> ud;
            Intrinsics.checkNotNullParameter(ud, (String)"ud");
            if (!initialized.get()) {
                INSTANCE.initAndWait();
            }
            for (Map.Entry<String, String> entry : ud.entrySet()) {
                String value;
                String key;
                block17: {
                    String[] previousData;
                    Set set;
                    Object object;
                    String[] originalVal;
                    block19: {
                        block18: {
                            void $this$trim$iv;
                            String rawVal;
                            key = entry.getKey();
                            String string = rawVal = entry.getValue();
                            String string2 = key;
                            UserDataStore userDataStore = INSTANCE;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            value = Utility.sha256hash(userDataStore.normalizeData(string2, string3));
                            if (!internalHashedUserData.containsKey(key)) break block17;
                            object = originalVal = internalHashedUserData.get(key);
                            if (originalVal == null || (object = (startIndex$iv$iv = new Regex(DATA_SEPARATOR)).split($i$f$trim2 = (CharSequence)object, endIndex$iv$iv = 0)) == null) break block18;
                            Collection $this$toTypedArray$iv = (Collection)object;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            object = thisCollection$iv.toArray(new String[0]);
                            if (object != null) break block19;
                        }
                        object = new String[]{};
                    }
                    if ((set = SetsKt.mutableSetOf((Object[])Arrays.copyOf(previousData = object, previousData.length))).contains(value)) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (previousData.length == 0) {
                        sb.append(value);
                    } else if (previousData.length < 5) {
                        sb.append((String)originalVal).append(DATA_SEPARATOR).append(value);
                    } else {
                        for (int i = 1; i < 5; ++i) {
                            sb.append(previousData[i]).append(DATA_SEPARATOR);
                        }
                        sb.append(value);
                        set.remove(previousData[0]);
                    }
                    ((Map)internalHashedUserData).put(key, sb.toString());
                    continue;
                }
                ((Map)internalHashedUserData).put(key, value);
            }
            INSTANCE.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)internalHashedUserData));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizeData(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void type;
            void data;
            String data2 = data;
            void $this$trim$iv = data2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
            data2 = string3;
            if (Intrinsics.areEqual((Object)EMAIL, (Object)type)) {
                String string4;
                if (Patterns.EMAIL_ADDRESS.matcher(data2).matches()) {
                    string4 = data2;
                } else {
                    Log.e((String)TAG, (String)"Setting email failure: this is not a valid email address");
                    string4 = "";
                }
                return string4;
            }
            if (Intrinsics.areEqual((Object)PHONE, (Object)type)) {
                CharSequence charSequence = data2;
                Regex regex = new Regex("[^0-9]");
                String string5 = "";
                return regex.replace(charSequence, string5);
            }
            if (Intrinsics.areEqual((Object)GENDER, (Object)type)) {
                String string6;
                String string7;
                if (((CharSequence)data2).length() > 0) {
                    String string8 = data2.substring(0, 1);
                    string7 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string7 = data2 = "";
                }
                if (Intrinsics.areEqual((Object)"f", (Object)data2) || Intrinsics.areEqual((Object)"m", (Object)data2)) {
                    string6 = data2;
                } else {
                    Log.e((String)TAG, (String)"Setting gender failure: the supported value for gender is f or m");
                    string6 = "";
                }
                return string6;
            }
            return data2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean maybeSHA256Hashed(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void data;
            CharSequence charSequence = (CharSequence)data;
            return new Regex("[A-Fa-f0-9]{64}").matches(charSequence);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDataIntoCache$lambda$0(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            SharedPreferences sharedPreferences;
            void $value;
            String $key;
            Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            if (!initialized.get()) {
                INSTANCE.initAndWait();
            }
            if ((sharedPreferences = UserDataStore.sharedPreferences) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences = null;
            }
            sharedPreferences.edit().putString($key, (String)$value).apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    private static final void setUserDataAndHash$lambda$1(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Bundle $ud;
            if (!initialized.get()) {
                Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                INSTANCE.initAndWait();
            }
            INSTANCE.updateHashUserData($ud);
            INSTANCE.writeDataIntoCache(USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)externalHashedUserData));
            INSTANCE.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr((Map<String, String>)internalHashedUserData));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    private static final void clear$lambda$2() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            if (!initialized.get()) {
                Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                INSTANCE.initAndWait();
            }
            externalHashedUserData.clear();
            SharedPreferences sharedPreferences = UserDataStore.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences = null;
            }
            sharedPreferences.edit().putString(USER_DATA_KEY, null).apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
        externalHashedUserData = new ConcurrentHashMap();
        internalHashedUserData = new ConcurrentHashMap();
    }
}

