/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.FacebookSignatureValidator;
import com.facebook.internal.Utility;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/facebook/internal/AttributionIdentifiers;", "", "()V", "androidAdvertiserId", "", "getAndroidAdvertiserId", "()Ljava/lang/String;", "androidAdvertiserIdValue", "<set-?>", "androidInstallerPackage", "getAndroidInstallerPackage", "attributionId", "getAttributionId", "fetchTime", "", "", "isTrackingLimited", "()Z", "Companion", "GoogleAdInfo", "GoogleAdServiceConnection", "facebook-core_release"})
public final class AttributionIdentifiers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String androidAdvertiserIdValue;
    private long fetchTime;
    @Nullable
    private String attributionId;
    @Nullable
    private String androidInstallerPackage;
    private boolean isTrackingLimited;
    private static final String TAG = AttributionIdentifiers.class.getCanonicalName();
    @NotNull
    public static final String ATTRIBUTION_ID_CONTENT_PROVIDER = "com.facebook.katana.provider.AttributionIdProvider";
    @NotNull
    private static final String ATTRIBUTION_ID_CONTENT_PROVIDER_WAKIZASHI = "com.facebook.wakizashi.provider.AttributionIdProvider";
    @NotNull
    private static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    @NotNull
    private static final String ANDROID_ID_COLUMN_NAME = "androidid";
    @NotNull
    private static final String LIMIT_TRACKING_COLUMN_NAME = "limit_tracking";
    private static final int CONNECTION_RESULT_SUCCESS = 0;
    private static final long IDENTIFIER_REFRESH_INTERVAL_MILLIS = 3600000L;
    @JvmField
    @Nullable
    public static AttributionIdentifiers cachedIdentifiers;

    @Nullable
    public final String getAttributionId() {
        return this.attributionId;
    }

    @Nullable
    public final String getAndroidInstallerPackage() {
        return this.androidInstallerPackage;
    }

    public final boolean isTrackingLimited() {
        return this.isTrackingLimited;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getAndroidAdvertiserId() {
        String string;
        if (FacebookSdk.INSTANCE.isInitialized()) {
            if (FacebookSdk.INSTANCE.getAdvertiserIDCollectionEnabled()) {
                string = this.androidAdvertiserIdValue;
                return string;
            }
        }
        string = null;
        return string;
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isTrackingLimited(@NotNull Context context) {
        return Companion.isTrackingLimited(context);
    }

    @JvmStatic
    @Nullable
    public static final AttributionIdentifiers getAttributionIdentifiers(@NotNull Context context) {
        return Companion.getAttributionIdentifiers(context);
    }

    public static final /* synthetic */ long access$getFetchTime$p(AttributionIdentifiers $this) {
        return $this.fetchTime;
    }

    public static final /* synthetic */ void access$setAndroidInstallerPackage$p(AttributionIdentifiers $this, String string) {
        $this.androidInstallerPackage = string;
    }

    public static final /* synthetic */ void access$setAttributionId$p(AttributionIdentifiers $this, String string) {
        $this.attributionId = string;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u00a8\u0006\u001f"}, d2={"Lcom/facebook/internal/AttributionIdentifiers$Companion;", "", "()V", "ANDROID_ID_COLUMN_NAME", "", "ATTRIBUTION_ID_COLUMN_NAME", "ATTRIBUTION_ID_CONTENT_PROVIDER", "getATTRIBUTION_ID_CONTENT_PROVIDER$facebook_core_release$annotations", "ATTRIBUTION_ID_CONTENT_PROVIDER_WAKIZASHI", "CONNECTION_RESULT_SUCCESS", "", "IDENTIFIER_REFRESH_INTERVAL_MILLIS", "", "LIMIT_TRACKING_COLUMN_NAME", "TAG", "kotlin.jvm.PlatformType", "cachedIdentifiers", "Lcom/facebook/internal/AttributionIdentifiers;", "getCachedIdentifiers$facebook_core_release$annotations", "cacheAndReturnIdentifiers", "identifiers", "getAndroidId", "context", "Landroid/content/Context;", "getAndroidIdViaReflection", "getAndroidIdViaService", "getAttributionIdentifiers", "getInstallerPackageName", "isGooglePlayServicesAvailable", "", "isTrackingLimited", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting(otherwise=2)
        public static /* synthetic */ void getATTRIBUTION_ID_CONTENT_PROVIDER$facebook_core_release$annotations() {
        }

        @VisibleForTesting(otherwise=2)
        public static /* synthetic */ void getCachedIdentifiers$facebook_core_release$annotations() {
        }

        private final AttributionIdentifiers getAndroidId(Context context) {
            AttributionIdentifiers identifiers = this.getAndroidIdViaReflection(context);
            if (identifiers == null && (identifiers = this.getAndroidIdViaService(context)) == null) {
                identifiers = new AttributionIdentifiers();
            }
            return identifiers;
        }

        private final AttributionIdentifiers getAndroidIdViaReflection(Context context) {
            try {
                if (!this.isGooglePlayServicesAvailable(context)) {
                    return null;
                }
                Object object = new Class[]{Context.class};
                Method method = Utility.getMethodQuietly("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", object);
                if (method == null) {
                    return null;
                }
                Method getAdvertisingIdInfo = method;
                Object[] objectArray = new Object[]{context};
                object = Utility.invokeMethodQuietly(null, getAdvertisingIdInfo, objectArray);
                if (object == null) {
                    return null;
                }
                Object advertisingInfo = object;
                Method getId = Utility.getMethodQuietly(advertisingInfo.getClass(), "getId", new Class[0]);
                Method isLimitAdTrackingEnabled = Utility.getMethodQuietly(advertisingInfo.getClass(), "isLimitAdTrackingEnabled", new Class[0]);
                if (getId == null || isLimitAdTrackingEnabled == null) {
                    return null;
                }
                AttributionIdentifiers identifiers = new AttributionIdentifiers();
                identifiers.androidAdvertiserIdValue = (String)Utility.invokeMethodQuietly(advertisingInfo, getId, new Object[0]);
                Boolean bl = (Boolean)Utility.invokeMethodQuietly(advertisingInfo, isLimitAdTrackingEnabled, new Object[0]);
                identifiers.isTrackingLimited = bl == null ? false : bl;
                return identifiers;
            }
            catch (Exception e) {
                Utility.logd("android_id", e);
                return null;
            }
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isTrackingLimited(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AttributionIdentifiers attributionIdentifiers = this.getAttributionIdentifiers(context);
            return attributionIdentifiers != null && attributionIdentifiers.isTrackingLimited();
        }

        private final boolean isGooglePlayServicesAvailable(Context context) {
            Object[] objectArray = new Class[]{Context.class};
            Method method = Utility.getMethodQuietly("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", objectArray);
            if (method == null) {
                return false;
            }
            Method method2 = method;
            objectArray = new Object[]{context};
            Object connectionResult = Utility.invokeMethodQuietly(null, method2, objectArray);
            return connectionResult instanceof Integer && Intrinsics.areEqual((Object)connectionResult, (Object)0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AttributionIdentifiers getAndroidIdViaService(Context context) {
            boolean bl;
            if (!this.isGooglePlayServicesAvailable(context)) {
                return null;
            }
            GoogleAdServiceConnection connection = new GoogleAdServiceConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            try {
                bl = context.bindService(intent, (ServiceConnection)connection, 1);
            }
            catch (SecurityException _) {
                return null;
            }
            boolean isBindServiceSucceed = bl;
            if (isBindServiceSucceed) {
                try {
                    GoogleAdInfo adInfo = new GoogleAdInfo(connection.getBinder());
                    AttributionIdentifiers identifiers = new AttributionIdentifiers();
                    identifiers.androidAdvertiserIdValue = adInfo.getAdvertiserId();
                    identifiers.isTrackingLimited = adInfo.isTrackingLimited();
                    AttributionIdentifiers attributionIdentifiers = identifiers;
                    return attributionIdentifiers;
                }
                catch (Exception exception) {
                    Utility.logd("android_id", exception);
                }
                finally {
                    context.unbindService((ServiceConnection)connection);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final AttributionIdentifiers getAttributionIdentifiers(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            identifiers = this.getAndroidId(context);
            c = null;
            try {
                if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
                    throw new FacebookException("getAttributionIdentifiers cannot be called on the main thread.");
                }
                cachedIdentifiers = AttributionIdentifiers.cachedIdentifiers;
                if (cachedIdentifiers != null && System.currentTimeMillis() - AttributionIdentifiers.access$getFetchTime$p(cachedIdentifiers) < 3600000L) {
                    var5_7 = cachedIdentifiers;
                    var6_9 = c;
                    return var5_7;
                }
                var6_10 = new String[]{"aid", "androidid", "limit_tracking"};
                projection = var6_10;
                providerUri = null;
                contentProviderInfo = context.getPackageManager().resolveContentProvider("com.facebook.katana.provider.AttributionIdProvider", 0);
                wakizashiProviderInfo = context.getPackageManager().resolveContentProvider("com.facebook.wakizashi.provider.AttributionIdProvider", 0);
                if (contentProviderInfo == null) ** GOTO lbl-1000
                var9_13 = contentProviderInfo.packageName;
                Intrinsics.checkNotNullExpressionValue((Object)var9_13, (String)"contentProviderInfo.packageName");
                if (FacebookSignatureValidator.validateSignature(context, var9_13)) {
                    providerUri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
                } else if (wakizashiProviderInfo != null) {
                    var9_13 = wakizashiProviderInfo.packageName;
                    Intrinsics.checkNotNullExpressionValue((Object)var9_13, (String)"wakizashiProviderInfo.packageName");
                    if (FacebookSignatureValidator.validateSignature(context, var9_13)) {
                        providerUri = Uri.parse((String)"content://com.facebook.wakizashi.provider.AttributionIdProvider");
                    }
                }
                installerPackageName = this.getInstallerPackageName(context);
                if (installerPackageName != null) {
                    AttributionIdentifiers.access$setAndroidInstallerPackage$p(identifiers, installerPackageName);
                }
                if (providerUri == null) {
                    var10_14 = this.cacheAndReturnIdentifiers(identifiers);
                    var11_17 = c;
                    return var10_14;
                }
                c = context.getContentResolver().query(providerUri, projection, null, null, null);
                if (c == null || !c.moveToFirst()) {
                    var10_15 = this.cacheAndReturnIdentifiers(identifiers);
                    return var10_15;
                }
                attributionColumnIndex = c.getColumnIndex("aid");
                androidIdColumnIndex = c.getColumnIndex("androidid");
                limitTrackingColumnIndex = c.getColumnIndex("limit_tracking");
                AttributionIdentifiers.access$setAttributionId$p(identifiers, c.getString(attributionColumnIndex));
                if (androidIdColumnIndex > 0 && limitTrackingColumnIndex > 0 && identifiers.getAndroidAdvertiserId() == null) {
                    AttributionIdentifiers.access$setAndroidAdvertiserIdValue$p(identifiers, c.getString(androidIdColumnIndex));
                    AttributionIdentifiers.access$setTrackingLimited$p(identifiers, Boolean.parseBoolean(c.getString(limitTrackingColumnIndex)));
                }
                cachedIdentifiers = c;
            }
            catch (Exception e) {
                Utility.logd(AttributionIdentifiers.access$getTAG$cp(), Intrinsics.stringPlus((String)"Caught unexpected exception in getAttributionId(): ", (Object)e));
                var5_8 = null;
                return var5_8;
            }
            cachedIdentifiers.close();
            return this.cacheAndReturnIdentifiers(identifiers);
            finally {
                var6_10 = c;
                if (var6_10 != null) {
                    var6_10.close();
                }
            }
        }

        private final AttributionIdentifiers cacheAndReturnIdentifiers(AttributionIdentifiers identifiers) {
            identifiers.fetchTime = System.currentTimeMillis();
            cachedIdentifiers = identifiers;
            return identifiers;
        }

        private final String getInstallerPackageName(Context context) {
            PackageManager packageManager = context.getPackageManager();
            PackageManager packageManager2 = packageManager;
            return packageManager2 == null ? null : packageManager2.getInstallerPackageName(context.getPackageName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/internal/AttributionIdentifiers$GoogleAdServiceConnection;", "Landroid/content/ServiceConnection;", "()V", "binder", "Landroid/os/IBinder;", "getBinder", "()Landroid/os/IBinder;", "consumed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "queue", "Ljava/util/concurrent/BlockingQueue;", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "service", "onServiceDisconnected", "facebook-core_release"})
    private static final class GoogleAdServiceConnection
    implements ServiceConnection {
        @NotNull
        private final AtomicBoolean consumed = new AtomicBoolean(false);
        @NotNull
        private final BlockingQueue<IBinder> queue = new LinkedBlockingDeque();

        public void onServiceConnected(@Nullable ComponentName name, @Nullable IBinder service) {
            try {
                if (service != null) {
                    this.queue.put(service);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(@Nullable ComponentName name) {
        }

        @NotNull
        public final IBinder getBinder() throws InterruptedException {
            boolean bl = !this.consumed.compareAndSet(true, true);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Binder already consumed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            IBinder iBinder = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"queue.take()");
            return iBinder;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/AttributionIdentifiers$GoogleAdInfo;", "Landroid/os/IInterface;", "binder", "Landroid/os/IBinder;", "(Landroid/os/IBinder;)V", "advertiserId", "", "getAdvertiserId", "()Ljava/lang/String;", "isTrackingLimited", "", "()Z", "asBinder", "Companion", "facebook-core_release"})
    private static final class GoogleAdInfo
    implements IInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IBinder binder;
        private static final int FIRST_TRANSACTION_CODE = 1;
        private static final int SECOND_TRANSACTION_CODE = 2;

        public GoogleAdInfo(@NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            this.binder = binder;
        }

        @NotNull
        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String getAdvertiserId() throws RemoteException {
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
            Parcel data = parcel;
            Object object = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"obtain()");
            Parcel reply = object;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                object = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isTrackingLimited() throws RemoteException {
            boolean bl;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain()");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(1);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                bl = reply.readInt() != 0;
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return bl;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/AttributionIdentifiers$GoogleAdInfo$Companion;", "", "()V", "FIRST_TRANSACTION_CODE", "", "SECOND_TRANSACTION_CODE", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

