/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import android.os.Build;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J&\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u001c\u001a\u00020\fH\u0002J\u001a\u0010\u001d\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\""}, d2={"Lcom/facebook/appevents/integrity/MACARuleMatchingManager;", "", "()V", "MACARules", "Lorg/json/JSONArray;", "enabled", "", "keys", "", "", "[Ljava/lang/String;", "enable", "", "generateInfo", "params", "Landroid/os/Bundle;", "event", "getKey", "logic", "Lorg/json/JSONObject;", "getMatchPropertyIDs", "getStringArrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "jsonArray", "isMatchCCRule", "ruleString", "data", "loadMACARules", "processParameters", "removeGeneratedInfo", "stringComparison", "variable", "values", "facebook-core_release"})
public final class MACARuleMatchingManager {
    @NotNull
    public static final MACARuleMatchingManager INSTANCE = new MACARuleMatchingManager();
    private static boolean enabled;
    @Nullable
    private static JSONArray MACARules;
    @NotNull
    private static String[] keys;

    private MACARuleMatchingManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            INSTANCE.loadMACARules();
            if (MACARules != null) {
                enabled = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    private final void loadMACARules() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (fetchedAppSettings == null) {
                return;
            }
            FetchedAppSettings settings = fetchedAppSettings;
            MACARules = settings.getMACARuleMatchingSetting();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getKey(@NotNull JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return null;
        }
        try {
            JSONObject logic;
            Intrinsics.checkNotNullParameter((Object)logic, (String)"logic");
            Iterator its = logic.keys();
            if (its.hasNext()) {
                return (String)its.next();
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean stringComparison(@NotNull String string, @NotNull JSONObject jSONObject, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return false;
        }
        try {
            boolean bl;
            String string2;
            Object object;
            String string3;
            String string4;
            Object object2;
            void data;
            void values;
            String variable;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String string5 = MACARuleMatchingManager.getKey((JSONObject)values);
            if (string5 == null) {
                return false;
            }
            String op = string5;
            String ruleValue = values.get(op).toString();
            ArrayList<String> ruleArray = MACARuleMatchingManager.getStringArrayList(values.optJSONArray(op));
            if (Intrinsics.areEqual((Object)op, (Object)"exists")) {
                String string6 = data;
                Boolean bl2 = string6 == null ? null : Boolean.valueOf(string6.containsKey(variable));
                string6 = ruleValue;
                boolean bl3 = false;
                return Intrinsics.areEqual((Object)bl2, (Object)Boolean.parseBoolean(string6));
            }
            ArrayList<String> arrayList = data;
            if (arrayList == null) {
                object2 = null;
            } else {
                string4 = variable;
                boolean bl4 = false;
                String string7 = string4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                object2 = string3 = arrayList.get(string7);
            }
            if (string3 == null) {
                string4 = data;
                ArrayList<String> arrayList2 = arrayList = string4 == null ? null : string4.get(variable);
                if (arrayList == null) {
                    return false;
                }
                object = arrayList;
            } else {
                object = string3;
            }
            String dataValue = string2 = object;
            block36 : switch (op) {
                case "contains": {
                    bl = StringsKt.contains$default((CharSequence)dataValue.toString(), (CharSequence)ruleValue, (boolean)false, (int)2, null);
                    break;
                }
                case "i_contains": {
                    string3 = dataValue.toString();
                    boolean bl5 = false;
                    String string8 = string3;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    CharSequence charSequence = string9;
                    string3 = ruleValue;
                    bl5 = false;
                    String string10 = string3;
                    if (string10 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string11 = string10.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string11, (boolean)false, (int)2, null);
                    break;
                }
                case "not_contains": {
                    if (!StringsKt.contains$default((CharSequence)dataValue.toString(), (CharSequence)ruleValue, (boolean)false, (int)2, null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "i_not_contains": {
                    string3 = dataValue.toString();
                    boolean bl6 = false;
                    String string12 = string3;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    CharSequence charSequence = string13;
                    string3 = ruleValue;
                    bl6 = false;
                    String string14 = string3;
                    if (string14 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string15 = string14.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string15, (boolean)false, (int)2, null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "starts_with": {
                    bl = StringsKt.startsWith$default((String)dataValue.toString(), (String)ruleValue, (boolean)false, (int)2, null);
                    break;
                }
                case "i_starts_with": {
                    string3 = dataValue.toString();
                    boolean bl7 = false;
                    String string16 = string3;
                    if (string16 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string17 = string16.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string3 = ruleValue;
                    bl7 = false;
                    String string18 = string3;
                    if (string18 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string19 = string18.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    bl = StringsKt.startsWith$default((String)string17, (String)string19, (boolean)false, (int)2, null);
                    break;
                }
                case "i_str_eq": {
                    string3 = dataValue.toString();
                    boolean bl8 = false;
                    String string20 = string3;
                    if (string20 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string21 = string20.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string3 = ruleValue;
                    bl8 = false;
                    String string22 = string3;
                    if (string22 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string23 = string22.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    bl = Intrinsics.areEqual((Object)string21, (Object)string23);
                    break;
                }
                case "i_str_neq": {
                    string3 = dataValue.toString();
                    boolean bl9 = false;
                    String string24 = string3;
                    if (string24 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string25 = string24.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string3 = ruleValue;
                    bl9 = false;
                    String string26 = string3;
                    if (string26 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string27 = string26.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string27, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual((Object)string25, (Object)string27)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "in": 
                case "is_any": {
                    arrayList = ruleArray;
                    if (arrayList == null) {
                        return false;
                    }
                    ArrayList<String> arr = arrayList;
                    bl = arr.contains(dataValue.toString());
                    break;
                }
                case "i_is_any": 
                case "i_str_in": {
                    arrayList = ruleArray;
                    if (arrayList == null) {
                        return false;
                    }
                    ArrayList<String> arr = arrayList;
                    Iterable<String> $this$any$iv = arr;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                        break;
                    }
                    Iterator<String> iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        String element$iv;
                        String str = element$iv = iterator.next();
                        boolean bl10 = false;
                        String string28 = str;
                        boolean bl11 = false;
                        String string29 = string28;
                        if (string29 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string30 = string29.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        string28 = dataValue.toString();
                        bl11 = false;
                        String string31 = string28;
                        if (string31 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string32 = string31.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        if (!Intrinsics.areEqual((Object)string30, (Object)string32)) continue;
                        bl = true;
                        break block36;
                    }
                    bl = false;
                    break;
                }
                case "not_in": 
                case "is_not_any": {
                    Iterable<String> $this$any$iv = ruleArray;
                    if ($this$any$iv == null) {
                        return false;
                    }
                    ArrayList<String> arr = $this$any$iv;
                    bl = arr.contains(dataValue.toString());
                    break;
                }
                case "i_str_not_in": 
                case "i_is_not_any": {
                    Iterable<String> $this$any$iv = ruleArray;
                    if ($this$any$iv == null) {
                        return false;
                    }
                    ArrayList<String> arr = $this$any$iv;
                    Iterable $this$all$iv = arr;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                        break;
                    }
                    for (Object element$iv : $this$all$iv) {
                        String str = (String)element$iv;
                        boolean bl12 = false;
                        String string33 = str;
                        boolean bl13 = false;
                        String string34 = string33;
                        if (string34 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string35 = string34.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        string33 = dataValue.toString();
                        bl13 = false;
                        String string36 = string33;
                        if (string36 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string37 = string36.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string37, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                        if (!Intrinsics.areEqual((Object)string35, (Object)string37)) continue;
                        bl = false;
                        break block36;
                    }
                    bl = true;
                    break;
                }
                case "regex_match": {
                    string3 = ruleValue;
                    boolean bl14 = false;
                    bl = new Regex(string3).matches((CharSequence)dataValue.toString());
                    break;
                }
                case "==": 
                case "eq": 
                case "=": {
                    bl = Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue);
                    break;
                }
                case "neq": 
                case "ne": 
                case "!=": {
                    if (!Intrinsics.areEqual((Object)dataValue.toString(), (Object)ruleValue)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "lt": 
                case "<": {
                    string3 = dataValue.toString();
                    boolean bl15 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl15 = false;
                    if (d < Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "<=": 
                case "lte": 
                case "le": {
                    string3 = dataValue.toString();
                    boolean bl16 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl16 = false;
                    if (d <= Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "gt": 
                case ">": {
                    string3 = dataValue.toString();
                    boolean bl17 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl17 = false;
                    if (d > Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "gte": 
                case "ge": 
                case ">=": {
                    string3 = dataValue.toString();
                    boolean bl18 = false;
                    double d = Double.parseDouble(string3);
                    string3 = ruleValue;
                    bl18 = false;
                    if (d >= Double.parseDouble(string3)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return false;
        }
    }

    @JvmStatic
    @Nullable
    public static final ArrayList<String> getStringArrayList(@Nullable JSONArray jSONArray) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return null;
        }
        try {
            JSONArray jsonArray;
            if (jsonArray == null) {
                return null;
            }
            int n = 0;
            ArrayList<String> res = new ArrayList<String>();
            n = 0;
            int n2 = jsonArray.length();
            if (n < n2) {
                do {
                    int i = n++;
                    res.add(jsonArray.get(i).toString());
                } while (n < n2);
            }
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isMatchCCRule(@Nullable String string, @Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return false;
        }
        try {
            boolean bl;
            void data;
            String ruleString;
            if (ruleString == null || data == null) {
                return false;
            }
            JSONObject ruleJson = new JSONObject(ruleString);
            String string2 = MACARuleMatchingManager.getKey(ruleJson);
            if (string2 == null) {
                return false;
            }
            String op = string2;
            Object values = ruleJson.get(op);
            switch (op) {
                case "and": {
                    JSONArray jSONArray = (JSONArray)values;
                    if (jSONArray == null) {
                        return false;
                    }
                    int n = 0;
                    JSONArray v = jSONArray;
                    int n2 = v.length();
                    if (n < n2) {
                        do {
                            int i = n++;
                            boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), (Bundle)data);
                            if (thisRes) continue;
                            return false;
                        } while (n < n2);
                    }
                    return true;
                }
                case "or": {
                    JSONArray jSONArray = (JSONArray)values;
                    if (jSONArray == null) {
                        return false;
                    }
                    int n = 0;
                    JSONArray v = jSONArray;
                    int n3 = v.length();
                    if (n < n3) {
                        do {
                            int i = n++;
                            boolean thisRes = MACARuleMatchingManager.isMatchCCRule(v.get(i).toString(), (Bundle)data);
                            if (!thisRes) continue;
                            return true;
                        } while (n < n3);
                    }
                    return false;
                }
                case "not": {
                    if (!MACARuleMatchingManager.isMatchCCRule(values.toString(), (Bundle)data)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    JSONObject jSONObject = (JSONObject)values;
                    if (jSONObject == null) {
                        return false;
                    }
                    JSONObject v = jSONObject;
                    return MACARuleMatchingManager.stringComparison(op, v, (Bundle)data);
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getMatchPropertyIDs(@Nullable Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return null;
        }
        try {
            block10: {
                block9: {
                    if (MACARules == null) break block9;
                    JSONArray jSONArray = MACARules;
                    Integer n = jSONArray == null ? null : Integer.valueOf(jSONArray.length());
                    boolean bl = false;
                    if (n == null || n != 0) break block10;
                }
                return "[]";
            }
            JSONArray jSONArray = MACARules;
            if (jSONArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONArray");
            }
            JSONArray rules = jSONArray;
            int n = 0;
            List res = new ArrayList();
            n = 0;
            int n2 = rules.length();
            if (n < n2) {
                do {
                    Bundle params;
                    String string;
                    String entry;
                    JSONObject json;
                    long pid;
                    int i;
                    String string2;
                    if ((string2 = rules.optString(i = n++)) == null || (pid = (json = new JSONObject(entry = string2)).optLong("id")) == 0L || (string = json.optString("rule")) == null) continue;
                    String rule = string;
                    if (!MACARuleMatchingManager.isMatchCCRule(rule, params)) continue;
                    res.add(pid);
                } while (n < n2);
            }
            String string = new JSONArray((Collection)res).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(res).toString()");
            return string;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void processParameters(@Nullable Bundle bundle, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            Bundle params;
            void event;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!enabled || params == null) {
                return;
            }
            try {
                MACARuleMatchingManager.generateInfo(params, (String)event);
                params.putString("_audiencePropertyIds", MACARuleMatchingManager.getMatchPropertyIDs(params));
                params.putString("cs_maca", "1");
                MACARuleMatchingManager.removeGeneratedInfo(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void generateInfo(@NotNull Bundle bundle, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            String string2;
            void event;
            Bundle params;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            params.putString("event", (String)event);
            Object object = Utility.INSTANCE.getLocale();
            StringBuilder stringBuilder = new StringBuilder().append(object == null ? "" : ((string2 = ((Locale)object).getLanguage()) == null ? "" : string2)).append('_');
            object = Utility.INSTANCE.getLocale();
            params.putString("_locale", stringBuilder.append(object == null ? "" : ((string2 = ((Locale)object).getCountry()) == null ? "" : string2)).toString());
            object = Utility.INSTANCE.getVersionName();
            params.putString("_appVersion", (String)(object == null ? "" : object));
            params.putString("_deviceOS", "ANDROID");
            params.putString("_platform", "mobile");
            object = Build.MODEL;
            params.putString("_deviceModel", (String)(object == null ? "" : object));
            params.putString("_nativeAppID", FacebookSdk.INSTANCE.getApplicationId());
            object = Utility.INSTANCE.getVersionName();
            params.putString("_nativeAppShortVersion", (String)(object == null ? "" : object));
            params.putString("_timezone", Utility.INSTANCE.getDeviceTimeZoneName());
            params.putString("_carrier", Utility.INSTANCE.getCarrierName());
            params.putString("_deviceOSTypeName", "ANDROID");
            params.putString("_deviceOSVersion", Build.VERSION.RELEASE);
            params.putLong("_remainingDiskGB", Utility.INSTANCE.getAvailableExternalStorageGB());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void removeGeneratedInfo(@NotNull Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(MACARuleMatchingManager.class)) {
            return;
        }
        try {
            Bundle params;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            for (String k : keys) {
                params.remove(k);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MACARuleMatchingManager.class);
            return;
        }
    }

    static {
        String[] stringArray = new String[]{"event", "_locale", "_appVersion", "_deviceOS", "_platform", "_deviceModel", "_nativeAppID", "_nativeAppShortVersion", "_timezone", "_carrier", "_deviceOSTypeName", "_deviceOSVersion", "_remainingDiskGB"};
        keys = stringArray;
    }
}

