/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\r\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/appevents/integrity/BlocklistEventsManager;", "", "()V", "blocklist", "", "", "enabled", "", "disable", "", "enable", "isInBlocklist", "eventName", "loadBlocklistEvents", "facebook-core_release"})
public final class BlocklistEventsManager {
    @NotNull
    public static final BlocklistEventsManager INSTANCE = new BlocklistEventsManager();
    private static boolean enabled;
    @NotNull
    private static Set<String> blocklist;

    private BlocklistEventsManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(BlocklistEventsManager.class)) {
            return;
        }
        try {
            INSTANCE.loadBlocklistEvents();
            Collection collection = blocklist;
            boolean bl = false;
            boolean bl2 = false;
            if (!(collection == null || collection.isEmpty())) {
                enabled = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, BlocklistEventsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void disable() {
        if (CrashShieldHandler.isObjectCrashing(BlocklistEventsManager.class)) {
            return;
        }
        try {
            enabled = false;
            blocklist = new HashSet();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, BlocklistEventsManager.class);
            return;
        }
    }

    private final void loadBlocklistEvents() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            HashSet<String> hashSet = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (hashSet == null) {
                return;
            }
            FetchedAppSettings settings = hashSet;
            hashSet = Utility.convertJSONArrayToHashSet(settings.getBlocklistEvents());
            if (hashSet != null) {
                HashSet<String> hashSet2 = hashSet;
                boolean bl = false;
                boolean bl2 = false;
                HashSet<String> it = hashSet2;
                boolean bl3 = false;
                blocklist = it;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final boolean isInBlocklist(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(BlocklistEventsManager.class)) {
            return false;
        }
        try {
            String eventName;
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!enabled) {
                return false;
            }
            return blocklist.contains(eventName);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, BlocklistEventsManager.class);
            return false;
        }
    }

    static {
        blocklist = new HashSet();
    }
}

