/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.ml.MTensor;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/appevents/ml/Utils;", "", "()V", "DIR_NAME", "", "getMlDir", "Ljava/io/File;", "normalizeString", "str", "parseModelWeights", "", "Lcom/facebook/appevents/ml/MTensor;", "file", "vectorize", "", "texts", "maxLen", "", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final String DIR_NAME = "facebook_ml/";

    private Utils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] vectorize(@NotNull String string, int n) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            String normalizedStr;
            void maxLen;
            void texts;
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            int[] ret = new int[maxLen];
            String string2 = normalizedStr = this.normalizeString((String)texts);
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] strBytes = byArray;
            int n2 = 0;
            if (n2 < maxLen) {
                do {
                    int i;
                    ret[i] = (i = n2++) < strBytes.length ? strBytes[i] & 0xFF : 0;
                } while (n2 < maxLen);
            }
            return ret;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String normalizeString(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void $this$toTypedArray$iv;
            void str;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            void $this$trim$iv = str;
            boolean $i$f$trim22 = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            int $i$f$trim = 0;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String trim = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Object $i$f$trim22 = trim;
            $this$trim$iv$iv = "\\s+";
            $i$f$trim = 0;
            $this$trim$iv$iv = new Regex((String)$this$trim$iv$iv);
            $i$f$trim = 0;
            boolean bl = false;
            $i$f$trim22 = $this$trim$iv$iv.split((CharSequence)$i$f$trim22, $i$f$trim);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] strArray = objectArray;
            String string2 = TextUtils.join((CharSequence)" ", (Object[])strArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(\" \", strArray)");
            return string2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final File getMlDir() {
        if (CrashShieldHandler.isObjectCrashing(Utils.class)) {
            return null;
        }
        try {
            File dir = new File(FacebookSdk.INSTANCE.getApplicationContext().getFilesDir(), DIR_NAME);
            return dir.exists() || dir.mkdirs() ? dir : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utils.class);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Map<String, MTensor> parseModelWeights(@NotNull File file) {
        if (CrashShieldHandler.isObjectCrashing(Utils.class)) {
            return null;
        }
        try {
            File file2;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            try {
                InputStream inputStream = new FileInputStream(file2);
                int length = inputStream.available();
                DataInputStream dataIs = new DataInputStream(inputStream);
                byte[] allData = new byte[length];
                dataIs.readFully(allData);
                dataIs.close();
                if (length < 4) {
                    return null;
                }
                ByteBuffer bb = ByteBuffer.wrap(allData, 0, 4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int jsonLen = bb.getInt();
                if (length < jsonLen + 4) {
                    return null;
                }
                int n = 4;
                boolean bl = false;
                int n2 = 0;
                String jsonStr = new String(allData, n, jsonLen, Charsets.UTF_8);
                JSONObject info = new JSONObject(jsonStr);
                JSONArray names = info.names();
                Object[] keys = new String[names.length()];
                int n3 = keys.length + -1;
                if (n2 <= n3) {
                    do {
                        int i = n2++;
                        keys[i] = names.getString(i);
                    } while (n2 <= n3);
                }
                ArraysKt.sort((Object[])keys);
                int offset = 4 + jsonLen;
                boolean bl2 = false;
                HashMap weights = new HashMap();
                Object[] objectArray = keys;
                int n4 = 0;
                int n5 = objectArray.length;
                while (n4 < n5) {
                    Object key = objectArray[n4];
                    ++n4;
                    if (key == null) continue;
                    int count = 1;
                    int n6 = 0;
                    JSONArray shapes = info.getJSONArray((String)key);
                    int[] shape = new int[shapes.length()];
                    int n7 = shape.length + -1;
                    if (n6 <= n7) {
                        do {
                            int i = n6++;
                            shape[i] = shapes.getInt(i);
                            count *= shape[i];
                        } while (n6 <= n7);
                    }
                    if (offset + count * 4 > length) {
                        return null;
                    }
                    bb = ByteBuffer.wrap(allData, offset, count * 4);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    MTensor tensor = new MTensor(shape);
                    bb.asFloatBuffer().get(tensor.getData(), 0, count);
                    Map map = weights;
                    boolean bl3 = false;
                    map.put(key, tensor);
                    offset += count * 4;
                }
                return weights;
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utils.class);
            return null;
        }
    }
}

