/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0002J&\u0010\u0011\u001a\u00020\u000e2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J,\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0007j\b\u0012\u0004\u0012\u00020\u0004`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0007j\b\u0012\u0004\u0012\u00020\u0004`\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/appevents/integrity/SensitiveParamsManager;", "", "()V", "DEFAULT_SENSITIVE_PARAMS_KEY", "", "SENSITIVE_PARAMS_KEY", "defaultSensitiveParameters", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "enabled", "", "sensitiveParameters", "", "disable", "", "enable", "loadSensitiveParameters", "processFilterSensitiveParams", "parameters", "eventName", "shouldFilterOut", "parameterKey", "sensitiveParamsForEvent", "facebook-core_release"})
public final class SensitiveParamsManager {
    @NotNull
    public static final SensitiveParamsManager INSTANCE = new SensitiveParamsManager();
    private static boolean enabled;
    @NotNull
    private static HashSet<String> defaultSensitiveParameters;
    @NotNull
    private static Map<String, HashSet<String>> sensitiveParameters;
    @NotNull
    private static final String DEFAULT_SENSITIVE_PARAMS_KEY = "_MTSDK_Default_";
    @NotNull
    private static final String SENSITIVE_PARAMS_KEY = "_filteredKey";

    private SensitiveParamsManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(SensitiveParamsManager.class)) {
            return;
        }
        try {
            INSTANCE.loadSensitiveParameters();
            Object object = defaultSensitiveParameters;
            boolean bl = false;
            boolean bl2 = false;
            if (object == null || object.isEmpty()) {
                object = sensitiveParameters;
                bl = false;
                bl2 = false;
                if (object == null || object.isEmpty()) {
                    enabled = false;
                    return;
                }
            }
            enabled = true;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SensitiveParamsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void disable() {
        if (CrashShieldHandler.isObjectCrashing(SensitiveParamsManager.class)) {
            return;
        }
        try {
            enabled = false;
            sensitiveParameters = new HashMap();
            defaultSensitiveParameters = new HashSet();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SensitiveParamsManager.class);
            return;
        }
    }

    private final void loadSensitiveParameters() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (fetchedAppSettings == null) {
                return;
            }
            FetchedAppSettings settings = fetchedAppSettings;
            try {
                int n;
                int n2;
                defaultSensitiveParameters = new HashSet();
                sensitiveParameters = new HashMap();
                JSONArray sensitiveParamsFromServer = settings.getSensitiveParams();
                if (sensitiveParamsFromServer != null && sensitiveParamsFromServer.length() != 0 && (n2 = 0) < (n = sensitiveParamsFromServer.length())) {
                    do {
                        int i = n2++;
                        JSONObject jsonObject = sensitiveParamsFromServer.getJSONObject(i);
                        boolean hasEventName = jsonObject.has("key");
                        boolean hasSensitiveParams = jsonObject.has("value");
                        if (!hasEventName || !hasSensitiveParams) continue;
                        String sensitiveParamsScope = jsonObject.getString("key");
                        JSONArray sensitiveParams = jsonObject.getJSONArray("value");
                        String string = sensitiveParamsScope;
                        if (string == null) continue;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        JSONArray jSONArray = sensitiveParams;
                        if (jSONArray == null) continue;
                        JSONArray jSONArray2 = jSONArray;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        JSONArray it2 = jSONArray2;
                        boolean bl6 = false;
                        HashSet<String> hashSet = Utility.convertJSONArrayToHashSet(sensitiveParams);
                        if (hashSet == null) continue;
                        HashSet<String> hashSet2 = hashSet;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        HashSet<String> it3 = hashSet2;
                        boolean bl9 = false;
                        if (sensitiveParamsScope.equals(DEFAULT_SENSITIVE_PARAMS_KEY)) {
                            defaultSensitiveParameters = it3;
                            continue;
                        }
                        Map<String, HashSet<String>> map = sensitiveParameters;
                        Intrinsics.checkNotNullExpressionValue((Object)sensitiveParamsScope, (String)"sensitiveParamsScope");
                        String string3 = sensitiveParamsScope;
                        boolean bl10 = false;
                        map.put(string3, it3);
                    } while (n2 < n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void processFilterSensitiveParams(@NotNull Map<String, String> map, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(SensitiveParamsManager.class)) {
            return;
        }
        try {
            void eventName;
            Map<String, String> parameters;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!enabled) {
                return;
            }
            Collection collection = defaultSensitiveParameters;
            boolean bl = false;
            boolean bl2 = false;
            if ((collection == null || collection.isEmpty()) && !sensitiveParameters.containsKey(eventName)) {
                return;
            }
            JSONArray filteredParamsJSON = new JSONArray();
            try {
                HashSet<String> sensitiveParamsForEvent = sensitiveParameters.get(eventName);
                List keys = new ArrayList(parameters.keySet());
                for (String key : keys) {
                    if (!INSTANCE.shouldFilterOut(key, sensitiveParamsForEvent)) continue;
                    parameters.remove(key);
                    filteredParamsJSON.put((Object)key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (filteredParamsJSON.length() > 0) {
                Map<String, String> map2 = parameters;
                String string2 = SENSITIVE_PARAMS_KEY;
                String string3 = filteredParamsJSON.toString();
                boolean bl3 = false;
                map2.put(string2, string3);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SensitiveParamsManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldFilterOut(String string, HashSet<String> hashSet) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void sensitiveParamsForEvent;
            void parameterKey;
            if (defaultSensitiveParameters.contains(parameterKey)) return true;
            Collection collection = (Collection)sensitiveParamsForEvent;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null) return false;
            if (collection.isEmpty()) {
                return false;
            }
            boolean bl3 = false;
            if (bl3) return false;
            if (!sensitiveParamsForEvent.contains(parameterKey)) return false;
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    static {
        defaultSensitiveParameters = new HashSet();
        sensitiveParameters = new HashMap();
    }
}

