/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\t0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/appevents/integrity/RedactedEventsManager;", "", "()V", "enabled", "", "redactedEvents", "", "", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "disable", "", "enable", "getRedactionString", "eventName", "loadRedactedEvents", "processEventsRedaction", "facebook-core_release"})
public final class RedactedEventsManager {
    @NotNull
    public static final RedactedEventsManager INSTANCE = new RedactedEventsManager();
    private static boolean enabled;
    @NotNull
    private static Map<String, HashSet<String>> redactedEvents;

    private RedactedEventsManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(RedactedEventsManager.class)) {
            return;
        }
        try {
            INSTANCE.loadRedactedEvents();
            Map<String, HashSet<String>> map = redactedEvents;
            boolean bl = false;
            if (!map.isEmpty()) {
                enabled = true;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RedactedEventsManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void disable() {
        if (CrashShieldHandler.isObjectCrashing(RedactedEventsManager.class)) {
            return;
        }
        try {
            enabled = false;
            redactedEvents = new HashMap();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RedactedEventsManager.class);
            return;
        }
    }

    private final void loadRedactedEvents() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
            if (fetchedAppSettings == null) {
                return;
            }
            FetchedAppSettings settings = fetchedAppSettings;
            try {
                int n;
                int n2;
                redactedEvents = new HashMap();
                JSONArray redactedEventsFromServer = settings.getRedactedEvents();
                if (redactedEventsFromServer != null && redactedEventsFromServer.length() != 0 && (n2 = 0) < (n = redactedEventsFromServer.length())) {
                    do {
                        int i = n2++;
                        JSONObject jsonObject = redactedEventsFromServer.getJSONObject(i);
                        boolean hasKey = jsonObject.has("key");
                        boolean hasValue = jsonObject.has("value");
                        if (!hasKey || !hasValue) continue;
                        String redactedString = jsonObject.getString("key");
                        JSONArray eventsNeedToBeRedacted = jsonObject.getJSONArray("value");
                        String string = redactedString;
                        if (string == null) continue;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        HashSet<String> hashSet = Utility.convertJSONArrayToHashSet(eventsNeedToBeRedacted);
                        if (hashSet == null) continue;
                        HashSet<String> hashSet2 = hashSet;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        HashSet<String> it2 = hashSet2;
                        boolean bl6 = false;
                        Map<String, HashSet<String>> map = redactedEvents;
                        Intrinsics.checkNotNullExpressionValue((Object)redactedString, (String)"redactedString");
                        String string3 = redactedString;
                        boolean bl7 = false;
                        map.put(string3, it2);
                    } while (n2 < n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final String processEventsRedaction(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(RedactedEventsManager.class)) {
            return null;
        }
        try {
            String string2;
            String eventName;
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (enabled && (string2 = INSTANCE.getRedactionString(eventName)) != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                return it;
            }
            return eventName;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RedactedEventsManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getRedactionString(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            Iterable $this$forEach$iv = redactedEvents.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void eventName;
                String redactionString = (String)element$iv;
                boolean bl = false;
                HashSet<String> hashSet = redactedEvents.get(redactionString);
                if (hashSet == null) continue;
                HashSet<String> hashSet2 = hashSet;
                boolean bl2 = false;
                boolean bl3 = false;
                HashSet<String> it = hashSet2;
                boolean bl4 = false;
                if (!it.contains(eventName)) continue;
                return redactionString;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    static {
        redactedEvents = new HashMap();
    }
}

