/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\u001c\u0010\t\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/BoltsMeasurementEventListener;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "applicationContext", "close", "", "finalize", "onReceive", "intent", "Landroid/content/Intent;", "open", "Companion", "facebook-core_release"})
@AutoHandleExceptions
public final class BoltsMeasurementEventListener
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @Nullable
    private static BoltsMeasurementEventListener singleton;
    @NotNull
    private static final String MEASUREMENT_EVENT_NOTIFICATION_NAME;
    @NotNull
    private static final String MEASUREMENT_EVENT_NAME_KEY = "event_name";
    @NotNull
    private static final String MEASUREMENT_EVENT_ARGS_KEY = "event_args";
    @NotNull
    private static final String BOLTS_MEASUREMENT_EVENT_PREFIX = "bf_";

    private BoltsMeasurementEventListener(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.applicationContext = context2;
    }

    private final void open() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.applicationContext);
        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(applicationContext)");
        LocalBroadcastManager broadcastManager = localBroadcastManager;
        broadcastManager.registerReceiver((BroadcastReceiver)this, new IntentFilter(MEASUREMENT_EVENT_NOTIFICATION_NAME));
    }

    private final void close() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.applicationContext);
        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(applicationContext)");
        LocalBroadcastManager broadcastManager = localBroadcastManager;
        broadcastManager.unregisterReceiver((BroadcastReceiver)this);
    }

    public final void finalize() throws Throwable {
        this.close();
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        Set keySet;
        InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
        Intent intent2 = intent;
        String eventName = Intrinsics.stringPlus((String)BOLTS_MEASUREMENT_EVENT_PREFIX, intent2 == null ? null : intent2.getStringExtra(MEASUREMENT_EVENT_NAME_KEY));
        Intent intent3 = intent;
        Bundle eventArgs = intent3 == null ? null : intent3.getBundleExtra(MEASUREMENT_EVENT_ARGS_KEY);
        Bundle logData = new Bundle();
        Bundle bundle = eventArgs;
        Set set = keySet = bundle == null ? null : bundle.keySet();
        if (keySet != null) {
            for (String key : keySet) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                CharSequence charSequence = key;
                String string = "[^0-9a-zA-Z _-]";
                boolean bl = false;
                string = new Regex(string);
                String string2 = "-";
                boolean bl2 = false;
                charSequence = string.replace(charSequence, string2);
                string = "^[ -]*";
                boolean bl3 = false;
                string = new Regex(string);
                String string3 = "";
                bl2 = false;
                charSequence = string.replace(charSequence, string3);
                string = "[ -]*$";
                boolean bl4 = false;
                string = new Regex(string);
                String string4 = "";
                bl2 = false;
                String safeKey = string.replace(charSequence, string4);
                logData.putString(safeKey, (String)eventArgs.get(key));
            }
        }
        logger.logEvent(eventName, logData);
    }

    @JvmStatic
    @Nullable
    public static final BoltsMeasurementEventListener getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public /* synthetic */ BoltsMeasurementEventListener(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    static {
        MEASUREMENT_EVENT_NOTIFICATION_NAME = "com.parse.bolts.measurement_event";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/BoltsMeasurementEventListener$Companion;", "", "()V", "BOLTS_MEASUREMENT_EVENT_PREFIX", "", "MEASUREMENT_EVENT_ARGS_KEY", "MEASUREMENT_EVENT_NAME_KEY", "MEASUREMENT_EVENT_NOTIFICATION_NAME", "getMEASUREMENT_EVENT_NOTIFICATION_NAME$facebook_core_release$annotations", "getMEASUREMENT_EVENT_NOTIFICATION_NAME$facebook_core_release", "()Ljava/lang/String;", "singleton", "Lcom/facebook/internal/BoltsMeasurementEventListener;", "getInstance", "context", "Landroid/content/Context;", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMEASUREMENT_EVENT_NOTIFICATION_NAME$facebook_core_release() {
            return MEASUREMENT_EVENT_NOTIFICATION_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getMEASUREMENT_EVENT_NOTIFICATION_NAME$facebook_core_release$annotations() {
        }

        @JvmStatic
        @Nullable
        public final BoltsMeasurementEventListener getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (singleton != null) {
                return singleton;
            }
            BoltsMeasurementEventListener listener2 = new BoltsMeasurementEventListener(context, null);
            listener2.open();
            singleton = listener2;
            return singleton;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

