/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\nH\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/appevents/suggestedevents/SuggestedEventViewHierarchy;", "", "()V", "blacklistedViews", "", "Ljava/lang/Class;", "Landroid/view/View;", "getAllClickableViews", "view", "getDictionaryOfView", "Lorg/json/JSONObject;", "clickedView", "getTextOfChildren", "", "getTextOfViewRecursively", "hostView", "updateBasicInfo", "", "json", "facebook-core_release"})
@AutoHandleExceptions
public final class SuggestedEventViewHierarchy {
    @NotNull
    public static final SuggestedEventViewHierarchy INSTANCE = new SuggestedEventViewHierarchy();
    @NotNull
    private static final List<Class<? extends View>> blacklistedViews;

    private SuggestedEventViewHierarchy() {
    }

    @JvmStatic
    @NotNull
    public static final JSONObject getDictionaryOfView(@NotNull View view, @NotNull View clickedView) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)clickedView, (String)"clickedView");
        JSONObject json = new JSONObject();
        try {
            if (view == clickedView) {
                json.put("is_interacted", true);
            }
            SuggestedEventViewHierarchy.updateBasicInfo(view, json);
            JSONArray childViews = new JSONArray();
            List<View> children = ViewHierarchy.getChildrenOfView(view);
            for (View child : children) {
                JSONObject childInfo = SuggestedEventViewHierarchy.getDictionaryOfView(child, clickedView);
                childViews.put((Object)childInfo);
            }
            json.put("childviews", (Object)childViews);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    @JvmStatic
    public static final void updateBasicInfo(@NotNull View view, @NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            String text = ViewHierarchy.getTextOfView(view);
            String hint = ViewHierarchy.getHintOfView(view);
            json.put("classname", (Object)view.getClass().getSimpleName());
            json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view));
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                json.put("text", (Object)text);
            }
            charSequence = hint;
            bl = false;
            if (charSequence.length() > 0) {
                json.put("hint", (Object)hint);
            }
            if (view instanceof EditText) {
                json.put("inputtype", ((EditText)view).getInputType());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final List<View> getAllClickableViews(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        List clickableViews = new ArrayList();
        for (Class<? extends View> viewClass : blacklistedViews) {
            if (!viewClass.isInstance(view)) continue;
            return clickableViews;
        }
        if (view.isClickable()) {
            clickableViews.add(view);
        }
        List<View> children = ViewHierarchy.getChildrenOfView(view);
        for (View child : children) {
            clickableViews.addAll((Collection)SuggestedEventViewHierarchy.getAllClickableViews(child));
        }
        return clickableViews;
    }

    @JvmStatic
    @NotNull
    public static final String getTextOfViewRecursively(@NotNull View hostView) {
        Intrinsics.checkNotNullParameter((Object)hostView, (String)"hostView");
        String text = ViewHierarchy.getTextOfView(hostView);
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return text;
        }
        List<String> childrenText = INSTANCE.getTextOfChildren(hostView);
        String string = TextUtils.join((CharSequence)" ", (Iterable)childrenText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(\" \", childrenText)");
        return string;
    }

    private final List<String> getTextOfChildren(View view) {
        List childrenText = new ArrayList();
        List<View> childrenView = ViewHierarchy.getChildrenOfView(view);
        for (View childView : childrenView) {
            String childText = ViewHierarchy.getTextOfView(childView);
            CharSequence charSequence = childText;
            boolean bl = false;
            if (charSequence.length() > 0) {
                childrenText.add(childText);
            }
            childrenText.addAll((Collection)this.getTextOfChildren(childView));
        }
        return childrenText;
    }

    static {
        Object[] objectArray = new Class[]{Switch.class, Spinner.class, DatePicker.class, TimePicker.class, RadioGroup.class, RatingBar.class, EditText.class, AdapterView.class};
        blacklistedViews = CollectionsKt.listOf((Object[])objectArray);
    }
}

