/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceWrapper;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\u000e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/appevents/ondeviceprocessing/OnDeviceProcessingManager;", "", "()V", "ALLOWED_IMPLICIT_EVENTS", "", "", "isEventEligibleForOnDeviceProcessing", "", "event", "Lcom/facebook/appevents/AppEvent;", "isOnDeviceProcessingEnabled", "sendCustomEventAsync", "", "applicationId", "sendInstallEventAsync", "preferencesName", "facebook-core_release"})
@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class OnDeviceProcessingManager {
    @NotNull
    public static final OnDeviceProcessingManager INSTANCE = new OnDeviceProcessingManager();
    @NotNull
    private static final Set<String> ALLOWED_IMPLICIT_EVENTS;

    private OnDeviceProcessingManager() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isOnDeviceProcessingEnabled() {
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        if (FacebookSdk.getLimitEventAndDataUsage(context)) return false;
        if (Utility.INSTANCE.isDataProcessingRestricted()) return false;
        boolean bl = true;
        boolean isApplicationTrackingEnabled = bl;
        if (!isApplicationTrackingEnabled) return false;
        if (!RemoteServiceWrapper.INSTANCE.isServiceAvailable()) return false;
        return true;
    }

    @JvmStatic
    public static final void sendInstallEventAsync(@Nullable String applicationId, @Nullable String preferencesName) {
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        if (context != null && applicationId != null && preferencesName != null) {
            FacebookSdk.INSTANCE.getExecutor().execute(() -> OnDeviceProcessingManager.sendInstallEventAsync$lambda-0(context, preferencesName, applicationId));
        }
    }

    @JvmStatic
    public static final void sendCustomEventAsync(@NotNull String applicationId, @NotNull AppEvent event) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (INSTANCE.isEventEligibleForOnDeviceProcessing(event)) {
            FacebookSdk.INSTANCE.getExecutor().execute(() -> OnDeviceProcessingManager.sendCustomEventAsync$lambda-1(applicationId, event));
        }
    }

    private final boolean isEventEligibleForOnDeviceProcessing(AppEvent event) {
        boolean isAllowedImplicitEvent = event.isImplicit() && ALLOWED_IMPLICIT_EVENTS.contains(event.getName());
        boolean isExplicitEvent = !event.isImplicit();
        return isExplicitEvent || isAllowedImplicitEvent;
    }

    private static final void sendInstallEventAsync$lambda-0(Context $context, String $preferencesName, String $applicationId) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        SharedPreferences preferences = $context.getSharedPreferences($preferencesName, 0);
        String pingKey = Intrinsics.stringPlus((String)$applicationId, (Object)"pingForOnDevice");
        long lastOnDevicePing = preferences.getLong(pingKey, 0L);
        if (lastOnDevicePing == 0L) {
            RemoteServiceWrapper.sendInstallEvent($applicationId);
            SharedPreferences.Editor editor = preferences.edit();
            lastOnDevicePing = System.currentTimeMillis();
            editor.putLong(pingKey, lastOnDevicePing);
            editor.apply();
        }
    }

    private static final void sendCustomEventAsync$lambda-1(String $applicationId, AppEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        RemoteServiceWrapper.sendCustomEvents($applicationId, CollectionsKt.listOf((Object)$event));
    }

    static {
        Object[] objectArray = new String[]{"fb_mobile_purchase", "StartTrial", "Subscribe"};
        ALLOWED_IMPLICIT_EVENTS = SetsKt.setOf((Object[])objectArray);
    }
}

